/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.Cache;
import net.htmlparser.jericho.CharSequenceParseText;
import net.htmlparser.jericho.CharacterReference;
import net.htmlparser.jericho.Config;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.EncodingDetector;
import net.htmlparser.jericho.EndTag;
import net.htmlparser.jericho.EndTagType;
import net.htmlparser.jericho.Logger;
import net.htmlparser.jericho.LoggerDisabled;
import net.htmlparser.jericho.LoggerFactory;
import net.htmlparser.jericho.OutputDocument;
import net.htmlparser.jericho.ParseText;
import net.htmlparser.jericho.RowColumnVector;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.SourceFormatter;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.StreamedParseText;
import net.htmlparser.jericho.Tag;
import net.htmlparser.jericho.TagType;
import net.htmlparser.jericho.Util;

public final class Source
extends Segment
implements Iterable<Segment> {
    private final CharSequence sourceText;
    private String documentSpecifiedEncoding = "";
    private String encoding = "";
    private String encodingSpecificationInfo;
    private String preliminaryEncodingInfo = null;
    private String newLine = "";
    private ParseText parseText = null;
    private OutputDocument parseTextOutputDocument = null;
    Logger logger;
    private RowColumnVector[] rowColumnVectorCacheArray = null;
    final Cache cache;
    boolean useAllTypesCache = true;
    boolean useSpecialTypesCache = true;
    int[] fullSequentialParseData = null;
    Tag[] allTagsArray = null;
    List<Tag> allTags = null;
    List<StartTag> allStartTags = null;
    private List<Element> allElements = null;
    private List<Element> childElements = null;
    private static volatile String lastNewLine = null;
    private static final String UNINITIALISED = "";
    private static final String CR = "\r";
    private static final String LF = "\n";
    private static final String CRLF = "\r\n";
    static final String PACKAGE_NAME = "net.htmlparser.jericho";
    @Deprecated
    public static boolean LegacyIteratorCompatabilityMode = false;

    public Source(CharSequence text) {
        super(text.length());
        this.sourceText = text.toString();
        this.setLogger(Source.newLogger());
        this.cache = new Cache(this);
    }

    private Source(EncodingDetector encodingDetector) throws IOException {
        this(Source.getString(encodingDetector));
        this.encoding = encodingDetector.getEncoding();
        this.encodingSpecificationInfo = encodingDetector.getEncodingSpecificationInfo();
        this.preliminaryEncodingInfo = encodingDetector.getPreliminaryEncoding() + ": " + encodingDetector.getPreliminaryEncodingSpecificationInfo();
        encodingDetector.getLoggerQueue().outputTo(this.logger);
    }

    Source(Reader reader, String encoding) throws IOException {
        this(Util.getString(reader));
        if (encoding != null) {
            this.encoding = encoding;
            this.encodingSpecificationInfo = "InputStreamReader.getEncoding() of constructor argument";
        }
    }

    Source(CharSequence sourceText, StreamedParseText streamedParseText, String encoding, String encodingSpecificationInfo, String preliminaryEncodingInfo) {
        super(streamedParseText.getEnd());
        this.cache = Cache.STREAMED_SOURCE_MARKER;
        this.useAllTypesCache = false;
        this.useSpecialTypesCache = false;
        this.fullSequentialParseData = new int[1];
        if (encoding != null) {
            this.encoding = encoding;
        }
        this.encodingSpecificationInfo = encodingSpecificationInfo;
        this.preliminaryEncodingInfo = preliminaryEncodingInfo;
        this.sourceText = sourceText;
        this.parseText = streamedParseText;
        this.setLogger(Source.newLogger());
    }

    Source(CharSequence sourceText, boolean CHARACTER_REFERENCE_PARSE_METHOD) {
        super(sourceText.length());
        this.sourceText = sourceText;
        this.cache = null;
        this.useAllTypesCache = false;
        this.useSpecialTypesCache = false;
        this.setLogger(LoggerDisabled.INSTANCE);
    }

    public Source(Reader reader) throws IOException {
        this(reader, reader instanceof InputStreamReader ? ((InputStreamReader)reader).getEncoding() : null);
    }

    public Source(InputStream inputStream) throws IOException {
        this(new EncodingDetector(inputStream));
    }

    public Source(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public Source(URL url) throws IOException {
        this(new EncodingDetector(url.openConnection()));
    }

    public Source(URLConnection urlConnection) throws IOException {
        this(new EncodingDetector(urlConnection));
    }

    private String setEncoding(String encoding, String encodingSpecificationInfo) {
        if (this.encoding == UNINITIALISED) {
            this.encoding = encoding;
            this.encodingSpecificationInfo = encodingSpecificationInfo;
        }
        return encoding;
    }

    public String getDocumentSpecifiedEncoding() {
        return this.getDocumentSpecifiedEncoding(null);
    }

    final String getDocumentSpecifiedEncoding(EncodingDetector encodingDetector) {
        if (this.documentSpecifiedEncoding != UNINITIALISED) {
            return this.documentSpecifiedEncoding;
        }
        Tag xmlDeclarationTag = this.getTagAt(0);
        if (xmlDeclarationTag != null && xmlDeclarationTag.getTagType() == StartTagType.XML_DECLARATION) {
            this.documentSpecifiedEncoding = ((StartTag)xmlDeclarationTag).getAttributeValue("encoding");
            if (this.documentSpecifiedEncoding != null) {
                return this.setEncoding(this.documentSpecifiedEncoding, xmlDeclarationTag.toString());
            }
        }
        for (StartTag metaTag : this.getAllStartTags("meta")) {
            this.documentSpecifiedEncoding = metaTag.getAttributeValue("charset");
            if (this.documentSpecifiedEncoding == null) {
                String contentValue;
                if (!"content-type".equalsIgnoreCase(metaTag.getAttributeValue("http-equiv")) || (contentValue = metaTag.getAttributeValue("content")) == null) continue;
                this.documentSpecifiedEncoding = Source.getCharsetParameterFromHttpHeaderValue(contentValue);
                if (encodingDetector != null && encodingDetector.isIncompatibleWithPreliminaryEncoding(this.documentSpecifiedEncoding)) continue;
            }
            if (this.documentSpecifiedEncoding == null) continue;
            return this.setEncoding(this.documentSpecifiedEncoding, metaTag.toString());
        }
        return this.setEncoding(null, "No encoding specified in document");
    }

    public String getEncoding() {
        if (this.encoding == UNINITIALISED) {
            this.getDocumentSpecifiedEncoding();
        }
        return this.encoding;
    }

    public String getEncodingSpecificationInfo() {
        if (this.encoding == UNINITIALISED) {
            this.getDocumentSpecifiedEncoding();
        }
        return this.encodingSpecificationInfo;
    }

    public String getPreliminaryEncodingInfo() {
        return this.preliminaryEncodingInfo;
    }

    public boolean isXML() {
        Tag xmlDeclarationTag = this.getTagAt(0);
        if (xmlDeclarationTag != null && xmlDeclarationTag.getTagType() == StartTagType.XML_DECLARATION) {
            return true;
        }
        Tag doctypeTag = this.getNextTag(0, StartTagType.DOCTYPE_DECLARATION);
        return doctypeTag != null && this.getParseText().indexOf("xhtml", doctypeTag.begin, doctypeTag.end) != -1;
    }

    public String getNewLine() {
        if (this.newLine != UNINITIALISED) {
            return this.newLine;
        }
        for (int i = 0; i < this.end; ++i) {
            char ch = this.sourceText.charAt(i);
            if (ch == '\n') {
                this.newLine = LF;
            } else {
                if (ch != '\r') continue;
                this.newLine = ++i < this.end && this.sourceText.charAt(i) == '\n' ? CRLF : CR;
            }
            lastNewLine = this.newLine;
            return this.newLine;
        }
        this.newLine = null;
        return null;
    }

    String getBestGuessNewLine() {
        String newLine = this.getNewLine();
        if (newLine != null) {
            return newLine;
        }
        if (lastNewLine != null) {
            return lastNewLine;
        }
        return Config.NewLine;
    }

    public int getRow(int pos) {
        return this.getRowColumnVector(pos).getRow();
    }

    public int getColumn(int pos) {
        return this.getRowColumnVector(pos).getColumn();
    }

    public RowColumnVector getRowColumnVector(int pos) {
        if (pos > this.end) {
            throw new IndexOutOfBoundsException();
        }
        if (this.rowColumnVectorCacheArray == null) {
            this.rowColumnVectorCacheArray = RowColumnVector.getCacheArray(this);
        }
        return RowColumnVector.get(this.rowColumnVectorCacheArray, pos);
    }

    @Override
    public String toString() {
        return this.sourceText.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tag[] fullSequentialParse() {
        if (this.allTagsArray != null) {
            return this.allTagsArray;
        }
        boolean assumeNoNestedTags = false;
        if (this.cache.getTagCount() != 0) {
            this.logger.info("Full sequential parse clearing all tags from cache. Consider calling Source.fullSequentialParse() manually immediately after construction of Source.");
            this.cache.clear();
        }
        boolean useAllTypesCacheSave = this.useAllTypesCache;
        try {
            this.useAllTypesCache = false;
            this.useSpecialTypesCache = false;
            Tag[] tagArray = Tag.parseAll(this, false);
            return tagArray;
        }
        finally {
            this.useAllTypesCache = useAllTypesCacheSave;
            this.useSpecialTypesCache = true;
        }
    }

    @Override
    public Iterator<Segment> iterator() {
        return this.getNodeIterator();
    }

    @Override
    public List<Element> getChildElements() {
        if (this.childElements == null) {
            if (this.length() == 0) {
                this.childElements = Collections.emptyList();
            } else {
                StartTag childStartTag;
                if (this.allTags == null) {
                    this.fullSequentialParse();
                }
                this.childElements = new ArrayList<Element>();
                int pos = 0;
                while ((childStartTag = this.source.getNextStartTag(pos)) != null) {
                    if (childStartTag.getTagType().isServerTag()) {
                        pos = childStartTag.end;
                        continue;
                    }
                    Element childElement = childStartTag.getElement();
                    childElement.getChildElements(0);
                    if (childElement.parentElement == Element.NOT_CACHED) {
                        childElement.parentElement = null;
                        this.childElements.add(childElement);
                    }
                    pos = childElement.end;
                }
            }
        }
        return this.childElements;
    }

    public SourceFormatter getSourceFormatter() {
        return new SourceFormatter(this);
    }

    @Override
    public List<Tag> getAllTags() {
        if (this.allTags == null) {
            this.fullSequentialParse();
        }
        return this.allTags;
    }

    @Override
    public List<StartTag> getAllStartTags() {
        if (this.allStartTags == null) {
            List<Tag> allTags = this.getAllTags();
            this.allStartTags = new ArrayList<StartTag>(allTags.size());
            for (Tag tag : allTags) {
                if (!(tag instanceof StartTag)) continue;
                this.allStartTags.add((StartTag)tag);
            }
        }
        return this.allStartTags;
    }

    @Override
    public List<Element> getAllElements() {
        if (this.allElements == null) {
            List<StartTag> allStartTags = this.getAllStartTags();
            if (allStartTags.isEmpty()) {
                return Collections.emptyList();
            }
            this.allElements = new ArrayList<Element>(allStartTags.size());
            for (StartTag startTag : allStartTags) {
                this.allElements.add(startTag.getElement());
            }
        }
        return this.allElements;
    }

    public Element getElementById(String id) {
        return this.getFirstElement("id", id, true);
    }

    public final Tag getTagAt(int pos) {
        return Tag.getTagAt(this, pos, false);
    }

    public Tag getPreviousTag(int pos) {
        return Tag.getPreviousTag(this, pos);
    }

    public Tag getPreviousTag(int pos, TagType tagType) {
        return Tag.getPreviousTag(this, pos, tagType);
    }

    public Tag getNextTag(int pos) {
        return Tag.getNextTag(this, pos);
    }

    Tag getNextNonServerTag(int pos) {
        Tag tag;
        while ((tag = this.getNextTag(pos)) != null) {
            if (!tag.getTagType().isServerTag()) {
                return tag;
            }
            pos = tag.end;
        }
        return null;
    }

    Tag getPreviousNonServerTag(int pos) {
        Tag tag;
        while ((tag = this.getPreviousTag(pos - 1)) != null) {
            if (!tag.getTagType().isServerTag()) {
                return tag;
            }
            pos = tag.begin - 1;
        }
        return null;
    }

    public Tag getNextTag(int pos, TagType tagType) {
        return Tag.getNextTag(this, pos, tagType);
    }

    public Tag getEnclosingTag(int pos) {
        return this.getEnclosingTag(pos, null);
    }

    public Tag getEnclosingTag(int pos, TagType tagType) {
        Tag tag = this.getPreviousTag(pos, tagType);
        if (tag == null || tag.end <= pos) {
            return null;
        }
        return tag;
    }

    public Element getNextElement(int pos) {
        StartTag startTag = this.getNextStartTag(pos);
        return startTag == null ? null : startTag.getElement();
    }

    public Element getNextElement(int pos, String name) {
        StartTag startTag = this.getNextStartTag(pos, name);
        return startTag == null ? null : startTag.getElement();
    }

    public Element getNextElement(int pos, String attributeName, String value, boolean valueCaseSensitive) {
        StartTag startTag = this.getNextStartTag(pos, attributeName, value, valueCaseSensitive);
        return startTag == null ? null : startTag.getElement();
    }

    public Element getNextElement(int pos, String attributeName, Pattern valueRegexPattern) {
        StartTag startTag = this.getNextStartTag(pos, attributeName, valueRegexPattern);
        return startTag == null ? null : startTag.getElement();
    }

    public Element getNextElementByClass(int pos, String className) {
        StartTag startTag = this.getNextStartTagByClass(pos, className);
        return startTag == null ? null : startTag.getElement();
    }

    public StartTag getPreviousStartTag(int pos) {
        return StartTag.getPrevious(this, pos);
    }

    public StartTag getPreviousStartTag(int pos, StartTagType startTagType) {
        if (startTagType == null) {
            throw new IllegalArgumentException("startTagType argument must not be null");
        }
        return (StartTag)this.getPreviousTag(pos, startTagType);
    }

    public StartTag getPreviousStartTag(int pos, String name) {
        return this.getPreviousStartTag(pos, name, StartTagType.NORMAL);
    }

    public StartTag getPreviousStartTag(int pos, String name, StartTagType startTagType) {
        if (name != null) {
            name = name.toLowerCase();
        }
        return StartTag.getPrevious(this, pos, name, startTagType);
    }

    public StartTag getNextStartTag(int pos) {
        return StartTag.getNext(this, pos);
    }

    public StartTag getNextStartTag(int pos, StartTagType startTagType) {
        if (startTagType == null) {
            throw new IllegalArgumentException("startTagType argument must not be null");
        }
        return (StartTag)this.getNextTag(pos, startTagType);
    }

    public StartTag getNextStartTag(int pos, String name) {
        return this.getNextStartTag(pos, name, StartTagType.NORMAL);
    }

    public StartTag getNextStartTag(int pos, String name, StartTagType startTagType) {
        if (name != null) {
            name = name.toLowerCase();
        }
        return StartTag.getNext(this, pos, name, startTagType);
    }

    public StartTag getNextStartTag(int pos, String attributeName, String value, boolean valueCaseSensitive) {
        return StartTag.getNext(this, pos, attributeName, value, valueCaseSensitive);
    }

    public StartTag getNextStartTag(int pos, String attributeName, Pattern valueRegexPattern) {
        return StartTag.getNext(this, pos, attributeName, valueRegexPattern);
    }

    public StartTag getNextStartTagByClass(int pos, String className) {
        return this.getNextStartTag(pos, "class", Source.getClassPattern(className));
    }

    public EndTag getPreviousEndTag(int pos) {
        return EndTag.getPrevious(this, pos);
    }

    public EndTag getPreviousEndTag(int pos, EndTagType endTagType) {
        if (endTagType == null) {
            throw new IllegalArgumentException("endTagType argument must not be null");
        }
        return (EndTag)this.getPreviousTag(pos, endTagType);
    }

    public EndTag getPreviousEndTag(int pos, String name) {
        if (name != null) {
            name = name.toLowerCase();
        }
        return EndTag.getPrevious(this, pos, name, EndTagType.NORMAL);
    }

    public EndTag getNextEndTag(int pos) {
        return EndTag.getNext(this, pos);
    }

    public EndTag getNextEndTag(int pos, EndTagType endTagType) {
        if (endTagType == null) {
            throw new IllegalArgumentException("endTagType argument must not be null");
        }
        return (EndTag)this.getNextTag(pos, endTagType);
    }

    public EndTag getNextEndTag(int pos, String name) {
        return this.getNextEndTag(pos, name, EndTagType.NORMAL);
    }

    public EndTag getNextEndTag(int pos, String name, EndTagType endTagType) {
        if (name != null) {
            name = name.toLowerCase();
        }
        return EndTag.getNext(this, pos, name, endTagType);
    }

    public Element getEnclosingElement(int pos) {
        return this.getEnclosingElement(pos, null);
    }

    public Element getEnclosingElement(int pos, String name) {
        int startBefore = pos;
        if (name != null) {
            name = name.toLowerCase();
        }
        boolean isXMLTagName = Tag.isXMLName(name);
        StartTag startTag;
        while ((startTag = StartTag.getPrevious(this, startBefore, name, StartTagType.NORMAL, isXMLTagName)) != null) {
            Element element = startTag.getElement();
            if (pos < element.end) {
                return element;
            }
            startBefore = startTag.begin - 1;
        }
        return null;
    }

    public CharacterReference getPreviousCharacterReference(int pos) {
        return CharacterReference.getPrevious(this, pos);
    }

    public CharacterReference getNextCharacterReference(int pos) {
        return CharacterReference.getNext(this, pos);
    }

    public int getNameEnd(int pos) {
        if (!Tag.isXMLNameStartChar(this.sourceText.charAt(pos++))) {
            return -1;
        }
        try {
            while (Tag.isXMLNameChar(this.sourceText.charAt(pos))) {
                ++pos;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return pos;
    }

    public Attributes parseAttributes(int pos, int maxEnd) {
        return this.parseAttributes(pos, maxEnd, Attributes.getDefaultMaxErrorCount());
    }

    public Attributes parseAttributes(int pos, int maxEnd, int maxErrorCount) {
        return Attributes.construct(this, pos, maxEnd, maxErrorCount);
    }

    public void ignoreWhenParsing(int begin, int end) {
        if (this.wasFullSequentialParseCalled()) {
            throw new IllegalStateException("ignoreWhenParsing can not be used after a full sequential parse has been performed");
        }
        if (this.parseTextOutputDocument == null) {
            this.parseTextOutputDocument = new OutputDocument(this.getParseText());
            this.parseText = null;
        }
        this.parseTextOutputDocument.replaceWithSpaces(begin, end);
    }

    public void ignoreWhenParsing(Collection<? extends Segment> segments) {
        for (Segment segment : segments) {
            segment.ignoreWhenParsing();
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger != null ? logger : LoggerDisabled.INSTANCE;
    }

    public Logger getLogger() {
        return this.logger != LoggerDisabled.INSTANCE ? this.logger : null;
    }

    public void clearCache() {
        this.cache.clear();
        this.allTagsArray = null;
        this.allTags = null;
        this.allStartTags = null;
        this.allElements = null;
    }

    public String getCacheDebugInfo() {
        return this.cache.toString();
    }

    List<Tag> getParsedTags() {
        ArrayList<Tag> list = new ArrayList<Tag>();
        Iterator<Tag> i = this.cache.getTagIterator();
        while (i.hasNext()) {
            list.add(i.next());
        }
        return list;
    }

    public final ParseText getParseText() {
        if (this.parseText == null) {
            if (this.parseTextOutputDocument != null) {
                this.parseText = new CharSequenceParseText(this.parseTextOutputDocument.toString());
                this.parseTextOutputDocument = null;
            } else {
                this.parseText = new CharSequenceParseText(this.sourceText);
            }
        }
        return this.parseText;
    }

    @Override
    public final CharSequence subSequence(int begin, int end) {
        return this.sourceText.subSequence(begin, end);
    }

    final String substring(int begin, int end) {
        return this.subSequence(begin, end).toString();
    }

    final String getName(int begin, int end) {
        return this.substring(begin, end).toLowerCase();
    }

    @Override
    public final char charAt(int index) {
        return this.sourceText.charAt(index);
    }

    @Override
    public final int length() {
        return this.sourceText.length();
    }

    boolean wasFullSequentialParseCalled() {
        return this.allTagsArray != null;
    }

    static String getCharsetParameterFromHttpHeaderValue(String httpHeaderValue) {
        int charsetParameterPos = httpHeaderValue.toLowerCase().indexOf("charset=");
        if (charsetParameterPos == -1) {
            return null;
        }
        int charsetBegin = charsetParameterPos + 8;
        int charsetEnd = httpHeaderValue.indexOf(59, charsetBegin);
        String charset = charsetEnd == -1 ? httpHeaderValue.substring(charsetBegin) : httpHeaderValue.substring(charsetBegin, charsetEnd);
        return charset.trim();
    }

    static Logger newLogger() {
        return LoggerFactory.getLoggerProvider().getSourceLogger();
    }

    private static String getString(EncodingDetector encodingDetector) throws IOException {
        try {
            return Util.getString(encodingDetector.openReader());
        }
        catch (IOException ex) {
            try {
                Logger logger = Source.newLogger();
                encodingDetector.getLoggerQueue().outputTo(logger);
                if (logger.isErrorEnabled()) {
                    logger.error("IOException constructing encoded source. Encoding: " + encodingDetector.getEncoding() + " - " + encodingDetector.getEncodingSpecificationInfo() + ". PreliminaryEncoding: " + encodingDetector.getPreliminaryEncoding() + " - " + encodingDetector.getPreliminaryEncodingSpecificationInfo());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
    }

    final boolean isStreamed() {
        return this.cache == Cache.STREAMED_SOURCE_MARKER;
    }
}

