/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.lang.expression;

import java.util.List;
import org.snpeff.vcf.EffFormatVersion;
import org.snpeff.vcf.VcfEffect;
import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfHeader;
import org.snpeff.vcf.VcfHeaderInfo;
import org.snpeff.vcf.VcfInfoType;
import org.snpsift.lang.expression.Expression;
import org.snpsift.lang.expression.FieldIterator;
import org.snpsift.lang.expression.FieldSub;

public class FieldEff
extends FieldSub {
    String fieldName;
    EffFormatVersion formatVersion = null;

    public FieldEff(String name, Expression idxExpr, EffFormatVersion formatVersion, String fieldName) {
        super(name, idxExpr);
        this.formatVersion = formatVersion;
        this.fieldName = fieldName.toUpperCase();
    }

    String annEff() {
        if (this.formatVersion == null) {
            return this.fieldName;
        }
        return this.formatVersion.isAnn() ? "ANN" : "EFF";
    }

    @Override
    public String getFieldString(VcfEntry vcfEntry) {
        List<VcfEffect> effects = vcfEntry.getVcfEffects(this.formatVersion);
        if (effects.size() <= 0) {
            return null;
        }
        int index2 = this.evalIndex(vcfEntry);
        if (index2 >= effects.size()) {
            return null;
        }
        int idx = index2;
        if (index2 < 0) {
            FieldIterator.get().setMax(FieldIterator.IteratorType.EFFECT, effects.size() - 1);
            FieldIterator.get().setType(index2);
            idx = FieldIterator.get().get(FieldIterator.IteratorType.EFFECT);
        }
        VcfEffect eff = effects.get(idx);
        String value2 = this.getSubField(eff, vcfEntry);
        return value2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public VcfInfoType getReturnType(VcfEntry vcfEntry) {
        String headerName;
        if (this.name == null) {
            return VcfInfoType.String;
        }
        if (this.returnType != VcfInfoType.UNKNOWN) {
            return this.returnType;
        }
        VcfHeader vcfHeader = vcfEntry.getVcfFileIterator().getVcfHeader();
        VcfHeaderInfo vcfInfo = vcfHeader.getVcfHeaderInfo(headerName = this.annEff() + "." + this.name);
        if (vcfInfo == null) {
            throw new RuntimeException("Sub-field '" + headerName + "' not found in VCF header");
        }
        this.returnType = vcfInfo.getVcfInfoType();
        return this.returnType;
    }

    String getSubField(VcfEffect eff, VcfEntry vcfEntry) {
        if (eff == null) {
            return (String)this.fieldNotFound(vcfEntry);
        }
        if (this.name == null) {
            return eff.getVcfFieldString();
        }
        String value2 = eff.getFieldByName(this.name);
        if (value2 == null) {
            return (String)this.fieldNotFound(vcfEntry);
        }
        return value2;
    }

    @Override
    public String toString() {
        return this.annEff() + "[" + this.indexExpr + "]" + (this.name != null ? "." + this.name : "");
    }
}

