/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.annotate;

import gnu.trove.list.array.TIntArrayList;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Interval;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;
import org.snpeff.interval.Variant;
import org.snpeff.interval.tree.Itree;
import org.snpeff.util.Gpr;
import org.snpeff.util.Timer;
import org.snpeff.vcf.VcfEntry;
import org.snpsift.annotate.VcfIndexDataChromo;

public class VcfIndexTree
implements Itree {
    public static final int COLLAPSE_MAX_NUM_ENTRIES = 4;
    public static final int DEFAULT_MAX_BLOCK_SIZE = 16384;
    public static final int INITIAL_CAPACITY = 1024;
    public static final int MAX_DIFF_COLLAPSE = 2;
    boolean debug;
    boolean verbose;
    boolean inSync;
    String chromosome;
    VcfFileIterator vcf;
    VcfIndexDataChromo vcfIndexChromo;
    int[] left;
    int[] right;
    int[] mid;
    long[][] intersectFilePosStart;
    long[][] intersectFilePosEnd;
    int size;
    int maxBlockSize = 16384;
    List<VcfEntry>[] intersect;
    int cachedLeafNodeIdx = -1;
    List<VcfEntry> cachedLeafNode = null;

    public VcfIndexTree() {
        this(null, null);
    }

    public VcfIndexTree(VcfFileIterator vcf, VcfIndexDataChromo vcfIndexChromo) {
        this.vcfIndexChromo = vcfIndexChromo;
        this.chromosome = vcfIndexChromo != null ? vcfIndexChromo.getChromosome() : null;
        this.left = new int[1024];
        this.right = new int[1024];
        this.mid = new int[1024];
        this.intersectFilePosStart = new long[1024][];
        this.intersectFilePosEnd = new long[1024][];
        this.intersect = new List[1024];
        this.size = 0;
    }

    @Override
    public void add(Marker interval) {
        throw new RuntimeException("Unimplemented! This IntervalTree is backed by a VcfIndexDataChromo class instead of a set of markers");
    }

    @Override
    public void add(Markers markers) {
        throw new RuntimeException("Unimplemented! This IntervalTree is backed by a VcfIndexDataChromo class instead of a set of markers");
    }

    @Override
    public void build() {
        TIntArrayList idxs = new TIntArrayList(this.vcfIndexChromo.size());
        for (int i = 0; i < this.vcfIndexChromo.size(); ++i) {
            idxs.add(i);
        }
        this.build(idxs);
        this.inSync = true;
    }

    int build(TIntArrayList idxs) {
        int j;
        int i;
        int firstStart;
        if (idxs.isEmpty()) {
            return -1;
        }
        int center = this.mean(idxs);
        if (center > (firstStart = this.vcfIndexChromo.getStart(idxs.get(0)))) {
            --center;
        }
        int idx = this.nextEntry();
        TIntArrayList left = new TIntArrayList();
        TIntArrayList right = new TIntArrayList();
        TIntArrayList intersecting = new TIntArrayList();
        if (this.consecutiveFileBlock(idxs) && (idxs.size() < 4 || this.consecutiveFileBlockSize(idxs) < (long)this.maxBlockSize)) {
            for (i = 0; i < idxs.size(); ++i) {
                j = idxs.get(i);
                intersecting.add(j);
            }
        } else {
            for (i = 0; i < idxs.size(); ++i) {
                j = idxs.get(i);
                if (this.vcfIndexChromo.getEnd(j) < center) {
                    left.add(j);
                    continue;
                }
                if (this.vcfIndexChromo.getStart(j) > center) {
                    right.add(j);
                    continue;
                }
                intersecting.add(j);
            }
        }
        int leftIdx = this.build(left);
        int rightIdx = this.build(right);
        this.set(idx, leftIdx, rightIdx, center, intersecting);
        return idx;
    }

    int capacity() {
        if (this.left == null) {
            return 0;
        }
        return this.left.length;
    }

    boolean consecutiveFileBlock(TIntArrayList idxs) {
        long end = -1L;
        for (int i = 0; i < idxs.size(); ++i) {
            long start;
            int idx = idxs.get(i);
            if (end < 0L) {
                end = this.vcfIndexChromo.getFilePosEnd(idx);
            }
            if ((start = this.vcfIndexChromo.getFilePosStart(idx)) - end > 0L) {
                return false;
            }
            end = this.vcfIndexChromo.getFilePosEnd(idx);
        }
        return true;
    }

    long consecutiveFileBlockMax(TIntArrayList idxs) {
        long max2 = -1L;
        for (int i = 0; i < idxs.size(); ++i) {
            int idx = idxs.get(i);
            max2 = Math.max(max2, this.vcfIndexChromo.getFilePosEnd(idx));
        }
        return max2;
    }

    long consecutiveFileBlockMin(TIntArrayList idxs) {
        long min2 = Long.MAX_VALUE;
        for (int i = 0; i < idxs.size(); ++i) {
            int idx = idxs.get(i);
            min2 = Math.min(min2, this.vcfIndexChromo.getFilePosStart(idx));
        }
        return min2;
    }

    long consecutiveFileBlockSize(TIntArrayList idxs) {
        long max2 = -1L;
        long min2 = Long.MAX_VALUE;
        for (int i = 0; i < idxs.size(); ++i) {
            int idx = idxs.get(i);
            min2 = Math.min(min2, this.vcfIndexChromo.getFilePosStart(idx));
            max2 = Math.max(max2, this.vcfIndexChromo.getFilePosEnd(idx));
        }
        return max2 - min2;
    }

    public String getChromosome() {
        return this.chromosome;
    }

    @Override
    public Markers getIntervals() {
        throw new RuntimeException("Unimplemented! This IntervalTree is backed by a VcfIndexDataChromo class instead of a set of markers");
    }

    void grow() {
        int oldCapacity = this.capacity();
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        this.left = Arrays.copyOf(this.left, newCapacity);
        this.right = Arrays.copyOf(this.right, newCapacity);
        this.mid = Arrays.copyOf(this.mid, newCapacity);
        this.intersectFilePosStart = (long[][])Arrays.copyOf(this.intersectFilePosStart, newCapacity);
        this.intersectFilePosEnd = (long[][])Arrays.copyOf(this.intersectFilePosEnd, newCapacity);
        this.intersect = Arrays.copyOf(this.intersect, newCapacity);
    }

    int[] intersectIndexes(int startIdx, int endIdx, int pos) {
        ArrayList<Integer> list2 = null;
        for (int idx = startIdx; idx <= endIdx; ++idx) {
            if (!this.vcfIndexChromo.intersects(idx, pos)) continue;
            if (list2 == null) {
                list2 = new ArrayList<Integer>();
            }
            list2.add(idx);
        }
        if (list2 == null) {
            return new int[0];
        }
        int i = 0;
        int[] ints = new int[list2.size()];
        Iterator iterator2 = list2.iterator();
        while (iterator2.hasNext()) {
            int idx = (Integer)iterator2.next();
            ints[i++] = idx;
        }
        return ints;
    }

    @Override
    public boolean isEmpty() {
        return this.vcfIndexChromo.size() <= 0;
    }

    @Override
    public boolean isInSync() {
        return this.inSync;
    }

    boolean isLeaf(int idx) {
        return this.left[idx] == -1 && this.right[idx] == -1;
    }

    @Override
    public Iterator<Marker> iterator() {
        return null;
    }

    public boolean load(DataInputStream in) {
        try {
            this.chromosome = in.readUTF();
            this.size = in.readInt();
            if (this.verbose) {
                Timer.showStdErr("\tReading index for chromosome '" + this.chromosome + "' (index size: " + this.size + " )");
            }
            if (this.size < 0) {
                return false;
            }
            this.left = new int[this.size];
            this.right = new int[this.size];
            this.mid = new int[this.size];
            this.intersectFilePosStart = new long[this.size][];
            this.intersectFilePosEnd = new long[this.size][];
            this.intersect = new List[this.size];
            for (int i = 0; i < this.size; ++i) {
                this.left[i] = in.readInt();
                this.right[i] = in.readInt();
                this.mid[i] = in.readInt();
                int len = in.readInt();
                if (len > 0) {
                    this.intersectFilePosStart[i] = new long[len];
                    this.intersectFilePosEnd[i] = new long[len];
                    for (int j = 0; j < len; ++j) {
                        this.intersectFilePosStart[i][j] = in.readLong();
                        this.intersectFilePosEnd[i][j] = in.readLong();
                    }
                    continue;
                }
                this.intersectFilePosEnd[i] = null;
                this.intersectFilePosStart[i] = null;
            }
        }
        catch (EOFException e) {
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    @Override
    public void load(String fileName, Genome genome) {
        throw new RuntimeException("Unimplemented! This IntervalTree is loaded as part of a whole index");
    }

    int mean(TIntArrayList idxs) {
        if (idxs.isEmpty()) {
            return 0;
        }
        TIntArrayList coordinates = new TIntArrayList(2 * idxs.size());
        for (int i = 0; i < idxs.size(); ++i) {
            int idx = idxs.get(i);
            coordinates.add(this.vcfIndexChromo.getStart(idx));
            coordinates.add(this.vcfIndexChromo.getEnd(idx));
        }
        coordinates.sort();
        return coordinates.get(coordinates.size() / 2);
    }

    int nextEntry() {
        if (this.size >= this.capacity()) {
            this.grow();
        }
        return this.size++;
    }

    @Override
    public Markers query(Interval queryMarker) {
        Markers results = new Markers();
        if (this.debug) {
            Gpr.debug("Query: " + queryMarker.getChromosomeName() + ":" + queryMarker.getStart() + "-" + queryMarker.getEnd() + "\t" + queryMarker);
        }
        this.query(queryMarker, 0, results);
        return results;
    }

    protected void query(Interval queryMarker, int idx, Markers results) {
        if (idx < 0) {
            return;
        }
        if (this.debug) {
            Gpr.debug("Node: " + this.toString(idx) + (results.isEmpty() ? "" : "\n\tResults: " + results));
        }
        this.queryIntersects(queryMarker, idx, results);
        int midPos = this.mid[idx];
        if (queryMarker.getEnd() < midPos && this.left[idx] >= 0) {
            this.query(queryMarker, this.left[idx], results);
        }
        if (midPos < queryMarker.getStart() && this.right[idx] >= 0) {
            this.query(queryMarker, this.right[idx], results);
        }
    }

    protected void queryIntersects(Interval queryMarker, int idx, Markers results) {
        if (this.intersectFilePosStart[idx] == null) {
            return;
        }
        if (this.debug) {
            Gpr.debug("queryIntersects\tidx: " + idx);
        }
        List<VcfEntry> vcfEntries = this.readEntries(idx);
        for (VcfEntry ve : vcfEntries) {
            for (Variant var : ve.variants()) {
                if (!var.intersects(queryMarker)) continue;
                if (this.debug) {
                    Gpr.debug("\tAdding matching result: " + ve);
                }
                results.add(ve);
                break;
            }
            if (queryMarker.getEnd() >= ve.getStart()) continue;
            return;
        }
    }

    List<VcfEntry> readEntries(int idx) {
        if (this.cachedLeafNodeIdx == idx) {
            return this.cachedLeafNode;
        }
        List<VcfEntry> vcfEntries = this.intersect[idx];
        if (vcfEntries != null) {
            return vcfEntries;
        }
        try {
            int len = this.intersectFilePosStart[idx].length;
            vcfEntries = new ArrayList<VcfEntry>();
            HashSet<VcfEntry> added = new HashSet<VcfEntry>();
            block2: for (int i = 0; i < len; ++i) {
                if (this.debug) {
                    Gpr.debug("\tintersect[" + idx + "][" + i + "]:\t[" + this.intersectFilePosStart[idx][i] + " , " + this.intersectFilePosEnd[idx][i] + " ]");
                }
                long startPos = this.intersectFilePosStart[idx][i];
                long endPos = this.intersectFilePosEnd[idx][i];
                this.vcf.seek(startPos);
                for (VcfEntry ve : this.vcf) {
                    if (added.add(ve)) {
                        vcfEntries.add(ve);
                        if (this.debug) {
                            Gpr.debug("\tParsing VcfEntry [" + this.vcf.getFilePointer() + "]: " + ve);
                        }
                    }
                    if (this.vcf.getFilePointer() < endPos) continue;
                    continue block2;
                }
            }
            if (this.isLeaf(idx)) {
                this.cachedLeafNodeIdx = idx;
                this.cachedLeafNode = vcfEntries;
            } else if (this.intersect[idx] == null) {
                this.intersect[idx] = vcfEntries;
            }
            return vcfEntries;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void save(DataOutputStream out) {
        try {
            out.writeUTF(this.chromosome);
            out.writeInt(this.size);
            for (int i = 0; i < this.size; ++i) {
                out.writeInt(this.left[i]);
                out.writeInt(this.right[i]);
                out.writeInt(this.mid[i]);
                int len = this.intersectFilePosStart[i] != null ? this.intersectFilePosStart[i].length : 0;
                out.writeInt(len);
                for (int j = 0; j < len; ++j) {
                    out.writeLong(this.intersectFilePosStart[i][j]);
                    out.writeLong(this.intersectFilePosEnd[i][j]);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void set(int idx, int leftIdx, int rightIdx, int midPos, TIntArrayList intersecting) {
        this.left[idx] = leftIdx;
        this.right[idx] = rightIdx;
        this.mid[idx] = midPos;
        if (intersecting.isEmpty()) {
            this.intersectFilePosEnd[idx] = null;
            this.intersectFilePosStart[idx] = null;
        } else if (intersecting.size() > 0 && this.consecutiveFileBlock(intersecting)) {
            this.intersectFilePosStart[idx] = new long[1];
            this.intersectFilePosEnd[idx] = new long[1];
            this.intersectFilePosStart[idx][0] = this.consecutiveFileBlockMin(intersecting);
            this.intersectFilePosEnd[idx][0] = this.consecutiveFileBlockMax(intersecting);
        } else {
            this.intersectFilePosStart[idx] = new long[intersecting.size()];
            this.intersectFilePosEnd[idx] = new long[intersecting.size()];
            for (int i = 0; i < intersecting.size(); ++i) {
                int j = intersecting.get(i);
                this.intersectFilePosStart[idx][i] = this.vcfIndexChromo.getFilePosStart(j);
                this.intersectFilePosEnd[idx][i] = this.vcfIndexChromo.getFilePosEnd(j);
            }
        }
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setMaxBlockSize(int maxBlockSize) {
        this.maxBlockSize = maxBlockSize;
    }

    public void setVcf(VcfFileIterator vcf) {
        this.vcf = vcf;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Markers stab(int point) {
        throw new RuntimeException("Unimplemented! ");
    }

    public String toString() {
        return "Chromosome: " + this.chromosome + ", size: " + this.size + ", capacity: " + this.capacity();
    }

    public String toString(int idx) {
        if (idx < 0) {
            return "None";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(idx + "\tleftIdx: " + this.left[idx] + "\trightIdx: " + this.right[idx] + "\tmidPos: " + this.mid[idx]);
        if (this.intersectFilePosStart[idx] != null) {
            sb.append("\tintersect: (" + this.intersectFilePosStart[idx].length + "): ");
            for (int i = 0; i < this.intersectFilePosStart[idx].length; ++i) {
                sb.append("\t[" + this.intersectFilePosStart[idx][i] + ", " + this.intersectFilePosEnd[idx][i] + "] size " + (this.intersectFilePosEnd[idx][i] - this.intersectFilePosStart[idx][i] + 1L));
            }
        }
        if (this.intersect[idx] != null) {
            sb.append("\tCache: " + this.intersect[idx].size());
        }
        return sb.toString();
    }

    public String toStringAll() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.toString() + "\n");
        for (int i = 0; i < this.size; ++i) {
            sb.append("\t" + this.toString(i) + "\n");
        }
        return sb.toString();
    }
}

