/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.interval.Variant;
import org.snpeff.util.Gpr;
import org.snpeff.util.Timer;
import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfInfoType;
import org.snpsift.SnpSift;
import org.snpsift.fileIterator.DbNsfp;
import org.snpsift.fileIterator.DbNsfpEntry;

public class SnpSiftCmdDbNsfp
extends SnpSift {
    public static final String DBNSFP_VCF_INFO_PREFIX = "dbNSFP_";
    public static final String DEFAULT_FIELDS_NAMES_TO_ADD = "Uniprot_acc,Interpro_domain,SIFT_pred,Polyphen2_HDIV_pred,Polyphen2_HVAR_pred,LRT_pred,MutationTaster_pred,GERP++_NR,GERP++_RS,phastCons100way_vertebrate,1000Gp1_AF,1000Gp1_AFR_AF,1000Gp1_EUR_AF,1000Gp1_AMR_AF,1000Gp1_ASN_AF,ESP6500_AA_AF,ESP6500_EA_AF,MutationTaster_pred,MutationAssessor_pred,FATHMM_pred,PROVEAN_pred,CADD_phred,MetaSVM_pred,1000Gp3_AC,1000Gp3_AF,1000Gp3_AFR_AC,1000Gp3_AFR_AF,1000Gp3_EUR_AC,1000Gp3_EUR_AF,1000Gp3_AMR_AC,1000Gp3_AMR_AF,1000Gp3_EAS_AC,1000Gp3_EAS_AF,1000Gp3_SAS_AC,1000Gp3_SAS_AF,ESP6500_AA_AC,ESP6500_AA_AF,ESP6500_EA_AC,ESP6500_EA_AF,ExAC_AC,ExAC_AF,ExAC_Adj_AC,ExAC_Adj_AF,ExAC_AFR_AC,ExAC_AFR_AF,ExAC_AMR_AC,ExAC_AMR_AF,ExAC_EAS_AC,ExAC_EAS_AF,ExAC_FIN_AC,ExAC_FIN_AF,ExAC_NFE_AC,ExAC_NFE_AF,ExAC_SAS_AC,ExAC_SAS_AF";
    public static final int MIN_JUMP = 100;
    public static final int SHOW_EVERY = 100;
    public final String CONFIG_DBNSFP_DB_NAME = "dbnsfp";
    protected Map<String, String> fieldsToAdd;
    protected Map<String, String> fieldsDescription;
    protected Map<String, String> fieldsType;
    protected boolean annotateEmpty;
    protected boolean annotateMissing;
    protected boolean collapseRepeatedValues;
    protected boolean inverseFieldSelection;
    protected boolean tabixCheck = true;
    protected String vcfFileName;
    protected int count = 0;
    protected int countAnnotated = 0;
    protected int countVariants = 0;
    protected DbNsfp dbNsfp;
    protected VcfFileIterator vcfFile;
    protected DbNsfpEntry currentDbEntry;
    protected String fieldsNamesToAdd;
    String latestChromo = "";

    public SnpSiftCmdDbNsfp() {
        this(null);
    }

    public SnpSiftCmdDbNsfp(String[] args) {
        super(args);
    }

    @Override
    public boolean addHeaders(VcfFileIterator vcfFile) {
        super.addHeaders(vcfFile);
        for (String key : this.fieldsToAdd.keySet()) {
            String type = this.fieldsType.get(key);
            if (type == null) {
                System.err.println("WARNING: Cannot find type for field '" + key + "', using 'String'.");
                type = VcfInfoType.String.toString();
            }
            String infoKey = VcfEntry.vcfInfoKeySafe(DBNSFP_VCF_INFO_PREFIX + key);
            vcfFile.getVcfHeader().addLine("##INFO=<ID=" + infoKey + ",Number=A,Type=" + type + ",Description=\"" + this.fieldsToAdd.get(key) + "\">");
        }
        return false;
    }

    ArrayList<VcfEntry> annotate(boolean createList) {
        ArrayList<VcfEntry> list2 = createList ? new ArrayList<VcfEntry>() : null;
        this.vcfFile = new VcfFileIterator(this.vcfFileName);
        this.vcfFile.setDebug(this.debug);
        try {
            this.annotateInit(this.vcfFile);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.verbose) {
            Timer.showStdErr("Annotating file '" + this.vcfFileName + "'");
        }
        boolean showHeader = true;
        int pos = -1;
        String chr = "";
        for (VcfEntry vcfEntry : this.vcfFile) {
            try {
                if (showHeader) {
                    this.processVcfHeader(this.vcfFile);
                    showHeader = false;
                    this.checkFieldsToAdd();
                }
                if (vcfEntry.getChromosomeName().equals(chr) && vcfEntry.getStart() < pos) {
                    this.fatalError("Your VCF file should be sorted!\n\tPrevious entry " + chr + ":" + pos + "\n\tCurrent entry  " + vcfEntry.getChromosomeName() + ":" + (vcfEntry.getStart() + 1));
                }
                this.annotate(vcfEntry);
                this.print(vcfEntry);
                if (list2 != null) {
                    list2.add(vcfEntry);
                }
                ++this.count;
                chr = vcfEntry.getChromosomeName();
                pos = vcfEntry.getStart();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.annotateFinish(this.vcfFile);
        if (this.verbose) {
            double perc = 100.0 * (double)this.countAnnotated / (double)this.count;
            Timer.showStdErr("Done.\n\tTotal annotated entries : " + this.countAnnotated + "\n\tTotal entries           : " + this.count + "\n\tPercent                 : " + String.format("%.2f%%", perc));
        }
        return list2;
    }

    public boolean annotate(Variant variant, Map<String, String> info) {
        if (this.verbose) {
            Gpr.showMark(++this.countVariants, 100);
        }
        if (!variant.isSnp()) {
            return false;
        }
        Collection<DbNsfpEntry> dbEntries = this.dbNsfp.query(variant);
        if (dbEntries == null || dbEntries.isEmpty()) {
            if (!this.annotateMissing) {
                return false;
            }
            if (dbEntries == null) {
                dbEntries = new LinkedList<DbNsfpEntry>();
            }
        }
        boolean annotated = false;
        for (String fieldKey : this.fieldsToAdd.keySet()) {
            String infoValue = this.getVcfInfo(dbEntries, fieldKey);
            if (this.annotateEmpty || this.annotateMissing) {
                if (infoValue.isEmpty()) {
                    infoValue = ".";
                }
            } else if (this.isDbNsfpValueEmpty(infoValue)) {
                infoValue = null;
            }
            if (infoValue == null) continue;
            String oldInfo = info.get(fieldKey);
            if (oldInfo == null) {
                oldInfo = "";
            }
            info.put(fieldKey, oldInfo + (oldInfo.isEmpty() ? "" : ",") + infoValue);
            annotated = true;
        }
        if (annotated) {
            ++this.countAnnotated;
            if (this.debug) {
                Gpr.debug("Annotated: " + variant.toStr());
            }
        }
        return annotated;
    }

    @Override
    public boolean annotate(VcfEntry vcfEntry) {
        boolean annotated = false;
        HashMap<String, String> info = new HashMap<String, String>();
        for (Variant var : vcfEntry.variants()) {
            annotated |= this.annotate(var, info);
        }
        if (annotated) {
            ArrayList keys = new ArrayList();
            keys.addAll(info.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                String infoKey = VcfEntry.vcfInfoKeySafe(DBNSFP_VCF_INFO_PREFIX + key);
                vcfEntry.addInfo(infoKey, (String)info.get(key));
            }
        }
        return annotated;
    }

    @Override
    public boolean annotateFinish(VcfFileIterator vcfFile) {
        super.annotateFinish(vcfFile);
        if (this.dbNsfp != null) {
            this.dbNsfp.close();
        }
        return true;
    }

    @Override
    public boolean annotateInit(VcfFileIterator vcfFile) {
        this.vcfFile = vcfFile;
        if (this.dbFileName == null && this.config != null) {
            this.dbFileName = this.config.getDatabaseLocal("dbnsfp");
        }
        this.dbNsfp = new DbNsfp(this.dbFileName);
        this.dbNsfp.setDebug(this.debug);
        this.dbNsfp.setVerbose(this.verbose);
        this.dbNsfp.open();
        this.annotateInitFields();
        return true;
    }

    void annotateInitFields() {
        String dbNsfpFields;
        if (this.fieldsNamesToAdd == null && (dbNsfpFields = this.config.getDbNsfpFields()) != null && !dbNsfpFields.isEmpty()) {
            this.fieldsNamesToAdd = dbNsfpFields;
            if (this.verbose) {
                Timer.showStdErr("Using fields from config file: '" + this.fieldsNamesToAdd + "'");
            }
        }
        VcfInfoType[] types = this.dbNsfp.getTypes();
        String[] fieldNames = this.dbNsfp.getFieldNamesSorted();
        if (this.verbose) {
            Timer.showStdErr("Database fields:");
        }
        for (int i = 0; i < fieldNames.length; ++i) {
            String[] type = types[i] != null ? types[i].toString() : "String";
            this.fieldsType.put(fieldNames[i], (String)type);
            this.fieldsDescription.put(fieldNames[i], "Field '" + fieldNames[i] + "' from dbNSFP");
            if (!this.verbose) continue;
            System.err.println("\t\t\t'" + fieldNames[i] + "'");
        }
        this.currentDbEntry = null;
        if (this.inverseFieldSelection) {
            String[] fields = new HashSet();
            fields.addAll(this.fieldsDescription.keySet());
            if (this.fieldsNamesToAdd != null) {
                for (String fn : this.fieldsNamesToAdd.split(",")) {
                    fields.remove(fn);
                }
            }
            ArrayList fieldsSort = new ArrayList();
            fieldsSort.addAll(fields);
            Collections.sort(fieldsSort);
            for (String fn : fieldsSort) {
                this.fieldsToAdd.put(fn, this.fieldsDescription.get(fn));
            }
        } else {
            if (this.fieldsNamesToAdd == null) {
                this.fieldsNamesToAdd = DEFAULT_FIELDS_NAMES_TO_ADD;
            }
            for (String fn : this.fieldsNamesToAdd.split(",")) {
                if (this.fieldsDescription.get(fn) == null) {
                    if (this.fieldsNamesToAdd == DEFAULT_FIELDS_NAMES_TO_ADD) {
                        if (!this.verbose) continue;
                        Timer.showStdErr("Warning: Default field name '" + fn + "' not found, ignoring");
                        continue;
                    }
                    this.usage("Error: Field name '" + fn + "' not found");
                    continue;
                }
                this.fieldsToAdd.put(fn, this.fieldsDescription.get(fn));
            }
        }
        if (this.verbose) {
            ArrayList<String> fieldsSort = new ArrayList<String>();
            fieldsSort.addAll(this.fieldsToAdd.keySet());
            Collections.sort(fieldsSort);
            Timer.showStdErr("Fields to add:");
            for (String fn : fieldsSort) {
                System.err.println("\t\t\t'" + fn + "'");
            }
        }
    }

    public void checkFieldsToAdd() throws IOException {
        if (this.verbose) {
            for (String filedName : this.dbNsfp.getFieldNames()) {
                if (this.fieldsDescription.get(filedName) != null) continue;
                System.err.println("WARNING: Field (column) '" + filedName + "' does not have an approriate field descriptor.");
            }
        }
        for (String fieldKey : this.fieldsToAdd.keySet()) {
            if (this.dbNsfp.hasField(fieldKey)) continue;
            this.fatalError("dbNsfp does not have field '" + fieldKey + "' (file '" + this.dbFileName + "')");
        }
    }

    String collapseRepeated(String csvalues) {
        String[] values2 = csvalues.split(",");
        if (values2.length <= 1) {
            return csvalues;
        }
        StringBuilder sb = new StringBuilder();
        HashSet<String> valuesAdded = new HashSet<String>();
        for (String val : values2) {
            if (!valuesAdded.add(val)) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(val);
        }
        return sb.toString();
    }

    public Map<String, String> getFieldsType() {
        return this.fieldsType;
    }

    String getVcfInfo(Collection<DbNsfpEntry> dbEntries, String fieldKey) {
        StringBuilder sb = new StringBuilder();
        for (DbNsfpEntry de : dbEntries) {
            String csv = de.getVcfInfo(fieldKey);
            if (this.annotateEmpty && csv == null) {
                csv = ".";
            }
            if (csv == null) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(csv);
        }
        return this.collapseRepeatedValues ? this.collapseRepeated(sb.toString()) : sb.toString();
    }

    @Override
    public void init() {
        super.init();
        this.needsConfig = true;
        this.needsDb = true;
        this.needsGenome = true;
        this.dbTabix = true;
        this.dbType = "dbnsfp";
        this.fieldsToAdd = new HashMap<String, String>();
        this.fieldsType = new HashMap<String, String>();
        this.fieldsDescription = new HashMap<String, String>();
        this.annotateEmpty = false;
        this.collapseRepeatedValues = false;
    }

    boolean isDbNsfpValueEmpty(String values2) {
        if (values2 == null || values2.isEmpty() || values2.equals(".")) {
            return true;
        }
        for (String val : values2.split(",")) {
            if (val.isEmpty() || val.equals(".")) continue;
            return false;
        }
        return true;
    }

    @Override
    public void parseArgs(String[] args) {
        if (args.length == 0) {
            this.usage(null);
        }
        block16: for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            switch (arg.toLowerCase()) {
                case "-a": {
                    this.annotateEmpty = true;
                    continue block16;
                }
                case "-f": {
                    this.fieldsNamesToAdd = args[++i];
                    continue block16;
                }
                case "-m": {
                    this.annotateMissing = true;
                    continue block16;
                }
                case "-nocollapse": {
                    this.collapseRepeatedValues = false;
                    continue block16;
                }
                case "-collapse": {
                    this.collapseRepeatedValues = true;
                    continue block16;
                }
                case "-n": {
                    this.inverseFieldSelection = true;
                    continue block16;
                }
                default: {
                    if (this.vcfFileName == null) {
                        this.vcfFileName = arg;
                        continue block16;
                    }
                    this.usage("Unknown extra parameter '" + arg + "'");
                }
            }
        }
        if (this.vcfFileName == null) {
            this.usage("Missing 'file.vcf'");
        }
    }

    @Override
    public boolean run() {
        this.run(false);
        return true;
    }

    public List<VcfEntry> run(boolean createList) {
        if (this.genomeVersion.isEmpty() && this.dbFileName == null) {
            this.usage("You must provide either a genome name or a database path (i.e. '-g' or '-db' command line options)");
        }
        if (this.config == null) {
            this.loadConfig();
        }
        this.dbFileName = this.databaseFind();
        if (this.verbose) {
            Timer.showStdErr("Annotating:\tInput file : '" + this.vcfFileName + "'\tDatabase file : '" + this.dbFileName + "'");
        }
        return this.annotate(createList);
    }

    public void setFieldsNamesToAdd(String fieldsNamesToAdd) {
        this.fieldsNamesToAdd = fieldsNamesToAdd;
    }

    public void setTabixCheck(boolean tabixCheck) {
        this.tabixCheck = tabixCheck;
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        StringBuilder sb = new StringBuilder();
        for (String f2 : DEFAULT_FIELDS_NAMES_TO_ADD.split(",")) {
            sb.append((sb.length() > 0 ? ", " : "") + f2);
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar " + this.command + " [options] file.vcf > newFile.vcf\nOptions:\n\t-a            : Annotate fields, even if the database has an empty value (annotates using '.' for empty).\n\t-collapse     : Collapse repeated values from dbNSFP. Default: " + this.collapseRepeatedValues + "\n\t-db <file>    : Path to dbNSFP database file (bgzip + tabix).\n\t-g <name>     : Genome version.\n\t-noCollapse   : Switch off 'collapsing' repeated values from dbNSFP. Default: " + !this.collapseRepeatedValues + "\n\t-m            : Annotate fields even if there are no database matching entries (annotates using '.').\n\t-n            : Invert 'fields to add' selection (i.e. use all fields except the ones specified in option '-f').\n\t-f            : A comma separated list of fields to add.\n\t                Default fields to add: " + sb);
        this.usageGenericAndDb();
        System.err.println("Note: Databse (dbNSFP.txt.gz) must be bgzip and tabix indexed file.\n      The corresponding index file (dbNSFP.txt.gz.tbi) must be present.\n");
        System.exit(1);
    }
}

