/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.unity;

import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.snpeff.interval.BioType;
import org.snpeff.interval.Cds;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffects;
import org.snpeff.util.GprSeq;

public class TestCasesDel {
    public static int N = 1000;
    boolean debug;
    boolean verbose;
    Config config;
    String chrSeq;
    Genome genome;
    Chromosome chr;
    Gene gene;
    Transcript tr;
    SnpEffectPredictor snpEffectPredictor;

    public TestCasesDel() {
        this.verbose = this.debug = false;
    }

    @Before
    public void init() {
        Exon[] exons;
        this.config = new Config("test");
        this.chrSeq = "CGTGTTACCAAGCATTTGGGAACCGGAATTCTACGCTGGAGTTCGCCTAACAGCTAAAGCTCAAAACAGGAGTGGTTTAGTTCACAGGCAGACCTTTAACGGTACCTACCTTAATCCGGTCAGATTTAAATTCATGATAGATGGTCTAAGTCATGCACTACTCCTACCAGTTTTGGACGTGGCGCATTGGGCCCCGACACCAAATGCGTTGGAGCGACAGCACAAACGATATCTCAGATTAAGTGCATTGAAGGCCTTCTCACGGATAGATCTATAGGTCGCTGTGTGTCGGGAAGTCTTTCATCCGCTCGGGAGTCGGGTAAATTCTTTCTTCCAGTTGTGTGTTCTACGACTGCAGAGGACAGCTCTCGCTTAGTTTCCTTCCGTTCTTTGTAAGGCCCGATAGGAATACCCGCATAATTATCCCCACAGTCTAACTTGATCCACGTCATATGGGGCGATGGCTGGAATGAGGGGGGTTCAGTGGCAGACCACGATATCTCTGTTTATCTGATGAAGAATTTTGGATACCCCAATAACTAATGTGAGAAGAGTGTGGGGTATCCAACGTGATTGGAGGGAAGTATGGAAACGAATGAAGACAAGTTCGACAAGCCGTGGTAACGATCATATGCCACCGTATTCTAACGGGGGGGGGCCGCTGTTTGAATGCCAGATAGATATTTAAAGAGGATGGCCGCCCCCCAATGGGCACGAGGAACTGACCAGAGGTAGGTATGATGGTGTGAGAGAGAGATGTAGTGTAGTTACTATAAAGATTTGAAGATCGAAAGGCTTAGTGATACGAAACCTCCCGCTACTGCGGGCCGGTATAGCAGGTCTAATACTTGGTGATAGGGCTACATCGAGCCTCGTTCGACAAGAATACCCCAGTTGCAATGGGGACCGATTCAGTCTGGGGCTCTGTGGTCCGACATTATGCCGGAATGCCTAGTATGGGAATTAAAACGATTAATATTACCTCTGGGACTATCTTTGTGCCAAACTCTACTGAGAGAGGAACGTAATCGTATTAGGGGCCAAGATAGTTTACTCCGATCCACCGTAACACTTATTTTGGGCCGTGCGTACCCACCCACGGTCATGAACGCAAACTGGATAGGGCGCGTCATACGAGCTAAAGTGTTCTCTTGGGGCAAATAAGAAGGGACTAGCTGTATTCCCCTCCCATTGTGTGGGTACAATTCGGGGGAAAGGTGTCGAGCCCAAATGCTACGGCTCGTAGATATCAGGTCCTTTAGCCGCCCGTATGTAAGCACCTCCAACGTTTTGGAGGAAGATCCCTCTCCCACGGGTTATACCATTAATGACTCCGCACTAACAATATCTTACCAGGGCCCGCAAATACCACACCGGGATACTGGAATGAATTATTCTCCGACCCATTTGATGAAACGTATGGGAACTTTCCTGTTGTATTAAACCCGCGGATACACTCTCTTGCCCACGAGTAGCCTCTACTTACTAGATTGAGAGGTACACTACGCCATTATGAAGCATTTCGACTTTCACTCCAGTATATAGAAGGTATGTGTGGATCCTTCAAAATAGTGATCCGAACCTGGTTGTAGGGGCCACCGAAATTCCGATTACTGAAGATTAATGTTTTCAAATGCCCTATTTCACTGGTGATAGCGATGGAGCCGGGCTATCATCATGGCGAAGCACGTGGGAAAGCATTCCGTCAAGGCTAGTGGGAACCTCTGCCTTGCCATGTACGCGTTCTATATACACGAACATCGATACCGGTCTCGTCCTGGGGTAGAGCCATCCTCATCACGAGTGATGTAGGACGGCTAGCTCATTAATTCACTGCGTGTCAGATAGAATGTCTTCGTGCGCAAAAATTGTTTAGGAGACCGTCGGCGCTCCCTTGGAGAGATGCCCAACGTAGAGAGGCAATCCCCGGCGTATTGGTGGTTTCTGGAACGGAACGAGACTCTTTGTTGCGTCGACTCCCGGCAACACCGGCCCCCGCCG";
        this.genome = new Genome("test");
        this.chr = new Chromosome(this.genome, 0, this.chrSeq.length() - 1, "1");
        this.chr.setSequence(this.chrSeq);
        this.genome.add(this.chr);
        this.gene = new Gene(this.chr, 333, 408, true, "gene1", "gene1", BioType.protein_coding);
        this.tr = new Transcript(this.gene, 333, 408, true, "tr1");
        this.gene.add(this.tr);
        this.tr.setProteinCoding(true);
        Exon e1 = new Exon(this.tr, 333, 334, true, "exon1", 0);
        Exon e2 = new Exon(this.tr, 353, 364, true, "exon2", 0);
        Exon e3 = new Exon(this.tr, 388, 398, true, "exon3", 0);
        Exon e4 = new Exon(this.tr, 404, 408, true, "exon4", 0);
        for (Exon e : exons = new Exon[]{e1, e2, e3, e4}) {
            String seq2 = this.chrSeq.substring(e.getStart(), e.getEnd() + 1);
            seq2 = GprSeq.reverseWc(seq2);
            e.setSequence(seq2);
            this.tr.add(e);
            Cds cds = new Cds(this.tr, e.getStart(), e.getEnd(), e.isStrandMinus(), "");
            this.tr.add(cds);
        }
        this.tr.rankExons();
        if (this.verbose) {
            System.out.println("Transcript:\n" + this.tr);
        }
        Assert.assertEquals("FLPYKAVLCR", this.tr.protein());
        this.snpEffectPredictor = new SnpEffectPredictor(this.genome);
        this.snpEffectPredictor.setUpDownStreamLength(0);
        this.snpEffectPredictor.add(this.gene);
        this.snpEffectPredictor.buildForest();
    }

    @Test
    public void test_01() {
        Variant var = new Variant((Marker)this.chr, 397, "GCCCGATAGGA", "", "");
        if (this.verbose) {
            System.out.println("Variant: " + var + "\n" + this.tr.toStringAsciiArt(true));
        }
        Assert.assertEquals("chr1:397_GCCCGATAGGA/", var.toString());
        int countMatch = 0;
        VariantEffects effectsAll = this.snpEffectPredictor.variantEffect(var);
        for (VariantEffect eff : effectsAll) {
            if (this.verbose) {
                System.out.println("\t" + eff);
            }
            if (eff.getEffectType() != EffectType.CODON_CHANGE_PLUS_CODON_DELETION) continue;
            if (this.verbose) {
                System.out.println("\t" + eff.getEffectTypeString(false) + "\t" + eff.getCodonsRef() + "\t" + eff.getCodonsAlt());
            }
            Assert.assertEquals("TCT", eff.getCodonsAlt().toUpperCase());
            ++countMatch;
        }
        Assert.assertTrue("No variant effects found", countMatch > 0);
    }

    @Test
    public void test_02() {
        int start = 300;
        Variant var = new Variant((Marker)this.chr, start, this.chrSeq.substring(300, 450), "", "");
        if (this.verbose) {
            System.out.println("Transcript:" + this.tr + "\nVariant: " + var);
        }
        int countMatch = 0;
        VariantEffects effectsAll = this.snpEffectPredictor.variantEffect(var);
        for (VariantEffect eff : effectsAll) {
            if (this.verbose) {
                System.out.println("\t" + eff.getEffectTypeString(false) + "\tHGVS.p: '" + eff.getHgvsProt() + "'");
            }
            if (eff.getEffectType() != EffectType.TRANSCRIPT_DELETED) continue;
            ++countMatch;
            Assert.assertEquals("HGVS.p notation error", "p.0?", eff.getHgvsProt());
        }
        Assert.assertTrue("No variant effects found", countMatch > 0);
    }
}

