/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.factory;

import java.io.BufferedReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.snpeff.interval.BioType;
import org.snpeff.interval.Cds;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Exon;
import org.snpeff.interval.FrameType;
import org.snpeff.interval.Gene;
import org.snpeff.interval.GffMarker;
import org.snpeff.interval.GffType;
import org.snpeff.interval.IntergenicConserved;
import org.snpeff.interval.IntronConserved;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.TranscriptSupportLevel;
import org.snpeff.interval.Utr3prime;
import org.snpeff.interval.Utr5prime;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.snpEffect.factory.SnpEffPredictorFactory;
import org.snpeff.util.Gpr;

public abstract class SnpEffPredictorFactoryGff
extends SnpEffPredictorFactory {
    public static final String FASTA_DELIMITER = "##FASTA";
    String version = "";
    boolean mainFileHasFasta = false;

    public SnpEffPredictorFactoryGff(Config config) {
        super(config, 1);
        this.markersById = new HashMap();
        this.genesById = new HashMap();
        this.transcriptsById = new HashMap();
        this.fileName = config.getBaseFileNameGenes() + ".gff";
        this.frameCorrection = true;
        this.frameType = FrameType.GFF;
    }

    protected Exon addExon(Transcript tr, GffMarker gffMarker, String exonId) {
        int rank = 0;
        Exon ex = new Exon(tr, gffMarker.getStart(), gffMarker.getEnd(), gffMarker.isStrandMinus(), exonId, rank);
        ex.setFrame(gffMarker.getFrame());
        this.add(ex);
        return ex;
    }

    protected List<Exon> addExons(GffMarker gffMarker) {
        String id = gffMarker.getId();
        LinkedList<Exon> list2 = new LinkedList<Exon>();
        block5: for (String parentId : gffMarker.getGffParentIds()) {
            String trId;
            parentId = parentId.trim();
            Transcript tr = this.findTranscript(parentId, id);
            Gene gene = this.findGene(parentId);
            if (tr == null && gene != null && (tr = this.findTranscript(trId = (Object)((Object)GffType.TRANSCRIPT) + "_" + gene.getId())) == null) {
                tr = this.addTranscript(gene, gffMarker, trId);
                if (this.debug) {
                    this.warning("Exon's parent '" + parentId + "' is a Gene instead of a transcript. Created transcript '" + tr.getId() + "' for this exon.");
                }
            }
            if (gene == null) {
                gene = this.findGene(gffMarker.getGeneId());
            }
            if (tr == null) {
                if (gene == null) {
                    gene = this.addGene(gffMarker);
                }
                trId = parentId.isEmpty() ? (Object)((Object)GffType.TRANSCRIPT) + "_" + id : parentId;
                tr = this.addTranscript(gene, gffMarker, trId);
                if (this.debug) {
                    this.warning("Cannot find transcript '" + parentId + "'. Created transcript '" + tr.getId() + "' and gene '" + gene.getId() + "' for this exon");
                }
            }
            int rank = 0;
            switch (gffMarker.getGffType()) {
                case EXON: {
                    Exon ex = new Exon(tr, gffMarker.getStart(), gffMarker.getEnd(), gffMarker.isStrandMinus(), id, rank);
                    ex.setFrame(gffMarker.getFrame());
                    this.add(ex);
                    list2.add(ex);
                    continue block5;
                }
                case CDS: {
                    Cds cds = new Cds(tr, gffMarker.getStart(), gffMarker.getEnd(), gffMarker.isStrandMinus(), id);
                    cds.setFrame(gffMarker.getFrame());
                    this.add(cds);
                    continue block5;
                }
                case START_CODON: 
                case STOP_CODON: {
                    Exon ex = new Exon(tr, gffMarker.getStart(), gffMarker.getEnd(), gffMarker.isStrandMinus(), id, rank);
                    ex.setFrame(gffMarker.getFrame());
                    this.add(ex);
                    Cds cds = new Cds(tr, gffMarker.getStart(), gffMarker.getEnd(), gffMarker.isStrandMinus(), (Object)((Object)gffMarker.getGffType()) + "_" + id);
                    cds.setFrame(gffMarker.getFrame());
                    this.add(cds);
                    continue block5;
                }
                default: {
                    throw new RuntimeException("Unsupported type " + (Object)((Object)gffMarker.getGffType()));
                }
            }
        }
        return list2.isEmpty() ? null : list2;
    }

    protected Gene addGene(GffMarker gffMarker) {
        BioType bioType = gffMarker.getGeneBiotype();
        Gene gene = new Gene(gffMarker.getChromosome(), gffMarker.getStart(), gffMarker.getEnd(), gffMarker.isStrandMinus(), gffMarker.getGeneId(), gffMarker.getGeneName(), bioType);
        this.add(gene);
        return gene;
    }

    protected IntergenicConserved addIntergenicConserved(GffMarker gffMarker) {
        IntergenicConserved intergenicConserved = new IntergenicConserved(gffMarker.getChromosome(), gffMarker.getStart(), gffMarker.getEnd(), gffMarker.isStrandMinus(), gffMarker.getId());
        this.add(intergenicConserved);
        return intergenicConserved;
    }

    protected boolean addInterval(GffMarker gffMarker) {
        switch (gffMarker.getGffType()) {
            case GENE: {
                String geneId = gffMarker.getGeneId();
                if (geneId != null && this.findGene(geneId) != null) {
                    this.warning("Gene '" + geneId + "' already added");
                    return false;
                }
                return this.findOrCreateGene(gffMarker) != null;
            }
            case TRANSCRIPT: {
                String trId = gffMarker.getTranscriptId();
                if (trId != null && this.findTranscript(trId) != null) {
                    this.warning("Transcript '" + trId + "' already added");
                    return false;
                }
                return this.findOrCreateTranscript(gffMarker) != null;
            }
            case CDS: {
                return this.addExons(gffMarker) != null;
            }
            case EXON: 
            case START_CODON: 
            case STOP_CODON: {
                return this.addExons(gffMarker) != null;
            }
            case UTR5: {
                return this.addUtr5(gffMarker) != null;
            }
            case UTR3: {
                return this.addUtr3(gffMarker) != null;
            }
            case INTRON_CONSERVED: {
                return this.addIntronConserved(gffMarker) != null;
            }
            case INTERGENIC_CONSERVED: {
                return this.addIntergenicConserved(gffMarker) != null;
            }
        }
        return false;
    }

    protected IntronConserved addIntronConserved(GffMarker gffMarker) {
        String trId = gffMarker.getTranscriptId();
        Transcript tr = this.findTranscript(trId);
        if (tr == null) {
            tr = this.findTranscript(gffMarker.getId());
        }
        if (tr == null) {
            this.warning("Could not find transcript '" + trId + "'");
            return null;
        }
        IntronConserved intronConserved = new IntronConserved(tr, gffMarker.getStart(), gffMarker.getEnd(), gffMarker.isStrandMinus(), gffMarker.getId());
        this.add(intronConserved);
        return intronConserved;
    }

    Transcript addTranscript(Gene gene, GffMarker gffMarker, String trId) {
        String ver;
        Transcript tr = new Transcript(gene, gffMarker.getStart(), gffMarker.getEnd(), gffMarker.isStrandMinus(), trId);
        if (gffMarker.isProteingCoding()) {
            tr.setProteinCoding(true);
        }
        tr.setBioType(gffMarker.getTranscriptBiotype());
        String tslStr = gffMarker.getAttr("transcript_support_level");
        if (tslStr != null) {
            tr.setTranscriptSupportLevel(TranscriptSupportLevel.parse(tslStr));
        }
        if ((ver = gffMarker.getTranscriptVersion()) != null) {
            tr.setVersion(ver);
        }
        this.add(tr);
        BioType geneBioType = gffMarker.getGeneBiotype();
        if (gene.getBioType() == null && geneBioType != null) {
            gene.setBioType(geneBioType);
        }
        if (!gene.getChromosomeName().equals(tr.getChromosomeName())) {
            this.error("Trying to assign Transcript to a Gene in a different chromosome!\n\tTranscript : " + tr.toStr() + "\n\tGene       : " + gene.toStr());
        }
        return tr;
    }

    protected List<Utr3prime> addUtr3(GffMarker gffMarker) {
        LinkedList<Utr3prime> list2 = new LinkedList<Utr3prime>();
        for (String parentId : gffMarker.getGffParentIds()) {
            Exon exon = this.findOrCreateExon(parentId, gffMarker);
            if (exon != null) {
                Transcript tr = (Transcript)exon.getParent();
                Utr3prime u3 = new Utr3prime(exon, gffMarker.getStart(), gffMarker.getEnd(), gffMarker.isStrandMinus(), gffMarker.getId());
                tr.add(u3);
                this.add(u3);
                list2.add(u3);
                continue;
            }
            this.warning("Could not add UTR");
        }
        return list2.isEmpty() ? null : list2;
    }

    protected List<Utr5prime> addUtr5(GffMarker gffMarker) {
        LinkedList<Utr5prime> list2 = new LinkedList<Utr5prime>();
        for (String parentId : gffMarker.getGffParentIds()) {
            Exon exon = this.findOrCreateExon(parentId, gffMarker);
            if (exon != null) {
                Transcript tr = (Transcript)exon.getParent();
                Utr5prime u5 = new Utr5prime(exon, gffMarker.getStart(), gffMarker.getEnd(), gffMarker.isStrandMinus(), gffMarker.getId());
                tr.add(u5);
                this.add(u5);
                list2.add(u5);
                continue;
            }
            this.warning("Could not add UTR");
        }
        return list2.isEmpty() ? null : list2;
    }

    @Override
    public SnpEffectPredictor create() {
        if (this.verbose) {
            System.out.println("Reading " + this.version + " data file  : '" + this.fileName + "'");
        }
        try {
            this.readGff();
            this.beforeExonSequences();
            if (this.readSequences) {
                this.readExonSequences();
            } else if (this.createRandSequences) {
                this.createRandSequences();
            }
            if (this.verbose) {
                System.out.println("\tTotal: " + this.totalSeqsAdded + " sequences added, " + this.totalSeqsIgnored + " sequences ignored.");
            }
            this.finishUp();
            if (this.verbose) {
                System.out.println(this.config.getGenome());
            }
        }
        catch (Exception e) {
            if (this.verbose) {
                e.printStackTrace();
            }
            throw new RuntimeException("Error reading file '" + this.fileName + "'\n" + e);
        }
        return this.snpEffectPredictor;
    }

    protected Exon findOrCreateExon(String parentId, GffMarker gffMarker) {
        Transcript tr = this.findTranscript(parentId);
        if (tr == null) {
            tr = this.findTranscript(gffMarker.getTranscriptId());
        }
        if (tr == null) {
            this.warning("Cannot find transcript '" + parentId + "'");
            return null;
        }
        Marker utr = new Marker(tr, gffMarker.getStart(), gffMarker.getEnd(), gffMarker.isStrandMinus(), gffMarker.getId());
        Exon exon = tr.queryExon(utr);
        if (exon != null) {
            return exon;
        }
        exon = this.addExon(tr, gffMarker, gffMarker.getId());
        if (this.debug) {
            this.warning("Cannot find exon for UTR: '" + utr.getId() + "'. Creating exon '" + gffMarker.getId() + "'");
        }
        return exon;
    }

    protected Gene findOrCreateGene(GffMarker gffMarker) {
        Gene gene = this.findGene(gffMarker.getGeneId());
        if (gene == null) {
            gene = this.findGene(gffMarker.getId());
        }
        if (gene == null) {
            gene = this.addGene(gffMarker);
        }
        return gene;
    }

    protected Transcript findOrCreateTranscript(GffMarker gffMarker) {
        String trId = gffMarker.getTranscriptId();
        Transcript tr = this.findTranscript(trId);
        if (tr == null) {
            tr = this.findTranscript(gffMarker.getId());
        }
        if (tr == null) {
            Gene gene = this.findOrCreateGene(gffMarker);
            tr = this.addTranscript(gene, gffMarker, trId);
        }
        return tr;
    }

    protected boolean parse(String line) {
        GffMarker gffMarker = new GffMarker(this.genome, line);
        return this.addInterval(gffMarker);
    }

    @Override
    protected void readExonSequences() {
        if (this.verbose) {
            System.out.print("\tReading sequences   :\n");
        }
        if (this.mainFileHasFasta) {
            this.readExonSequencesGff(this.fileName);
        } else {
            super.readExonSequences();
        }
    }

    protected void readExonSequencesGff(String gffFileName) {
        try {
            BufferedReader reader = Gpr.reader(gffFileName);
            this.lineNum = 1;
            while (reader.ready()) {
                this.line = reader.readLine();
                if (this.line.equals(FASTA_DELIMITER)) {
                    this.mainFileHasFasta = true;
                    break;
                }
                ++this.lineNum;
            }
            String chromoName = null;
            StringBuffer chromoSb = new StringBuffer();
            while (reader.ready()) {
                this.line = reader.readLine();
                if (this.line.startsWith(">")) {
                    int idxSpace;
                    if (chromoName != null) {
                        this.addSequences(chromoName, chromoSb.toString());
                    }
                    if ((idxSpace = this.line.indexOf(32)) > 0) {
                        this.line = this.line.substring(0, idxSpace);
                    }
                    chromoName = Chromosome.simpleName(this.line.substring(1).trim());
                    this.chromoNamesReference.add(chromoName);
                    chromoSb = new StringBuffer();
                    if (this.verbose) {
                        System.out.println("\t\tReading sequence '" + chromoName + "'");
                    }
                } else {
                    chromoSb.append(this.line.trim());
                }
                ++this.lineNum;
            }
            if (chromoName != null) {
                this.chromoLen(chromoName, chromoSb.length());
                this.addSequences(chromoName, chromoSb.toString());
            } else {
                this.warning("Ignoring sequences for '" + chromoName + "'. Cannot find chromosome");
            }
            reader.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void readGff() throws Exception {
        int count2 = 0;
        BufferedReader reader = Gpr.reader(this.fileName);
        if (reader == null) {
            return;
        }
        try {
            this.lineNum = 1;
            while (reader.ready()) {
                this.line = reader.readLine();
                if (this.line != null && !this.line.isEmpty()) {
                    if (this.line.equals(FASTA_DELIMITER)) {
                        this.mainFileHasFasta = true;
                        break;
                    }
                    if (!this.line.startsWith("#") && this.parse(this.line)) {
                        ++count2;
                        if (this.verbose) {
                            Gpr.showMark(count2, 100, "\t\t");
                        }
                    }
                }
                ++this.lineNum;
            }
        }
        catch (Exception e) {
            this.error("Offending line (lineNum: " + this.lineNum + "): '" + this.line + "'", e);
        }
        reader.close();
        if (this.verbose) {
            System.out.println((count2 > 0 ? "\n" : "") + "\tTotal: " + count2 + " markers added.");
        }
    }
}

