/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.sam;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.snpeff.sam.SamHeaderRecord;
import org.snpeff.sam.SamHeaderRecordSq;

public class SamHeader
implements Iterable<String> {
    HashMap<String, ArrayList<SamHeaderRecord>> recordsByType = new HashMap();
    ArrayList<String> lines = new ArrayList();

    public void add(SamHeaderRecord samHeaderRecord) {
        ArrayList<SamHeaderRecord> records = this.getRecords(samHeaderRecord.getRecordTypeCode());
        records.add(samHeaderRecord);
    }

    public void addHeaderRecord(String line) {
        if (!line.startsWith("@")) {
            throw new RuntimeException("Record type must start with '@'. Header line: " + line);
        }
        this.lines.add(line);
        SamHeaderRecordSq shr = null;
        if (line.startsWith("@SQ")) {
            shr = new SamHeaderRecordSq(line);
        }
        if (shr != null) {
            this.add(shr);
        }
    }

    public ArrayList<SamHeaderRecord> getRecords(String recordType) {
        ArrayList<SamHeaderRecord> records = this.recordsByType.get(recordType);
        if (records == null) {
            records = new ArrayList();
            this.recordsByType.put(recordType, records);
        }
        return records;
    }

    @Override
    public Iterator<String> iterator() {
        return this.lines.iterator();
    }
}

