/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;
import org.snpeff.interval.BioType;
import org.snpeff.interval.Cds;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Exon;
import org.snpeff.interval.IntervalAndSubIntervals;
import org.snpeff.interval.Intron;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;
import org.snpeff.interval.SpliceSite;
import org.snpeff.interval.SpliceSiteAcceptor;
import org.snpeff.interval.SpliceSiteBranch;
import org.snpeff.interval.SpliceSiteDonor;
import org.snpeff.interval.SpliceSiteRegion;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.TranscriptSupportLevel;
import org.snpeff.interval.Utr;
import org.snpeff.interval.Utr3prime;
import org.snpeff.interval.Utr5prime;
import org.snpeff.interval.Variant;
import org.snpeff.interval.VariantNonRef;
import org.snpeff.interval.tree.IntervalTree;
import org.snpeff.interval.tree.Itree;
import org.snpeff.serializer.MarkerSerializer;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffects;
import org.snpeff.stats.ObservedOverExpectedCpG;
import org.snpeff.util.Gpr;
import org.snpeff.util.Timer;

public class Gene
extends IntervalAndSubIntervals<Transcript>
implements Serializable {
    public static final String CIRCULAR_GENE_ID = "_circ";
    private static final long serialVersionUID = 8419206759034068147L;
    String geneName;
    BioType bioType;
    Itree intervalTreeGene;

    public Gene() {
        this.geneName = "";
        this.bioType = null;
        this.type = EffectType.GENE;
    }

    public Gene(Marker parent, int start, int end, boolean strandMinus, String id, String geneName, BioType bioType) {
        super(parent, start, end, strandMinus, id);
        this.geneName = geneName;
        this.bioType = bioType;
        this.type = EffectType.GENE;
    }

    public void addPerGene(Marker marker) {
        if (this.intervalTreeGene == null) {
            this.intervalTreeGene = new IntervalTree();
        }
        this.intervalTreeGene.add(marker);
    }

    public boolean adjust() {
        boolean newStrandMinus;
        boolean changed = false;
        int strandSumGene = 0;
        int newStart = Integer.MAX_VALUE;
        int newEnd = Integer.MIN_VALUE;
        for (Transcript tr : this) {
            newStart = Math.min(newStart, tr.getStart());
            newEnd = Math.max(newEnd, tr.getEnd());
            for (Exon exon : tr.sortedStrand()) {
                newStart = Math.min(newStart, exon.getStart());
                newEnd = Math.max(newEnd, exon.getEnd());
                strandSumGene += exon.isStrandMinus() ? -1 : 1;
            }
            for (Utr utr : tr.getUtrs()) {
                newStart = Math.min(newStart, utr.getStart());
                newEnd = Math.max(newEnd, utr.getEnd());
            }
        }
        boolean bl = newStrandMinus = strandSumGene < 0;
        if (this.strandMinus != newStrandMinus) {
            this.strandMinus = newStrandMinus;
            changed = true;
        }
        if (newStart < newEnd) {
            if (this.start != newStart) {
                this.start = newStart;
                changed = true;
            }
            if (this.end != newEnd) {
                this.end = newEnd;
                changed = true;
            }
        } else if (Config.get().isDebug()) {
            Gpr.debug("Gene '" + this.id + "' (name:'" + this.geneName + "') not adjusted: " + this);
        }
        return changed;
    }

    public void buildPerGene() {
        if (this.intervalTreeGene != null) {
            this.intervalTreeGene.build();
        }
    }

    public Transcript canonical() {
        Transcript canonical = null;
        int canonicalLen = 0;
        if (this.isProteinCoding()) {
            for (Transcript t : this) {
                int tlen = t.cds().length();
                if (!t.isProteinCoding() || canonical != null && canonicalLen >= tlen && (canonicalLen != tlen || t.getId().compareTo(canonical.getId()) >= 0)) continue;
                canonical = t;
                canonicalLen = tlen;
            }
        } else {
            for (Transcript t : this) {
                int tlen = t.mRna().length();
                if (canonicalLen > tlen || canonical != null && canonicalLen >= tlen && (canonicalLen != tlen || t.getId().compareTo(canonical.getId()) >= 0)) continue;
                canonical = t;
                canonicalLen = tlen;
            }
        }
        if (canonical != null) {
            canonical.setCanonical(true);
        }
        return canonical;
    }

    public Gene circularClone() {
        Gene newGene = (Gene)this.clone();
        newGene.setId(this.id + CIRCULAR_GENE_ID);
        for (Transcript tr : newGene) {
            tr.setId(tr.getId() + CIRCULAR_GENE_ID);
            for (Exon ex : tr) {
                ex.setId(ex.getId() + CIRCULAR_GENE_ID);
            }
        }
        Chromosome chr = this.getChromosome();
        int shift = 0;
        if (this.start < 0) {
            shift = chr.size();
        } else if (this.end > chr.getEnd()) {
            shift = -chr.size();
        } else {
            throw new RuntimeException("Sanity check: This should neve happen!");
        }
        newGene.shiftCoordinates(shift);
        if (Config.get().isVerbose()) {
            Timer.showStdErr("Gene '" + this.id + "' spans across coordinate zero: Assuming circular chromosome, creating mirror gene at the end.\n\tGene        :" + this.toStr() + "\n\tNew gene    :" + newGene.toStr() + "\n\tChrsomosome :" + chr.toStr());
        }
        return newGene;
    }

    @Override
    public Gene cloneShallow() {
        Gene clone2 = (Gene)super.cloneShallow();
        clone2.bioType = this.bioType;
        clone2.geneName = this.geneName;
        return clone2;
    }

    public double cpgExonBias() {
        ObservedOverExpectedCpG oe = new ObservedOverExpectedCpG();
        return oe.oe(this);
    }

    public void filterTranscriptSupportLevel(TranscriptSupportLevel maxTsl) {
        ArrayList<Transcript> toDelete = new ArrayList<Transcript>();
        for (Transcript tr : this) {
            if (tr.hasTranscriptSupportLevelInfo() && tr.getTranscriptSupportLevel().compareTo(maxTsl) <= 0) continue;
            toDelete.add(tr);
        }
        for (Transcript t : toDelete) {
            this.remove(t);
        }
    }

    public GeneType geneType() {
        if (this.bioType != null) {
            if (this.bioType.isProteinCoding()) {
                return GeneType.CODING;
            }
            return GeneType.NON_CODING;
        }
        return GeneType.UNKNOWN;
    }

    public BioType getBioType() {
        return this.bioType;
    }

    public String getGeneName() {
        return this.geneName;
    }

    public boolean isProteinCoding() {
        for (Transcript tr : this) {
            if (!tr.isProteinCoding()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isShowWarningIfParentDoesNotInclude() {
        return false;
    }

    public int keepTranscripts(Set<String> trIds) {
        ArrayList<Transcript> toDelete = new ArrayList<Transcript>();
        for (Transcript t : this) {
            String trId = t.getId();
            String trIdNoVersion = t.getId();
            int versionIdx = trIdNoVersion.indexOf(46);
            if (versionIdx > 0) {
                trIdNoVersion = trIdNoVersion.substring(0, versionIdx);
            }
            if (trIds.contains(trId) || trIds.contains(trIdNoVersion)) continue;
            toDelete.add(t);
        }
        for (Transcript t : toDelete) {
            this.remove(t);
        }
        return toDelete.size();
    }

    public int keepTranscriptsProteinCoding() {
        ArrayList<Transcript> toDelete = new ArrayList<Transcript>();
        for (Transcript t : this) {
            if (t.isProteinCoding()) continue;
            toDelete.add(t);
        }
        for (Transcript t : toDelete) {
            this.remove(t);
        }
        return toDelete.size();
    }

    @Override
    public Markers markers() {
        Markers markers = new Markers();
        for (Transcript tr : this) {
            markers.add(tr);
            markers.add(tr.markers());
        }
        return markers;
    }

    public void removeNonCanonical(String trId) {
        Transcript canonical;
        if (trId != null) {
            canonical = (Transcript)this.get(trId);
            if (canonical == null) {
                throw new RuntimeException("Canonical transcript '" + trId + "' not found! Gene name: '" + this.getGeneName() + "', Gene ID: '" + this.getId() + "'");
            }
        } else {
            canonical = this.canonical();
        }
        if (canonical != null) {
            ArrayList toDelete = new ArrayList();
            toDelete.addAll(this.subIntervals());
            toDelete.remove(canonical);
            for (Transcript t : toDelete) {
                this.remove(t);
            }
        }
    }

    public boolean removeUnverified() {
        ArrayList<Transcript> toDelete = new ArrayList<Transcript>();
        int countRemoved = 0;
        for (Transcript tr : this) {
            if (tr.isChecked() && !tr.isCorrected()) continue;
            toDelete.add(tr);
            ++countRemoved;
        }
        if (Config.get().isDebug()) {
            Gpr.debug("Gene '', removing " + countRemoved + " / " + this.numChilds() + " unchecked transcript.");
        }
        for (Transcript t : toDelete) {
            this.remove(t);
        }
        return this.numChilds() <= 0;
    }

    @Override
    public void serializeParse(MarkerSerializer markerSerializer) {
        super.serializeParse(markerSerializer);
        this.geneName = markerSerializer.getNextField();
        this.bioType = BioType.parse(markerSerializer.getNextField());
    }

    @Override
    public String serializeSave(MarkerSerializer markerSerializer) {
        return super.serializeSave(markerSerializer) + "\t" + this.geneName + "\t" + (Object)((Object)this.bioType);
    }

    public void setBioType(BioType bioType) {
        this.bioType = bioType;
    }

    public int sizeof(String type) {
        EffectType eff = EffectType.valueOf(type.toUpperCase());
        Markers all = new Markers();
        int len = 0;
        switch (eff) {
            case GENE: {
                return this.size();
            }
            case EXON: {
                for (Transcript tr : this) {
                    for (Exon exon : tr) {
                        all.add(exon);
                    }
                }
                break;
            }
            case CDS: {
                for (Transcript tr : this) {
                    for (Cds cds : tr.getCds()) {
                        all.add(cds);
                    }
                }
                break;
            }
            case TRANSCRIPT: {
                for (Transcript tr : this) {
                    all.add(tr);
                }
                break;
            }
            case INTRON: {
                return Math.max(0, this.sizeof("TRANSCRIPT") - this.sizeof("EXON"));
            }
            case UTR_3_PRIME: {
                for (Transcript tr : this) {
                    for (Utr3prime utr3prime : tr.get3primeUtrs()) {
                        all.add(utr3prime);
                    }
                }
                break;
            }
            case UTR_5_PRIME: {
                for (Transcript tr : this) {
                    for (Utr5prime utr5prime : tr.get5primeUtrs()) {
                        all.add(utr5prime);
                    }
                }
                break;
            }
            case UPSTREAM: {
                for (Transcript tr : this) {
                    all.add(tr.getUpstream());
                }
                break;
            }
            case DOWNSTREAM: {
                for (Transcript tr : this) {
                    all.add(tr.getDownstream());
                }
                break;
            }
            case SPLICE_SITE_ACCEPTOR: {
                for (Transcript tr : this) {
                    for (Exon exon : tr) {
                        for (SpliceSite ss : exon.getSpliceSites()) {
                            if (!(ss instanceof SpliceSiteAcceptor)) continue;
                            all.add(ss);
                        }
                    }
                }
                break;
            }
            case SPLICE_SITE_BRANCH: {
                for (Transcript tr : this) {
                    for (SpliceSite spliceSite : tr.spliceSites()) {
                        if (!(spliceSite instanceof SpliceSiteBranch)) continue;
                        all.add(spliceSite);
                    }
                }
                break;
            }
            case SPLICE_SITE_DONOR: {
                for (Transcript tr : this) {
                    for (Exon exon : tr) {
                        for (SpliceSite ss : exon.getSpliceSites()) {
                            if (!(ss instanceof SpliceSiteDonor)) continue;
                            all.add(ss);
                        }
                    }
                }
                break;
            }
            case SPLICE_SITE_REGION: {
                for (Transcript tr : this) {
                    for (Exon exon : tr) {
                        for (SpliceSite ss : exon.getSpliceSites()) {
                            if (!(ss instanceof SpliceSiteRegion)) continue;
                            all.add(ss);
                        }
                    }
                    for (Intron intron : tr.introns()) {
                        for (SpliceSite ss : intron.getSpliceSites()) {
                            if (!(ss instanceof SpliceSiteRegion)) continue;
                            all.add(ss);
                        }
                    }
                }
            }
            case INTRAGENIC: {
                Markers gene = new Markers();
                gene.add(this);
                Markers trans = new Markers();
                for (Transcript transcript : this) {
                    trans.add(transcript);
                }
                all = gene.minus(trans);
                break;
            }
            case NONE: {
                return 0;
            }
            default: {
                throw new RuntimeException("Unimplemented sizeof('" + type + "')");
            }
        }
        Markers merged = all.merge();
        for (Marker m : merged) {
            len += m.size();
        }
        return len;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean showTr) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getChromosomeName() + ":" + this.start + "-" + this.end);
        sb.append(", strand:" + (this.strandMinus ? "-1" : "1"));
        if (this.id != null && this.id.length() > 0) {
            sb.append(", id:" + this.id);
        }
        if (this.geneName != null && this.geneName.length() > 0) {
            sb.append(", name:" + this.geneName);
        }
        if (this.bioType != null && this.bioType != null) {
            sb.append(", bioType:" + (Object)((Object)this.bioType));
        }
        sb.append("\n");
        if (showTr && this.numChilds() > 0) {
            sb.append("Transcipts:\n");
            for (Transcript tint : this.sorted()) {
                sb.append("\t" + tint + "\n");
            }
        }
        return sb.toString();
    }

    @Override
    public boolean variantEffect(Variant variant, VariantEffects variantEffects) {
        if (!this.intersects(variant)) {
            return false;
        }
        boolean shifted3prime = false;
        if (Config.get().isHgvsShift()) {
            Variant variantOri = variant;
            if (!variant.isSnp() && Config.get().isHgvsShift() && this.isStrandPlus()) {
                shifted3prime = (variant = variant.realignLeft()) != variantOri;
            }
        }
        boolean hitTranscript = false;
        for (Transcript tr : this) {
            if (variant.isNonRef()) {
                Variant vref = ((VariantNonRef)variant).getVariantRef();
                tr = tr.apply(vref);
            }
            hitTranscript |= tr.intersects(variant);
            tr.variantEffect(variant, variantEffects);
        }
        if (!hitTranscript) {
            variantEffects.add(variant, this, EffectType.INTRAGENIC, "");
            return true;
        }
        this.variantEffectGene(variant, variantEffects);
        if (shifted3prime) {
            for (VariantEffect ve : variantEffects) {
                if (ve.getVariant() != variant) continue;
                ve.addErrorWarningInfo(VariantEffect.ErrorWarningType.INFO_REALIGN_3_PRIME);
            }
        }
        return true;
    }

    protected void variantEffectGene(Variant variant, VariantEffects variantEffects) {
        if (this.intervalTreeGene == null) {
            return;
        }
        Markers res = this.intervalTreeGene.query(variant);
        for (Marker m : res) {
            m.variantEffect(variant, variantEffects);
        }
    }

    public static enum GeneType {
        CODING,
        NON_CODING,
        UNKNOWN;

    }
}

