/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.fileIterator;

import java.io.IOException;
import java.util.Iterator;
import org.broad.igv.bbfile.BBFileHeader;
import org.broad.igv.bbfile.BBFileReader;
import org.broad.igv.bbfile.BedFeature;
import org.snpeff.fileIterator.VariantFileIterator;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Variant;
import org.snpeff.interval.VariantWithScore;
import org.snpeff.util.Gpr;

public class BigBedFileIterator
extends VariantFileIterator {
    BBFileReader readerBb;
    BBFileHeader bbFileHdr;
    Iterator<BedFeature> iterator;
    String label;

    public BigBedFileIterator(String fileName) {
        super((String)null);
        this.inOffset = 0;
        this.open(fileName);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Variant next() {
        return this.readNext();
    }

    void open(String fileName) {
        try {
            this.label = Gpr.removeExt(Gpr.baseName(fileName));
            BBFileReader readerBb = new BBFileReader(fileName);
            BBFileHeader bbFileHdr = readerBb.getBBFileHeader();
            if (!bbFileHdr.isHeaderOK()) {
                throw new IOException("Bad header for file '" + fileName + "'");
            }
            if (!bbFileHdr.isBigBed()) {
                throw new RuntimeException("Unrecognized header type for file '" + fileName + "' (expecting BigBed)");
            }
            this.iterator = readerBb.getBigBedIterator();
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading file '" + fileName + "'.", e);
        }
    }

    @Override
    protected Variant readNext() {
        BedFeature f2 = this.iterator.next();
        if (f2 == null) {
            return null;
        }
        String id = this.label + ":" + (f2.getStartBase() + 1) + "_" + f2.getEndBase();
        String[] restOfFields = f2.getRestOfFields();
        double score = Gpr.parseDoubleSafe(restOfFields[1]);
        VariantWithScore seqChange = new VariantWithScore((Marker)this.getChromosome(f2.getChromosome()), f2.getStartBase(), f2.getEndBase() - 1, id, score);
        return seqChange;
    }
}

