/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.unity;

import org.junit.Assert;
import org.junit.Test;
import org.snpeff.codons.CodonTable;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffects;
import org.snpeff.snpEffect.testCases.unity.TestCasesBase;
import org.snpeff.util.Gpr;
import org.snpeff.util.GprSeq;

public class TestCasesIns
extends TestCasesBase {
    public static int N = 1000;

    public TestCasesIns() {
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        this.randSeed = 20100629;
    }

    @Test
    public void test_01() {
        Gpr.debug("Test");
        for (int i = 0; i < N; ++i) {
            this.initSnpEffPredictor();
            CodonTable codonTable = this.genome.codonTable();
            if (this.debug) {
                System.out.println("INS Test iteration: " + i + "\n" + this.transcript);
            } else if (this.verbose) {
                System.out.println("INS Test iteration: " + i + "\t" + (this.transcript.isStrandPlus() ? "+" : "-") + "\t" + this.transcript.cds());
            } else {
                Gpr.showMark(i + 1, 1);
            }
            int cdsBaseNum = 0;
            for (Exon exon : this.transcript.sortedStrand()) {
                int beg;
                int step2 = exon.isStrandPlus() ? 1 : -1;
                int pos = beg = exon.isStrandPlus() ? exon.getStart() : exon.getEnd();
                while (pos >= exon.getStart() && pos <= exon.getEnd()) {
                    String insPlus;
                    int insLen = this.rand.nextInt(10) + 1;
                    String ins = insPlus = GprSeq.randSequence(this.rand, insLen);
                    int cdsCodonNum = cdsBaseNum / 3;
                    int cdsCodonPos = cdsBaseNum % 3;
                    int minCodonPos = cdsCodonNum * 3;
                    int maxCodonPos = minCodonPos + 3;
                    if (maxCodonPos < this.transcript.cds().length()) {
                        String codonOld = this.transcript.cds().substring(minCodonPos, maxCodonPos);
                        codonOld = codonOld.toUpperCase();
                        String aaOld = codonTable.aa(codonOld);
                        String codonNew = "";
                        String aaNew = "";
                        if (exon.isStrandMinus()) {
                            ins = GprSeq.reverseWc(insPlus);
                        }
                        Variant variant = new Variant((Marker)this.chromosome, pos, "", "+" + ins, "");
                        Assert.assertEquals(true, variant.isIns());
                        int idx = cdsCodonPos;
                        if (this.transcript.isStrandMinus()) {
                            ++idx;
                        }
                        codonNew = codonOld.substring(0, idx) + insPlus + codonOld.substring(idx);
                        aaNew = codonTable.aa(codonNew);
                        EffectType effectExpected = null;
                        String aaExpected = "";
                        if (insLen % 3 != 0) {
                            effectExpected = EffectType.FRAME_SHIFT;
                            aaExpected = aaOld + "/" + aaNew;
                        } else {
                            if (cdsCodonPos == 0) {
                                effectExpected = EffectType.CODON_INSERTION;
                                aaExpected = aaOld + "/" + aaNew;
                            } else if (codonNew.startsWith(codonOld)) {
                                effectExpected = EffectType.CODON_INSERTION;
                                aaExpected = aaOld + "/" + aaNew;
                            } else {
                                effectExpected = EffectType.CODON_CHANGE_PLUS_CODON_INSERTION;
                                aaExpected = aaOld + "/" + aaNew;
                            }
                            if (cdsCodonNum == 0 && codonTable.isStartFirst(codonOld) && !codonTable.isStartFirst(codonNew)) {
                                effectExpected = EffectType.START_LOST;
                                aaExpected = aaOld + "/" + aaNew;
                            } else if (aaOld.indexOf(42) >= 0 && aaNew.indexOf(42) < 0) {
                                effectExpected = EffectType.STOP_LOST;
                                aaExpected = aaOld + "/" + aaNew;
                            } else if (aaNew.indexOf(42) >= 0 && aaOld.indexOf(42) < 0) {
                                effectExpected = EffectType.STOP_GAINED;
                                aaExpected = aaOld + "/" + aaNew;
                            }
                        }
                        VariantEffects effects = this.snpEffectPredictor.variantEffect(variant);
                        Assert.assertTrue(effects.size() > 0);
                        boolean ok = false;
                        for (VariantEffect effect : effects) {
                            String effFullStr = effect.effect(true, true, false, false, false);
                            String effStr = effect.effect(true, false, false, false, false);
                            String aaStr = effect.getAaChangeOld();
                            if (this.debug) {
                                System.out.println("\tPos: " + pos + "\tCDS base num: " + cdsBaseNum + " [" + cdsCodonNum + ":" + cdsCodonPos + "]\t" + variant + "\tCodon: " + codonOld + " -> " + codonNew + "\tAA: " + aaOld + " -> " + aaNew + "\n\t\tEffect          : '" + effStr + "'\t'" + effFullStr + "'\n\t\tEffect expected : '" + (Object)((Object)effectExpected) + "'\n\t\tAA              : '" + aaStr + "'\n\t\tAA expected     : '" + aaExpected + "'");
                            }
                            ok |= effect.hasEffectType(effectExpected);
                        }
                        Assert.assertTrue("Could not find effect '" + (Object)((Object)effectExpected) + "' and AA '" + aaExpected + "'", ok);
                    }
                    pos += step2;
                    ++cdsBaseNum;
                }
            }
        }
        System.err.println("");
    }
}

