/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.nextProt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.snpeff.codons.CodonTables;
import org.snpeff.collections.AutoHashMap;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;
import org.snpeff.interval.NextProt;
import org.snpeff.interval.Transcript;
import org.snpeff.nextProt.TranscriptData;
import org.snpeff.snpEffect.Config;
import org.snpeff.stats.CountByType;
import org.snpeff.util.Gpr;
import org.snpeff.util.GprSeq;
import org.snpeff.util.Timer;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NextProtParser {
    public static final double HIGHLY_CONSERVED_AA_PERCENT = 0.99;
    public static final int HIGHLY_CONSERVED_AA_COUNT = 30;
    public static final String[] CATAGORY_BLACK_LIST_STR = new String[]{"", "expression-info", "mature-protein", "mature protein", "mutagenesis site", "mutagenesis-site", "mutagenesis", "pdb-mapping", "peptide-mapping", "retained intron", "sequence conflict", "sequence-conflict", "sequence variant", "sequence-variant", "srm-peptide-mapping", "variant"};
    protected String NODE_NAME_PROTEIN;
    protected String NODE_NAME_GENE;
    protected String NODE_NAME_TRANSCRIPT;
    protected String NODE_NAME_ANNOTATION;
    protected String NODE_NAME_ANNOTATION_LIST;
    protected String NODE_NAME_POSITION;
    protected String NODE_NAME_PROPERTY;
    protected String NODE_NAME_DESCRIPTION;
    protected String NODE_NAME_CVNAME;
    protected String NODE_NAME_SEQUENCE;
    protected String NODE_NAME_XREF;
    protected String ATTR_NAME_UNIQUE_NAME;
    protected String ATTR_NAME_DATABASE;
    protected String ATTR_NAME_ACCESSION;
    protected String ATTR_NAME_ANNOTATION_LIST;
    protected String ATTR_NAME_CATAGORY;
    protected String ATTR_NAME_FIRST;
    protected String ATTR_NAME_LAST;
    protected String ATTR_NAME_ISOFORM_REF;
    protected String ATTR_NAME_PROPERTY_NAME;
    protected String ATTR_NAME_VALUE;
    protected String ATTR_VALUE_ENSEMBL;
    protected String ATTR_VALUE_REFSEQ;
    protected String ATTR_VALUE_NUCLEOTIDE_SEQUENCE_ID;
    boolean debug;
    boolean verbose;
    String trIdFile;
    HashSet<String> categoryBlackList;
    HashMap<String, String> trIdByUniqueName;
    HashMap<String, String> trIdMap;
    HashMap<String, String> sequenceByUniqueName;
    AutoHashMap<String, CountByType> countAaSequenceByType;
    HashMap<String, Transcript> trById;
    HashSet<String> proteinDifferences = new HashSet();
    HashSet<String> proteinOk = new HashSet();
    Markers markers;
    Config config;
    Genome genome;
    int aaErrors;

    public NextProtParser(Config config) {
        this.config = config;
        this.genome = config.getGenome();
        this.trIdByUniqueName = new HashMap();
        this.sequenceByUniqueName = new HashMap();
        this.countAaSequenceByType = new AutoHashMap(new CountByType());
        this.trById = new HashMap();
        this.markers = new Markers();
        this.defineNextProtXmlTerms();
        this.categoryBlackList = new HashSet();
        for (String cat2 : CATAGORY_BLACK_LIST_STR) {
            this.categoryBlackList.add(cat2);
        }
    }

    void addTr(Transcript tr) {
        String trId = tr.getId();
        this.trById.put(trId, tr);
        String id = this.trIdMap.get(trId);
        if (id != null) {
            this.trById.put(id, tr);
        }
        if (trId.indexOf(46) > 0 && (id = this.trIdMap.get(trId = trId.split("\\.")[0])) != null) {
            this.trById.put(id, tr);
        }
    }

    void addTranscripts() {
        this.readTrIdMap();
        for (Gene gene : this.config.getSnpEffectPredictor().getGenome().getGenes()) {
            for (Transcript tr : gene) {
                this.addTr(tr);
            }
        }
    }

    void analyzeSequenceConservation() {
        if (this.verbose) {
            Timer.showStdErr("Sequence conservation analysis.\n\tAA sequence length  : 1\n\tMin AA count        : 30\n\tMin AA conservation : 0.99");
        }
        ArrayList keys = new ArrayList();
        keys.addAll(this.countAaSequenceByType.keySet());
        Collections.sort(keys);
        StringBuilder title = new StringBuilder();
        for (char aa : GprSeq.AMINO_ACIDS) {
            title.append(aa + "\t");
        }
        title.append("\t" + title);
        if (this.verbose) {
            System.out.println("Amino acid regions:\n\tTotal\tMax count\tAvg len\tConservation\tCatergory\tControlled Vocabulary\t" + title + "\tOther AA sequences:");
        }
        Object object = keys.iterator();
        while (object.hasNext()) {
            String key = (String)object.next();
            long seqLen = 0L;
            long totalSeqs = 0L;
            long maxCount = 0L;
            CountByType cbt = (CountByType)this.countAaSequenceByType.get(key);
            long total = cbt.sum();
            boolean highlyConservedAaSequence = false;
            StringBuilder sb = new StringBuilder();
            for (char aa : GprSeq.AMINO_ACIDS) {
                long count2 = cbt.get("" + aa);
                if (count2 > 0L) {
                    seqLen += 1L * count2;
                    totalSeqs += count2;
                    maxCount = Math.max(maxCount, count2);
                    sb.append(count2);
                    double perc = (double)count2 / (double)total;
                    if (perc > 0.99 && total >= 30L) {
                        highlyConservedAaSequence = true;
                    }
                }
                sb.append("\t");
            }
            Object object2 = cbt.keySet().iterator();
            while (object2.hasNext()) {
                String aas = (String)object2.next();
                long count3 = cbt.get(aas);
                double perc = (double)count3 / (double)total;
                if (aas.length() <= 1) continue;
                seqLen += (long)aas.length() * count3;
                totalSeqs += count3;
                maxCount = Math.max(maxCount, count3);
                sb.append(String.format("\t" + aas + ":" + count3, new Object[0]));
                if (!(perc > 0.99) || total < 30L) continue;
                highlyConservedAaSequence = true;
            }
            long avgLen = seqLen / totalSeqs;
            if (this.verbose) {
                System.out.println("\t" + total + "\t" + maxCount + "\t" + avgLen + "\t" + (highlyConservedAaSequence ? "High" : "") + "\t" + key + "\t" + sb);
            }
            if (!highlyConservedAaSequence) continue;
            int count4 = 0;
            for (Marker m : this.markers) {
                NextProt nextProt = (NextProt)m;
                if (!m.getId().equals(key)) continue;
                nextProt.setHighlyConservedAaSequence(true);
                ++count4;
            }
            if (!this.verbose) continue;
            Timer.showStdErr("NextProt " + count4 + " markers type '" + key + "' marked as highly conserved AA sequence");
        }
    }

    void countAaSequence(String category, String contrVoc, String description, String sequence2) {
        String key = this.key(category, contrVoc, description);
        CountByType cbt = this.countAaSequenceByType.getOrCreate(key);
        cbt.inc(sequence2);
    }

    protected void defineNextProtXmlTerms() {
        this.NODE_NAME_PROTEIN = "protein";
        this.NODE_NAME_GENE = "gene";
        this.NODE_NAME_TRANSCRIPT = "transcript";
        this.NODE_NAME_ANNOTATION = "annotation";
        this.NODE_NAME_ANNOTATION_LIST = "annotationList";
        this.NODE_NAME_POSITION = "position";
        this.NODE_NAME_PROPERTY = "property";
        this.NODE_NAME_DESCRIPTION = "description";
        this.NODE_NAME_CVNAME = "cvName";
        this.NODE_NAME_SEQUENCE = "sequence";
        this.NODE_NAME_XREF = "xref";
        this.ATTR_NAME_UNIQUE_NAME = "uniqueName";
        this.ATTR_NAME_DATABASE = "database";
        this.ATTR_NAME_ACCESSION = "accession";
        this.ATTR_NAME_ANNOTATION_LIST = "annotationList";
        this.ATTR_NAME_CATAGORY = "category";
        this.ATTR_NAME_FIRST = "first";
        this.ATTR_NAME_LAST = "last";
        this.ATTR_NAME_ISOFORM_REF = "isoformRef";
        this.ATTR_NAME_PROPERTY_NAME = "propertyName";
        this.ATTR_NAME_VALUE = "value";
        this.ATTR_VALUE_ENSEMBL = "Ensembl";
        this.ATTR_VALUE_REFSEQ = "RefSeq";
        this.ATTR_VALUE_NUCLEOTIDE_SEQUENCE_ID = "'nucleotide sequence ID";
    }

    protected void fatalError(String message) {
        System.err.println("Fatal error: " + message);
        System.exit(-1);
    }

    ArrayList<Node> findNodes(Node node, String nodeName, String nodeValue, String attrName, String attrValue) {
        ArrayList<Node> resulstsList = new ArrayList<Node>();
        block5: while (node != null) {
            boolean found = false;
            short type = node.getNodeType();
            String name = node.getNodeName();
            String value2 = node.getNodeValue();
            if (value2 != null) {
                value2 = value2.replace('\n', ' ').trim();
            }
            StringBuilder attrSb = new StringBuilder();
            if (attrName != null || attrValue != null) {
                NamedNodeMap map2 = node.getAttributes();
                if (map2 != null) {
                    for (int i = 0; i < map2.getLength(); ++i) {
                        Node attr = map2.item(i);
                        if (attrSb.length() > 0) {
                            attrSb.append(", ");
                        }
                        String aname = attr.getNodeName();
                        String aval = attr.getNodeValue();
                        attrSb.append(aname + "=" + aval);
                        if (nodeName != null && (name == null || !name.equals(nodeName)) || nodeValue != null && (value2 == null || !value2.equals(nodeValue)) || attrName != null && (aname == null || !attrName.equals(aname)) || attrValue != null && (aval == null || !attrValue.equals(aval))) continue;
                        found = true;
                    }
                }
            } else if ((nodeName == null || name != null && name.equals(nodeName)) && (nodeValue == null || value2 != null && value2.equals(nodeValue))) {
                found = true;
            }
            if (found) {
                resulstsList.add(node);
            }
            switch (type) {
                case 1: {
                    NodeList nodeList = node.getChildNodes();
                    resulstsList.addAll(this.findNodes(nodeList, nodeName, nodeValue, attrName, attrValue));
                    node = node.getNextSibling();
                    continue block5;
                }
                case 3: {
                    node = null;
                    continue block5;
                }
                case 4: {
                    node = null;
                    continue block5;
                }
            }
            node = null;
        }
        return resulstsList;
    }

    List<Node> findNodes(NodeList nodeList, String nodeName, String nodeValue, String attrName, String attrValue) {
        ArrayList<Node> resulstsList = new ArrayList<Node>();
        for (int temp = 0; temp < nodeList.getLength(); ++temp) {
            Node node = nodeList.item(temp);
            resulstsList.addAll(this.findNodes(node, nodeName, nodeValue, attrName, attrValue));
        }
        return resulstsList;
    }

    Node findOneNode(Node node, String nodeName, String nodeValue, String attrName, String attrValue) {
        ArrayList<Node> resulstsList = this.findNodes(node, nodeName, nodeValue, attrName, attrValue);
        if (resulstsList.isEmpty()) {
            return null;
        }
        return resulstsList.get(0);
    }

    void findSequences(Node node) {
        ArrayList<Node> seqNodes = this.findNodes(node, this.NODE_NAME_SEQUENCE, null, null, null);
        for (Node seq2 : seqNodes) {
            String seqStr = this.getText(seq2);
            String uniq = this.getUniqueNameSequence(seq2);
            this.sequenceByUniqueName.put(uniq, seqStr);
        }
    }

    boolean findTrIds(Node node) {
        boolean added = false;
        ArrayList<Node> ensemblTrIds = this.findNodes(node, this.NODE_NAME_TRANSCRIPT, null, this.ATTR_NAME_DATABASE, this.ATTR_VALUE_ENSEMBL);
        for (Node trNode : ensemblTrIds) {
            String trId = this.getAttribute(trNode, this.ATTR_NAME_ACCESSION);
            String trUniqName = this.getUniqueNameTranscript(trNode);
            this.trIdByUniqueName.put(trUniqName, trId);
            added = true;
        }
        return added;
    }

    protected int getAaEnd(Node posNode) {
        String last2 = this.getAttribute(posNode, this.ATTR_NAME_LAST);
        int aaEnd = Gpr.parseIntSafe(last2) - 1;
        return aaEnd;
    }

    protected int getAaStart(Node posNode) {
        String first = this.getAttribute(posNode, this.ATTR_NAME_FIRST);
        int aaStart = Gpr.parseIntSafe(first) - 1;
        return aaStart;
    }

    String getAnnDescription(Node annNode) {
        Node descr = this.findOneNode(annNode, this.NODE_NAME_DESCRIPTION, null, null, null);
        String description = this.getText(descr);
        if (description == null) {
            description = "";
        } else if (description.indexOf(59) > 0) {
            description = description.substring(0, description.indexOf(59));
        }
        return description;
    }

    List<Node> getAnnotationCategories(Node node) {
        ArrayList<Node> annListNodes = this.findNodes(node, this.NODE_NAME_ANNOTATION_LIST, null, null, null);
        return annListNodes;
    }

    String getAttribute(Node node, String attrName) {
        if (node == null) {
            return null;
        }
        NamedNodeMap map2 = node.getAttributes();
        if (map2 == null) {
            return null;
        }
        Node attrNode = map2.getNamedItem(attrName);
        if (attrNode == null) {
            return null;
        }
        return attrNode.getNodeValue();
    }

    String getControlledVocubulary(Node annNode) {
        Node cv = this.findOneNode(annNode, this.NODE_NAME_CVNAME, null, null, null);
        String contrVoc = this.getText(cv);
        if (contrVoc == null) {
            contrVoc = "";
        }
        contrVoc.indexOf(59);
        String[] cvs = contrVoc.split(";", 2);
        if (cvs.length > 1) {
            return cvs[0];
        }
        return contrVoc;
    }

    String getGeneId(Node node, String uniqueName) {
        Node geneNode = this.findOneNode(node, this.NODE_NAME_GENE, null, this.ATTR_NAME_DATABASE, this.ATTR_VALUE_ENSEMBL);
        return this.getAttribute(geneNode, this.ATTR_NAME_ACCESSION);
    }

    protected String getIsoformRefFromPos(Node posNode) {
        Node isoAnn = posNode.getParentNode().getParentNode();
        String isoformRef = this.getAttribute(isoAnn, this.ATTR_NAME_ISOFORM_REF);
        return isoformRef;
    }

    public Markers getMarkers() {
        return this.markers;
    }

    String getText(Node n) {
        if (n == null) {
            return null;
        }
        return n.getTextContent().replace('\n', ' ').trim();
    }

    String getUniqueNameSequence(Node seqNode) {
        Node iso = seqNode.getParentNode();
        String seqUniqName = this.getAttribute(iso, this.ATTR_NAME_UNIQUE_NAME);
        return seqUniqName;
    }

    String getUniqueNameTranscript(Node trNode) {
        Node isoMap = trNode.getParentNode();
        String trUniqName = this.getAttribute(isoMap, this.ATTR_NAME_UNIQUE_NAME);
        return trUniqName;
    }

    String key(String category, String contrVoc, String description) {
        category = this.vcfSafe(category);
        if (description == null || description.isEmpty()) {
            description = contrVoc;
        }
        if ((description = this.vcfSafe(description)).isEmpty()) {
            return category;
        }
        return category + ":" + description;
    }

    String nodeType(short type) {
        switch (type) {
            case 2: {
                return "ATTRIBUTE_NODE";
            }
            case 4: {
                return "CDATA_SECTION_NODE";
            }
            case 8: {
                return "COMMENT_NODE";
            }
            case 11: {
                return "DOCUMENT_FRAGMENT_NODE";
            }
            case 9: {
                return "DOCUMENT_NODE";
            }
            case 16: {
                return "DOCUMENT_POSITION_CONTAINED_BY";
            }
            case 10: {
                return "DOCUMENT_TYPE_NODE";
            }
            case 1: {
                return "ELEMENT_NODE";
            }
            case 6: {
                return "ENTITY_NODE";
            }
            case 5: {
                return "ENTITY_REFERENCE_NODE";
            }
            case 12: {
                return "NOTATION_NODE";
            }
            case 7: {
                return "PROCESSING_INSTRUCTION_NODE";
            }
            case 3: {
                return "TEXT_NODE";
            }
        }
        throw new RuntimeException("Unknown");
    }

    public void parse(Node doc) {
        this.addTranscripts();
        if (this.verbose) {
            Timer.showStdErr("Parsing XML data.");
        }
        List<Node> nodeList = this.findNodes(doc.getChildNodes(), this.NODE_NAME_PROTEIN, null, null, null);
        if (this.verbose) {
            Timer.showStdErr("Found " + nodeList.size() + " protein nodes");
        }
        for (Node node : nodeList) {
            if (this.debug) {
                Gpr.debug("Processing protein node: " + this.toString(node));
            }
            this.parseProteinNode(node);
        }
        this.analyzeSequenceConservation();
    }

    void parseAnnotation(Node ann, String geneId, String category) {
        if (this.debug) {
            Gpr.debug("\t\tAnnotation: " + this.toString(ann) + "\tCategory: " + category);
        }
        String description = this.getAnnDescription(ann);
        String contrVoc = this.getControlledVocubulary(ann);
        ArrayList<Node> posNodes = this.findNodes(ann, this.NODE_NAME_POSITION, null, null, null);
        for (Node pos : posNodes) {
            if (this.debug) {
                Gpr.debug("\t\t\tPosition: " + this.toString(pos));
            }
            int aaStart = this.getAaStart(pos);
            int aaEnd = this.getAaStart(pos);
            if (aaStart < 0 || aaEnd < 0) continue;
            int len = aaEnd - aaStart + 1;
            String isoformRef = this.getIsoformRefFromPos(pos);
            String sequence2 = this.sequenceByUniqueName.get(isoformRef);
            String subSeq = "";
            if (sequence2 != null && aaStart >= 0 && aaEnd >= aaStart && aaEnd < sequence2.length()) {
                subSeq = sequence2.substring(aaStart, aaEnd + 1);
            }
            TranscriptData trData = this.transcriptData(isoformRef, aaStart, aaEnd, sequence2, subSeq);
            if (!trData.ok || len <= 0) continue;
            String id = this.key(category, contrVoc, description);
            NextProt nextProt = new NextProt(trData.tr, trData.chrPosStart, trData.chrPosEnd, id);
            this.markers.add(nextProt);
            if (this.debug) {
                Gpr.debug("Added NextProt entry:" + nextProt + "\n\tgeneId:" + geneId + "\n\tisoformRef:" + isoformRef + "\n\ttrId:" + trData.tr.getId() + "\n\tcategory:'" + category + "'\n\tdescription:'" + description + "'\n\tcontrolled_vocabulary:" + contrVoc + "\n\taaStart:" + aaStart + "\n\taaEnd:" + aaEnd + "\n\taaLen:" + len + "\n\tchr:" + trData.chrName + "\n\tstart:" + trData.chrPosStart + "\n\tend:" + trData.chrPosEnd + "\n\tsubSeq:" + subSeq + "\n\tcodon:" + trData.codon + "\n\taa:" + trData.aa);
            }
            this.countAaSequence(category, contrVoc, description, subSeq);
        }
    }

    void parseAnnotations(Node node, String geneId) {
        List<Node> annListNodes = this.getAnnotationCategories(node);
        for (Node annListNode : annListNodes) {
            String category = this.getAttribute(annListNode, this.ATTR_NAME_CATAGORY);
            if (this.categoryBlackList.contains(category)) continue;
            ArrayList<Node> annNodes = this.findNodes(annListNode, this.NODE_NAME_ANNOTATION, null, null, null);
            for (Node ann : annNodes) {
                this.parseAnnotation(ann, geneId, category);
            }
        }
    }

    void parseProteinNode(Node node) {
        String geneId;
        String uniqueName = this.getAttribute(node, this.ATTR_NAME_UNIQUE_NAME);
        if (this.debug) {
            Timer.showStdErr("Parsing protein node: " + uniqueName);
        }
        if ((geneId = this.getGeneId(node, uniqueName)) != null) {
            if (this.debug) {
                Timer.showStdErr("\tFound matching gene ID: " + geneId);
            }
            if (this.findTrIds(node)) {
                this.findSequences(node);
                this.parseAnnotations(node, geneId);
            }
        }
    }

    void readTrIdMap() {
        String[] lines2;
        this.trIdMap = new HashMap();
        if (this.trIdFile == null) {
            return;
        }
        if (this.verbose) {
            Timer.showStdErr("Reading transcripts file '" + this.trIdFile + "'");
        }
        for (String line : lines2 = Gpr.readFile(this.trIdFile).split("\n")) {
            String[] ids = line.split("\t");
            if (ids.length <= 1) continue;
            String ensemblId = ids[0].trim();
            String refSeqId = ids[1].trim();
            this.trIdMap.put(refSeqId, ensemblId);
        }
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setTrIdFile(String trIdFile) {
        this.trIdFile = trIdFile;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    String toString(Node node) {
        StringBuilder sb = new StringBuilder();
        String name = node.getNodeName();
        String value2 = node.getNodeValue();
        if (value2 != null) {
            value2 = value2.replace('\n', ' ').trim();
        }
        sb.append(name);
        NamedNodeMap map2 = node.getAttributes();
        if (map2 != null) {
            sb.append("( ");
            for (int i = 0; i < map2.getLength(); ++i) {
                Node attr = map2.item(i);
                String aname = attr.getNodeName();
                String aval = attr.getNodeValue();
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(aname + "='" + aval + "'");
            }
            sb.append(" )");
        }
        if (value2 != null) {
            sb.append(" = '" + value2 + "'\n");
        }
        return sb.toString();
    }

    TranscriptData transcriptData(String isoformRef, int aaStart, int aaEnd, String sequence2, String subSeq) {
        Transcript tr;
        String trId = this.trIdByUniqueName.get(isoformRef);
        TranscriptData trData = new TranscriptData();
        if (trId != null && (tr = this.trById.get(trId)) != null) {
            trData.tr = tr;
            String protein = tr.protein();
            if (!protein.isEmpty() && protein.charAt(protein.length() - 1) == '*') {
                protein = protein.substring(0, protein.length() - 1);
            }
            if (protein.equals(sequence2)) {
                this.proteinOk.add(trId);
                if (aaStart >= 0 && aaEnd >= aaStart) {
                    int[] cdsBase2Pos = tr.baseNumberCds2Pos();
                    int codonStart = aaStart * 3;
                    int codonEnd = (aaEnd + 1) * 3 - 1;
                    if (codonStart < cdsBase2Pos.length && codonEnd < cdsBase2Pos.length) {
                        if (tr.isStrandPlus()) {
                            trData.chrPosStart = cdsBase2Pos[codonStart];
                            trData.chrPosEnd = cdsBase2Pos[codonEnd];
                        } else {
                            trData.chrPosStart = cdsBase2Pos[codonEnd];
                            trData.chrPosEnd = cdsBase2Pos[codonStart];
                        }
                        trData.chrName = tr.getChromosomeName();
                        trData.codon = tr.cds().substring(codonStart, codonEnd + 1);
                        trData.aa = CodonTables.getInstance().aa(trData.codon, this.genome, trData.chrName);
                        if (!subSeq.equals(trData.aa) && this.verbose) {
                            Timer.showStdErr("WARNING: AA differ: \tUniqueName : " + isoformRef + "\tEnsembl ID : " + trId + "\tEnsembl  AA: '" + trData.aa + "'\tNextProt AA: '" + subSeq + "'\n");
                        } else {
                            trData.ok = true;
                        }
                    }
                }
            } else {
                if (!this.proteinDifferences.contains(trId) && this.verbose) {
                    Timer.showStdErr("WARNING: Protein sequences differ: \tUniqueName" + isoformRef + "\tEnsembl ID: " + trId + "\n\tEnsembl  (" + protein.length() + "): " + protein + "\n\tNextProt (" + sequence2.length() + "): " + sequence2 + "\n");
                }
                this.proteinDifferences.add(trId);
            }
        }
        return trData;
    }

    String vcfSafe(String str) {
        return str.trim().replaceAll("(,|;|=| |\t)+", "_");
    }
}

