/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.geneSets;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.snpeff.fileIterator.LineFileIterator;
import org.snpeff.geneOntology.GoTerm;
import org.snpeff.geneOntology.GoTerms;
import org.snpeff.geneSets.GeneSet;
import org.snpeff.util.Gpr;
import org.snpeff.util.Timer;

public class GeneSets
implements Iterable<GeneSet>,
Serializable {
    private static final long serialVersionUID = -359594418467719013L;
    public static boolean debug = false;
    public static double LOG2 = Math.log(2.0);
    public static long PRINT_SOMETHING_TIME = 5000L;
    static int warnCount = 0;
    boolean verbose = false;
    boolean doNotAddIfNotInGeneSet = false;
    String label;
    HashSet<String> genes;
    HashMap<String, GeneSet> geneSetsByName;
    HashMap<String, HashSet<GeneSet>> geneSetsByGene;
    HashSet<String> interestingGenes;
    HashMap<String, Double> valueByGene;

    public static GeneSets factory(GoTerms goTerms) {
        GeneSets geneSets = new GeneSets();
        for (GoTerm gt : goTerms) {
            GeneSet geneSet = new GeneSet(gt.getAcc(), gt.getDescription(), geneSets);
            for (String id : gt) {
                geneSet.addGene(id);
            }
            geneSets.add(geneSet);
        }
        return geneSets;
    }

    public GeneSets() {
        this.init();
    }

    public GeneSets(GeneSets geneSets) {
        this.init();
        this.copy(geneSets);
    }

    public GeneSets(String msigDb) {
        this.init();
        this.loadMSigDb(msigDb, false);
    }

    public void add(GeneSet geneSet) {
        this.geneSetsByName.put(geneSet.getName().toUpperCase(), geneSet);
        for (String gene : geneSet) {
            this.add(gene, geneSet);
        }
        geneSet.setGeneSets(this);
    }

    public boolean add(String gene) {
        return this.genes.add(gene);
    }

    public boolean add(String gene, GeneSet geneSet) {
        HashSet<GeneSet> listgs = this.geneSetsByGene.get(gene);
        if (listgs == null) {
            listgs = new HashSet();
            this.geneSetsByGene.put(gene, listgs);
        }
        listgs.add(geneSet);
        return this.genes.add(gene);
    }

    public boolean addInteresting(String gene) {
        boolean ok = true;
        if (!this.genes.contains(gene)) {
            if (debug) {
                System.err.println("WARNING: Trying to add ranked gene. Gene  '" + gene + "' does not exist in GeneSets. " + (this.doNotAddIfNotInGeneSet ? "Ignored." : "Added anyway."));
            }
            ok = false;
            if (this.doNotAddIfNotInGeneSet) {
                return ok;
            }
            this.add(gene);
        }
        this.interestingGenes.add(gene);
        return ok;
    }

    public void checkInterestingGenes(Set<String> intGenes) {
        if (debug) {
            Timer.showStdErr("Checking genes (" + intGenes.size() + ") : " + intGenes);
        }
        if (!intGenes.containsAll(this.interestingGenes)) {
            throw new RuntimeException("Not every gene in :" + this.label + " as an interesting symbol");
        }
        if (!this.interestingGenes.containsAll(intGenes)) {
            throw new RuntimeException("Not every gene marked as interesting in " + this.label + " is from intGenes\n\tInteresting genes(" + this.interestingGenes.size() + "): " + this.interestingGenes + "\n\tintGenes(" + intGenes.size() + "): " + intGenes);
        }
    }

    protected void copy(GeneSets geneSets) {
        this.interestingGenes.addAll(geneSets.interestingGenes);
        this.genes.addAll(geneSets.genes);
        this.valueByGene.putAll(geneSets.valueByGene);
        this.geneSetsByName.putAll(geneSets.geneSetsByName);
        this.geneSetsByGene.putAll(geneSets.geneSetsByGene);
        for (GeneSet gs : this.geneSetsByName.values()) {
            gs.setGeneSets(this);
        }
    }

    public GeneSet disjointSet(List<GeneSet> geneSetList, int activeSets) {
        GeneSet gtUnion = new GeneSet("UNION", "UNION", null);
        GeneSet gtIntersect = new GeneSet("INTERSECTION", "INTERSECTION", null);
        int i = 0;
        boolean firstIntersection = true;
        for (GeneSet geneSet : geneSetList) {
            boolean biti;
            boolean bl = biti = ((long)activeSets & 1L << i) > 0L;
            if (biti) {
                if (firstIntersection) {
                    gtIntersect.union(geneSet);
                    firstIntersection = false;
                } else {
                    gtIntersect.intersection(geneSet);
                    if (gtIntersect.getGeneCount() <= 0) {
                        return gtIntersect;
                    }
                }
            } else {
                gtUnion.union(geneSet);
            }
            ++i;
        }
        gtIntersect.setMinus(gtUnion);
        return gtIntersect;
    }

    public List<GeneSet> geneSetsSorted() {
        LinkedList<GeneSet> ll = new LinkedList<GeneSet>(this.geneSetsByName.values());
        Collections.sort(ll);
        return ll;
    }

    public List<GeneSet> geneSetsSortedSize(final boolean reverse2) {
        ArrayList<GeneSet> ll = new ArrayList<GeneSet>(this.geneSetsByName.values());
        Collections.sort(ll, new Comparator<GeneSet>(){

            @Override
            public int compare(GeneSet gs1, GeneSet gs2) {
                int diff2 = gs1.size() - gs2.size();
                if (diff2 != 0) {
                    return reverse2 ? -diff2 : diff2;
                }
                return gs1.getName().compareTo(gs2.getName());
            }
        });
        return ll;
    }

    public int getGeneCount() {
        if (this.genes == null) {
            return 0;
        }
        return this.genes.size();
    }

    public Set<String> getGenes() {
        return this.genes;
    }

    public GeneSet getGeneSet(String geneSetName) {
        return this.geneSetsByName.get(geneSetName.toUpperCase());
    }

    public int getGeneSetCount() {
        if (this.geneSetsByName == null) {
            return 0;
        }
        return this.geneSetsByName.size();
    }

    public HashSet<GeneSet> getGeneSetsByGene(String gene) {
        return this.geneSetsByGene.get(gene);
    }

    public HashMap<String, GeneSet> getGeneSetsByName() {
        return this.geneSetsByName;
    }

    public HashSet<String> getInterestingGenes() {
        return this.interestingGenes;
    }

    public int getInterestingGenesCount() {
        return this.interestingGenes.size();
    }

    public String getLabel() {
        return this.label;
    }

    public double getValue(String gene) {
        Double val = this.valueByGene.get(gene);
        if (val == null) {
            return 0.0;
        }
        return val;
    }

    public HashMap<String, Double> getValueByGene() {
        return this.valueByGene;
    }

    public boolean hasGene(String geneId) {
        return this.genes.contains(geneId);
    }

    public boolean hasValue(String gene) {
        return this.valueByGene.containsKey(gene);
    }

    void init() {
        this.interestingGenes = new HashSet();
        this.valueByGene = new HashMap();
        this.geneSetsByName = new HashMap();
        this.genes = new HashSet();
        this.geneSetsByGene = new HashMap();
    }

    public boolean isInteresting(String geneName) {
        return this.interestingGenes.contains(geneName);
    }

    public boolean isRanked() {
        return false;
    }

    protected boolean isUsed(GeneSet gs) {
        for (String gene : gs) {
            if (!this.isUsed(gene)) continue;
            return true;
        }
        return false;
    }

    protected boolean isUsed(String geneName) {
        return this.isInteresting(geneName);
    }

    @Override
    public Iterator<GeneSet> iterator() {
        return this.geneSetsByName.values().iterator();
    }

    public Iterator<GeneSet> iteratorSorted() {
        return this.geneSetsSorted().iterator();
    }

    public Set<String> keySet() {
        return this.geneSetsByName.keySet();
    }

    public List<GeneSet> listTopTerms(int numberToSelect) {
        LinkedList<GeneSet> list2 = new LinkedList<GeneSet>();
        int i = 0;
        LinkedList<GeneSet> ll = new LinkedList<GeneSet>();
        for (String geneSetName : this.keySet()) {
            ll.add(this.getGeneSet(geneSetName));
        }
        Collections.sort(ll);
        for (GeneSet geneSet : ll) {
            if (i++ >= numberToSelect) continue;
            list2.add(geneSet);
        }
        return list2;
    }

    public List<String> loadExperimentalValues(String fileName, boolean maskException) {
        LinkedList<String> notFound = new LinkedList<String>();
        if (this.verbose) {
            System.err.println("Reading 'ranked' genes from file: '" + fileName + "'");
        }
        this.reset();
        try {
            String line;
            BufferedReader inFile = new BufferedReader(new FileReader(fileName));
            while ((line = inFile.readLine()) != null) {
                String[] fields;
                String gene;
                if (line.startsWith("#") || (gene = (fields = line.split("\t"))[0]).isEmpty()) continue;
                Double value2 = Double.parseDouble(fields[1]);
                this.setValue(gene, value2);
                if (this.genes.contains(gene)) continue;
                notFound.add(gene);
            }
            inFile.close();
        }
        catch (IOException e) {
            if (maskException) {
                return null;
            }
            throw new RuntimeException(e);
        }
        return notFound;
    }

    public boolean loadMSigDb(String gmtFile, boolean maskException) {
        try {
            if (this.verbose) {
                System.err.println("Reading gene sets file: '" + gmtFile + "'");
            }
            this.genes = new HashSet();
            this.geneSetsByName = new HashMap();
            LineFileIterator lfi = new LineFileIterator(gmtFile);
            for (String line : lfi) {
                if ((line = line.trim()).startsWith("#")) continue;
                String[] fields = line.split("\t");
                String geneSetName = fields[0];
                String description = fields[1];
                if (this.getGeneSet(geneSetName) != null) {
                    Gpr.debug("Error: File '" + gmtFile + "' line " + lfi.getLineNum() + ". Gene set name '" + geneSetName + "' duplicated.");
                }
                GeneSet gs = new GeneSet(geneSetName, description, this);
                for (int i = 2; i < fields.length; ++i) {
                    gs.addGene(fields[i]);
                }
                this.add(gs);
            }
            if (this.verbose) {
                System.err.println("GeneSets added: " + this.geneSetsByName.size());
            }
        }
        catch (Exception e) {
            if (maskException) {
                return false;
            }
            throw new RuntimeException(e);
        }
        return true;
    }

    public void remove(GeneSet geneSet) {
        if (geneSet == null) {
            return;
        }
        this.geneSetsByName.remove(geneSet.getName());
    }

    public void removeGeneSet(String geneSetName) {
        this.remove(this.getGeneSet(geneSetName));
    }

    public void removeUnusedSets() {
        LinkedList<GeneSet> todelete = new LinkedList<GeneSet>();
        for (GeneSet gs : this) {
            if (this.isUsed(gs)) continue;
            todelete.add(gs);
        }
        for (GeneSet gs : todelete) {
            this.remove(gs);
        }
        Gpr.debug("Removind unused gene sets:\n\t\tTotal removed: " + todelete.size() + "\n\t\tRemaining: " + this.geneSetsByName.size());
    }

    public void reset() {
        this.interestingGenes = new HashSet();
        this.valueByGene = new HashMap();
        for (GeneSet gt : this) {
            gt.reset();
        }
    }

    public void saveGseaGeneSets(String fileName) {
        StringBuffer out = new StringBuffer();
        for (GeneSet gt : this) {
            if (gt.getGenes().size() <= 0) continue;
            out.append(gt.getName() + "\t" + gt.getName() + "\t");
            for (String gene : gt.getGenes()) {
                out.append("gene_" + gene + "\t");
            }
            out.append("\n");
        }
        Gpr.toFile(fileName, out);
    }

    public void setDoNotAddIfNotInGeneSet(boolean doNotAddIfNotInGeneSet) {
        this.doNotAddIfNotInGeneSet = doNotAddIfNotInGeneSet;
    }

    public void setGeneSetByName(HashMap<String, GeneSet> geneSets) {
        this.geneSetsByName = geneSets;
    }

    public void setInterestingGenes(HashSet<String> interestingGenesIdSet) {
        this.interestingGenes = interestingGenesIdSet;
    }

    public void setValue(String geneId, double value2) {
        this.valueByGene.put(geneId, value2);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (GeneSet gs : this.geneSetsSorted()) {
            sb.append(gs.toStringAll() + "\n");
        }
        return sb.toString();
    }

    public Collection<GeneSet> values() {
        return this.geneSetsByName.values();
    }
}

