/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.location.template;

import java.util.ArrayList;
import java.util.List;
import org.biojava3.core.sequence.Strand;
import org.biojava3.core.sequence.location.SimpleLocation;
import org.biojava3.core.sequence.location.SimplePoint;
import org.biojava3.core.sequence.location.template.Point;
import org.biojava3.core.sequence.template.Accessioned;
import org.biojava3.core.sequence.template.Compound;
import org.biojava3.core.sequence.template.Sequence;

public interface Location
extends Iterable<Location>,
Accessioned {
    public static final Location EMPTY = new SimpleLocation(Integer.MIN_VALUE, Integer.MAX_VALUE, Strand.UNDEFINED);

    public Point getStart();

    public Point getEnd();

    public int getLength();

    public Strand getStrand();

    public List<Location> getSubLocations();

    public List<Location> getRelevantSubLocations();

    public boolean isComplex();

    public boolean isCircular();

    public boolean isBetweenCompounds();

    public <C extends Compound> Sequence<C> getSubSequence(Sequence<C> var1);

    public <C extends Compound> Sequence<C> getRelevantSubSequence(Sequence<C> var1);

    public static class Tools {
        public static Location location(List<Location> locations, Integer sequenceLength, String type) {
            type = type == null ? "join" : type;
            sequenceLength = sequenceLength == null ? -1 : sequenceLength;
            return null;
        }

        public static Location location(int start, int end, Strand strand, int length) {
            boolean isReverse;
            int min2 = Math.min(start, end);
            boolean bl = isReverse = min2 != start;
            if (isReverse) {
                return new SimpleLocation(new SimplePoint(start).reverse(length), new SimplePoint(end).reverse(length), strand);
            }
            return new SimpleLocation(start, end, strand);
        }

        public static Location circularLocation(int start, int end, Strand strand, int length) {
            boolean isReverse;
            int min2 = Math.min(start, end);
            int max2 = Math.max(start, end);
            boolean bl = isReverse = min2 != start;
            if (min2 > length) {
                throw new IllegalArgumentException("Cannot process a location whose lowest coordinate is less than the given length " + length);
            }
            if (max2 <= length) {
                return Tools.location(start, end, strand, length);
            }
            int modStart = Tools.modulateCircularIndex(start, length);
            int modEnd = Tools.modulateCircularIndex(end, length);
            int numberOfPasses = Tools.completeCircularPasses(Math.max(start, end), length);
            if (isReverse) {
                int reversedModStart = new SimplePoint(modStart).reverse(length).getPosition();
                int reversedModEnd = new SimplePoint(modEnd).reverse(length).getPosition();
                modStart = reversedModStart;
                modEnd = reversedModEnd;
                start = reversedModStart;
                end = length * (numberOfPasses + 1) + modEnd;
            }
            ArrayList<Location> locations = new ArrayList<Location>();
            locations.add(new SimpleLocation(modStart, length, strand));
            for (int i = 0; i < numberOfPasses; ++i) {
                locations.add(new SimpleLocation(1, length, strand));
            }
            locations.add(new SimpleLocation(1, modEnd, strand));
            return new SimpleLocation((Point)new SimplePoint(start), (Point)new SimplePoint(end), strand, true, false, locations);
        }

        public static Location getMin(List<Location> locations) {
            return Tools.scanLocations(locations, new LocationPredicate(){

                @Override
                public boolean accept(Location previous, Location current) {
                    int res = current.getStart().compareTo(previous.getStart());
                    return res < 0;
                }
            });
        }

        public static Location getMax(List<Location> locations) {
            return Tools.scanLocations(locations, new LocationPredicate(){

                @Override
                public boolean accept(Location previous, Location current) {
                    int res = current.getEnd().compareTo(previous.getEnd());
                    return res > 0;
                }
            });
        }

        private static Location scanLocations(List<Location> locations, LocationPredicate predicate) {
            Location location = null;
            for (Location l : locations) {
                if (location == null) {
                    location = l;
                    continue;
                }
                if (!predicate.accept(location, l)) continue;
                location = l;
            }
            return location;
        }

        public static int modulateCircularIndex(int index2, int seqLength) {
            if (seqLength == 0) {
                return index2;
            }
            while (index2 > seqLength) {
                index2 -= seqLength;
            }
            return index2;
        }

        public static int completeCircularPasses(int index2, int seqLength) {
            int count2 = 0;
            while (index2 > seqLength) {
                ++count2;
                index2 -= seqLength;
            }
            return count2 - 1;
        }

        private static interface LocationPredicate {
            public boolean accept(Location var1, Location var2);
        }
    }
}

