/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.io;

import java.util.ArrayList;
import org.biojava3.core.sequence.AccessionID;
import org.biojava3.core.sequence.DataSource;
import org.biojava3.core.sequence.ProteinSequence;
import org.biojava3.core.sequence.io.template.SequenceHeaderParserInterface;
import org.biojava3.core.sequence.template.AbstractSequence;
import org.biojava3.core.sequence.template.Compound;

public class GenericFastaHeaderParser<S extends AbstractSequence<C>, C extends Compound>
implements SequenceHeaderParserInterface<S, C> {
    private String[] getHeaderValues(String header) {
        String[] data2 = new String[]{};
        ArrayList<String> values2 = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        if (!header.startsWith("PDB:")) {
            for (int i = 0; i < header.length(); ++i) {
                if (header.charAt(i) == '|') {
                    values2.add(sb.toString());
                    sb.setLength(0);
                } else if (i == header.length() - 1) {
                    sb.append(header.charAt(i));
                    values2.add(sb.toString());
                } else {
                    sb.append(header.charAt(i));
                }
                data2 = new String[values2.size()];
                values2.toArray(data2);
            }
        } else {
            data2 = header.split(" ");
        }
        return data2;
    }

    @Override
    public void parseHeader(String header, S sequence2) {
        ((AbstractSequence)sequence2).setOriginalHeader(header);
        String[] data2 = this.getHeaderValues(header);
        if (data2.length == 1) {
            ((AbstractSequence)sequence2).setAccession(new AccessionID(data2[0]));
        } else if (data2[0].equalsIgnoreCase("sp") || data2[0].equalsIgnoreCase("tr")) {
            if (data2[0].equalsIgnoreCase("sp")) {
                ((AbstractSequence)sequence2).setAnnotationType(AbstractSequence.AnnotationType.CURATED);
            } else {
                ((AbstractSequence)sequence2).setAnnotationType(AbstractSequence.AnnotationType.PREDICTED);
            }
            ((AbstractSequence)sequence2).setAccession(new AccessionID(data2[1], DataSource.UNIPROT));
            if (data2.length > 1) {
                ((AbstractSequence)sequence2).setDescription(data2[2]);
            }
        } else if (data2[0].equalsIgnoreCase("gi")) {
            DataSource giSource = DataSource.UNKNOWN;
            if (data2.length >= 3) {
                if (data2[2].equalsIgnoreCase("gb")) {
                    giSource = DataSource.GENBANK;
                } else if (data2[2].equalsIgnoreCase("emb")) {
                    giSource = DataSource.ENA;
                } else if (data2[2].equalsIgnoreCase("dbj")) {
                    giSource = DataSource.DDBJ;
                }
                ((AbstractSequence)sequence2).setAccession(new AccessionID(data2[3], giSource));
            } else {
                ((AbstractSequence)sequence2).setAccession(new AccessionID(header, giSource));
            }
        } else if (data2[0].equalsIgnoreCase("pir")) {
            ((AbstractSequence)sequence2).setAccession(new AccessionID(data2[2], DataSource.NBRF));
        } else if (data2[0].equalsIgnoreCase("prf")) {
            ((AbstractSequence)sequence2).setAccession(new AccessionID(data2[2], DataSource.PRF));
        } else if (data2[0].equalsIgnoreCase("pdb")) {
            ((AbstractSequence)sequence2).setAccession(new AccessionID(data2[1] + ":" + data2[2], DataSource.PDB1));
        } else if (data2[0].startsWith("PDB")) {
            String[] pdbe = data2[0].split(" ");
            String[] pdbaccession = pdbe[0].split(":");
            ((AbstractSequence)sequence2).setAccession(new AccessionID(pdbaccession[1], DataSource.PDBe));
        } else if (data2[0].indexOf(":") != -1 && data2.length > 1 && data2[1].equals("PDBID")) {
            ((AbstractSequence)sequence2).setAccession(new AccessionID(data2[0], DataSource.PDB2));
        } else if (data2[0].equalsIgnoreCase("pat")) {
            ((AbstractSequence)sequence2).setAccession(new AccessionID(data2[2], DataSource.PATENTS));
        } else if (data2[0].equalsIgnoreCase("bbs")) {
            ((AbstractSequence)sequence2).setAccession(new AccessionID(data2[1], DataSource.GENINFO));
        } else if (data2[0].equalsIgnoreCase("gnl")) {
            ((AbstractSequence)sequence2).setAccession(new AccessionID(data2[2], DataSource.GENERAL));
        } else if (data2[0].equalsIgnoreCase("ref")) {
            ((AbstractSequence)sequence2).setAccession(new AccessionID(data2[1], DataSource.NCBI));
        } else if (data2[0].equalsIgnoreCase("lcl")) {
            ((AbstractSequence)sequence2).setAccession(new AccessionID(data2[1], DataSource.LOCAL));
        } else {
            ((AbstractSequence)sequence2).setAccession(new AccessionID(data2[0]));
        }
    }

    public static void main(String[] args) {
        System.out.println("parseHeader");
        String header = "";
        ProteinSequence sequence2 = new ProteinSequence("");
        GenericFastaHeaderParser instance = new GenericFastaHeaderParser();
        header = "gi|gi-number|gb|accession|locus";
        instance.parseHeader(header, (S)sequence2);
        System.out.println("accession=" + sequence2.getAccession());
        System.out.println((Object)((Object)sequence2.getAccession().getDataSource()) + "=" + (Object)((Object)DataSource.GENBANK));
        header = "gi|gi-number|emb|accession|locus";
        instance.parseHeader(header, (S)sequence2);
        System.out.println("accession=" + sequence2.getAccession());
        System.out.println((Object)((Object)sequence2.getAccession().getDataSource()) + "=" + (Object)((Object)DataSource.ENA));
        header = "gi|gi-number|dbj|accession|locus";
        instance.parseHeader(header, (S)sequence2);
        System.out.println("accession=" + sequence2.getAccession());
        System.out.println((Object)((Object)sequence2.getAccession().getDataSource()) + "=" + (Object)((Object)DataSource.DDBJ));
        header = "pir||entry";
        instance.parseHeader(header, (S)sequence2);
        System.out.println("entry=" + sequence2.getAccession());
        System.out.println((Object)((Object)sequence2.getAccession().getDataSource()) + "=" + (Object)((Object)DataSource.NBRF));
        header = "prf||name";
        instance.parseHeader(header, (S)sequence2);
        System.out.println("name=" + sequence2.getAccession());
        System.out.println((Object)((Object)sequence2.getAccession().getDataSource()) + "=" + (Object)((Object)DataSource.PRF));
        header = "sp|accession|name";
        instance.parseHeader(header, (S)sequence2);
        System.out.println("accession=" + sequence2.getAccession());
        System.out.println((Object)((Object)sequence2.getAccession().getDataSource()) + "=" + (Object)((Object)DataSource.UNIPROT));
        header = "pdb|entry|chain";
        instance.parseHeader(header, (S)sequence2);
        System.out.println("entry:chain=" + sequence2.getAccession());
        System.out.println((Object)((Object)sequence2.getAccession().getDataSource()) + "=" + (Object)((Object)DataSource.PDB1));
        header = "entry:chain|PDBID|CHAIN|SEQUENCE";
        instance.parseHeader(header, (S)sequence2);
        System.out.println("entry:chain=" + sequence2.getAccession());
        System.out.println((Object)((Object)sequence2.getAccession().getDataSource()) + "=" + (Object)((Object)DataSource.PDB2));
        header = "PDB:1ECY_A mol:protein length:142  ECOTIN";
        instance.parseHeader(header, (S)sequence2);
        System.out.println("1ECY_A=" + sequence2.getAccession());
        System.out.println((Object)((Object)sequence2.getAccession().getDataSource()) + "=" + (Object)((Object)DataSource.PDBe));
        header = "pat|country|number";
        instance.parseHeader(header, (S)sequence2);
        System.out.println("number=" + sequence2.getAccession());
        System.out.println((Object)((Object)sequence2.getAccession().getDataSource()) + "=" + (Object)((Object)DataSource.PATENTS));
        header = "bbs|number";
        instance.parseHeader(header, (S)sequence2);
        System.out.println("number=" + sequence2.getAccession());
        System.out.println((Object)((Object)sequence2.getAccession().getDataSource()) + "=" + (Object)((Object)DataSource.GENINFO));
        header = "gnl|database|identifier";
        instance.parseHeader(header, (S)sequence2);
        System.out.println("identifier=" + sequence2.getAccession());
        System.out.println((Object)((Object)sequence2.getAccession().getDataSource()) + "=" + (Object)((Object)DataSource.GENERAL));
        header = "ref|accession|locus";
        instance.parseHeader(header, (S)sequence2);
        System.out.println("accession=" + sequence2.getAccession());
        System.out.println((Object)((Object)sequence2.getAccession().getDataSource()) + "=" + (Object)((Object)DataSource.NCBI));
        header = "lcl|identifier";
        instance.parseHeader(header, (S)sequence2);
        System.out.println("identifier=" + sequence2.getAccession());
        System.out.println((Object)((Object)sequence2.getAccession().getDataSource()) + "=" + (Object)((Object)DataSource.LOCAL));
    }
}

