/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.scop;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.biojava.bio.structure.align.util.UserConfiguration;
import org.biojava.bio.structure.scop.ScopCategory;
import org.biojava.bio.structure.scop.ScopDatabase;
import org.biojava.bio.structure.scop.ScopDescription;
import org.biojava.bio.structure.scop.ScopDomain;
import org.biojava.bio.structure.scop.ScopNode;
import org.biojava3.core.util.InputStreamProvider;

public class ScopInstallation
implements ScopDatabase {
    public static final String DEFAULT_VERSION = "1.75";
    protected String scopVersion;
    public static final String claFileName = "dir.cla.scop.txt_";
    public static final String desFileName = "dir.des.scop.txt_";
    public static final String hieFileName = "dir.hie.scop.txt_";
    public static final String comFileName = "dir.com.scop.txt_";
    public static final String SCOP_DOWNLOAD = "http://scop.mrc-lmb.cam.ac.uk/scop/parse/";
    protected String scopDownloadURL;
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final String FILESPLIT = System.getProperty("file.separator");
    String cacheLocation;
    AtomicBoolean installedCla;
    AtomicBoolean installedDes;
    AtomicBoolean installedHie;
    AtomicBoolean installedCom;
    Map<Integer, List<String>> commentsMap;
    Map<String, List<ScopDomain>> domainMap;
    Map<Integer, ScopDescription> sunidMap;
    Map<Integer, ScopNode> scopTree;

    public ScopInstallation(String cacheLocation) {
        this.setCacheLocation(cacheLocation);
        this.installedCla = new AtomicBoolean();
        this.installedCla.set(false);
        this.installedDes = new AtomicBoolean();
        this.installedDes.set(false);
        this.installedHie = new AtomicBoolean();
        this.installedHie.set(false);
        this.installedCom = new AtomicBoolean();
        this.installedCom.set(false);
        this.scopVersion = DEFAULT_VERSION;
        this.scopDownloadURL = SCOP_DOWNLOAD;
        this.domainMap = new HashMap<String, List<ScopDomain>>();
        this.sunidMap = new HashMap<Integer, ScopDescription>();
        this.scopTree = new TreeMap<Integer, ScopNode>();
    }

    public void nullifyComments() {
        this.commentsMap = null;
    }

    public ScopInstallation() {
        this(new UserConfiguration().getCacheFilePath());
    }

    public void ensureClaInstalled() {
        if (this.installedCla.get()) {
            return;
        }
        if (!this.claFileAvailable()) {
            try {
                this.downloadClaFile();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.installedCla.set(false);
                return;
            }
        }
        try {
            this.parseClassification();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.installedCla.set(false);
            return;
        }
        this.installedCla.set(true);
    }

    public void ensureDesInstalled() {
        if (this.installedDes.get()) {
            return;
        }
        if (!this.desFileAvailable()) {
            try {
                this.downloadDesFile();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.installedDes.set(false);
                return;
            }
        }
        try {
            this.parseDescriptions();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.installedDes.set(false);
            return;
        }
        this.installedDes.set(true);
    }

    public void ensureComInstalled() {
        if (this.installedCom.get()) {
            return;
        }
        if (!this.comFileAvailable()) {
            try {
                this.downloadComFile();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.installedCom.set(false);
                return;
            }
        }
        try {
            this.parseComments();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.installedCom.set(false);
            return;
        }
        this.installedCom.set(true);
    }

    public void ensureHieInstalled() {
        if (this.installedHie.get()) {
            return;
        }
        if (!this.hieFileAvailable()) {
            try {
                this.downloadHieFile();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.installedHie.set(false);
                return;
            }
        }
        try {
            this.parseHierarchy();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.installedHie.set(false);
            return;
        }
        this.installedHie.set(true);
    }

    @Override
    public List<ScopDescription> getByCategory(ScopCategory category) {
        this.ensureDesInstalled();
        ArrayList<ScopDescription> matches2 = new ArrayList<ScopDescription>();
        for (Integer i : this.sunidMap.keySet()) {
            ScopDescription sc = this.sunidMap.get(i);
            if (!sc.getCategory().equals(category)) continue;
            try {
                matches2.add((ScopDescription)sc.clone());
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        return matches2;
    }

    @Override
    public List<ScopDescription> filterByClassificationId(String query) {
        this.ensureDesInstalled();
        ArrayList<ScopDescription> matches2 = new ArrayList<ScopDescription>();
        for (Integer i : this.sunidMap.keySet()) {
            ScopDescription sc = this.sunidMap.get(i);
            if (!sc.getClassificationId().startsWith(query)) continue;
            matches2.add(sc);
        }
        return matches2;
    }

    @Override
    public List<ScopNode> getTree(ScopDomain domain) {
        ScopNode node = this.getScopNode(domain.getSunid());
        ArrayList<ScopNode> tree = new ArrayList<ScopNode>();
        while (node != null) {
            if ((node = this.getScopNode(node.getParentSunid())) == null) continue;
            tree.add(node);
        }
        Collections.reverse(tree);
        return tree;
    }

    @Override
    public List<ScopDomain> filterByDomainName(String query) {
        ArrayList<ScopDomain> domains = new ArrayList<ScopDomain>();
        if (query.length() < 5) {
            return domains;
        }
        String pdbId = query.substring(1, 5);
        List<ScopDomain> doms = this.getDomainsForPDB(pdbId);
        if (doms == null) {
            return domains;
        }
        query = query.toLowerCase();
        for (ScopDomain d : doms) {
            if (!d.getScopId().toLowerCase().contains(query)) continue;
            domains.add(d);
        }
        return domains;
    }

    @Override
    public List<ScopDescription> filterByDescription(String query) {
        this.ensureDesInstalled();
        query = query.toLowerCase();
        ArrayList<ScopDescription> matches2 = new ArrayList<ScopDescription>();
        for (Integer i : this.sunidMap.keySet()) {
            ScopDescription sc = this.sunidMap.get(i);
            if (!sc.getDescription().toLowerCase().startsWith(query)) continue;
            matches2.add(sc);
        }
        return matches2;
    }

    @Override
    public ScopDescription getScopDescriptionBySunid(int sunid) {
        this.ensureDesInstalled();
        return this.sunidMap.get(sunid);
    }

    @Override
    public List<ScopDomain> getDomainsForPDB(String pdbId) {
        this.ensureClaInstalled();
        List<ScopDomain> doms = this.domainMap.get(pdbId.toLowerCase());
        ArrayList<ScopDomain> retdoms = new ArrayList<ScopDomain>();
        if (doms == null) {
            return retdoms;
        }
        for (ScopDomain d : doms) {
            try {
                ScopDomain n = (ScopDomain)d.clone();
                retdoms.add(n);
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        return retdoms;
    }

    @Override
    public ScopDomain getDomainByScopID(String scopId) {
        this.ensureClaInstalled();
        if (scopId.length() < 6) {
            throw new IllegalArgumentException("Does not look like a scop ID! " + scopId);
        }
        String pdbId = scopId.substring(1, 5);
        List<ScopDomain> doms = this.getDomainsForPDB(pdbId);
        if (doms == null) {
            return null;
        }
        for (ScopDomain d : doms) {
            if (!d.getScopId().equalsIgnoreCase(scopId)) continue;
            return d;
        }
        return null;
    }

    @Override
    public ScopNode getScopNode(int sunid) {
        this.ensureHieInstalled();
        ScopNode node = this.scopTree.get(sunid);
        return node;
    }

    private void parseClassification() throws IOException {
        File file = new File(this.getClaFilename());
        InputStreamProvider ips = new InputStreamProvider();
        BufferedReader buffer = new BufferedReader(new InputStreamReader(ips.getInputStream(file)));
        this.parseClassification(buffer);
    }

    private void parseHierarchy() throws IOException {
        File file = new File(this.getHieFilename());
        InputStreamProvider ips = new InputStreamProvider();
        BufferedReader buffer = new BufferedReader(new InputStreamReader(ips.getInputStream(file)));
        this.parseHierarchy(buffer);
    }

    private void parseHierarchy(BufferedReader buffer) throws IOException {
        String line = null;
        int counter = 0;
        while ((line = buffer.readLine()) != null) {
            if (line.startsWith("#")) continue;
            String[] spl = line.split("\t");
            if (spl.length != 3) {
                System.err.println("parseHierarchy: Can't parse line " + line + " (length: " + spl.length + ")");
                continue;
            }
            ++counter;
            int sunid = Integer.parseInt(spl[0]);
            int parentSunid = -1;
            if (sunid != 0) {
                parentSunid = Integer.parseInt(spl[1]);
            }
            String children2 = spl[2];
            String[] childIds = children2.split(",");
            ArrayList<Integer> chis = new ArrayList<Integer>();
            for (String id : childIds) {
                if (id.equals("-")) continue;
                chis.add(Integer.parseInt(id));
            }
            ScopNode node = new ScopNode();
            node.setSunid(sunid);
            node.setParentSunid(parentSunid);
            node.setChildren(chis);
            this.scopTree.put(sunid, node);
        }
        System.out.println("parsed " + counter + " scop sunid nodes.");
    }

    private void parseDescriptions() throws IOException {
        File file = new File(this.getDesFilename());
        InputStreamProvider ips = new InputStreamProvider();
        BufferedReader buffer = new BufferedReader(new InputStreamReader(ips.getInputStream(file)));
        this.parseDescriptions(buffer);
    }

    private void parseComments() throws IOException {
        File file = new File(this.getComFilename());
        InputStreamProvider ips = new InputStreamProvider();
        BufferedReader buffer = new BufferedReader(new InputStreamReader(ips.getInputStream(file)));
        this.parseComments(buffer);
    }

    private void parseComments(BufferedReader buffer) throws IOException {
        this.commentsMap = new HashMap<Integer, List<String>>();
        String line = null;
        while ((line = buffer.readLine()) != null) {
            if (line.startsWith("#")) continue;
            String[] parts = line.split(" ! ");
            int sunId = -1;
            try {
                sunId = Integer.parseInt(parts[0]);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                continue;
            }
            if (parts.length == 1) {
                this.commentsMap.put(sunId, new ArrayList(1));
                continue;
            }
            ArrayList<String> comments = new ArrayList<String>(parts.length - 1);
            for (int i = 1; i < parts.length; ++i) {
                comments.add(parts[i]);
            }
            this.commentsMap.put(sunId, comments);
        }
    }

    private void parseDescriptions(BufferedReader buffer) throws IOException {
        String line = null;
        int counter = 0;
        while ((line = buffer.readLine()) != null) {
            if (line.startsWith("#")) continue;
            String[] spl = line.split("\t");
            if (spl.length != 5) {
                System.err.println("parseDescriptions: Can't parse line " + line + " (length: " + spl.length + ")");
                continue;
            }
            ++counter;
            int sunID = Integer.parseInt(spl[0]);
            ScopCategory category = ScopCategory.fromString(spl[1]);
            String classificationId = spl[2];
            String name = spl[3];
            String desc = spl[4];
            ScopDescription c = new ScopDescription();
            c.setSunID(sunID);
            c.setCategory(category);
            c.setClassificationId(classificationId);
            c.setName(name);
            c.setDescription(desc);
            this.sunidMap.put(new Integer(sunID), c);
        }
        System.out.println("parsed " + counter + " scop sunid descriptions.");
    }

    private void parseClassification(BufferedReader buffer) throws IOException {
        String line = null;
        int counter = 0;
        while ((line = buffer.readLine()) != null) {
            List<Object> domainList;
            if (line.startsWith("#")) continue;
            String[] spl = line.split("\t");
            if (spl.length != 6) {
                System.err.println("Can't parse line " + line);
                continue;
            }
            ++counter;
            String scopId = spl[0];
            String pdbId = spl[1];
            String range2 = spl[2];
            String classificationId = spl[3];
            Integer sunid = Integer.parseInt(spl[4]);
            String tree = spl[5];
            ScopDomain d = new ScopDomain();
            d.setScopId(scopId);
            d.setPdbId(pdbId);
            d.setRanges(this.extractRanges(range2));
            d.setClassificationId(classificationId);
            d.setSunid(sunid);
            String[] treeSplit = tree.split(",");
            if (treeSplit.length != 7) {
                System.err.println("can't process: " + line);
            }
            int classId = Integer.parseInt(treeSplit[0].substring(3));
            int foldId = Integer.parseInt(treeSplit[1].substring(3));
            int superfamilyId = Integer.parseInt(treeSplit[2].substring(3));
            int familyId = Integer.parseInt(treeSplit[3].substring(3));
            int domainId = Integer.parseInt(treeSplit[4].substring(3));
            int speciesId = Integer.parseInt(treeSplit[5].substring(3));
            int px = Integer.parseInt(treeSplit[6].substring(3));
            d.setClassId(classId);
            d.setFoldId(foldId);
            d.setSuperfamilyId(superfamilyId);
            d.setFamilyId(familyId);
            d.setDomainId(domainId);
            d.setSpeciesId(speciesId);
            d.setPx(px);
            if (this.domainMap.containsKey(pdbId)) {
                domainList = this.domainMap.get(pdbId);
            } else {
                domainList = new ArrayList();
                this.domainMap.put(pdbId, domainList);
            }
            domainList.add(d);
        }
        System.out.println("parsed " + counter + " scop sunid domains.");
    }

    private List<String> extractRanges(String range2) {
        String[] rangeSpl = range2.split(",");
        if (this.scopVersion.compareTo("1.73") < 0) {
            for (int i = 0; i < rangeSpl.length; ++i) {
                String subRange = rangeSpl[i];
                if (subRange.length() < 2 || subRange.charAt(1) == ':') continue;
                rangeSpl[i] = "_:" + subRange;
            }
        }
        List<String> ranges = Arrays.asList(rangeSpl);
        return ranges;
    }

    protected void downloadClaFile() throws FileNotFoundException, IOException {
        String remoteFilename = claFileName + this.scopVersion;
        URL url = new URL(this.scopDownloadURL + remoteFilename);
        String localFileName = this.getClaFilename();
        File localFile = new File(localFileName);
        this.downloadFileFromRemote(url, localFile);
    }

    protected void downloadDesFile() throws FileNotFoundException, IOException {
        String remoteFilename = desFileName + this.scopVersion;
        URL url = new URL(this.scopDownloadURL + remoteFilename);
        String localFileName = this.getDesFilename();
        File localFile = new File(localFileName);
        this.downloadFileFromRemote(url, localFile);
    }

    protected void downloadHieFile() throws FileNotFoundException, IOException {
        String remoteFilename = hieFileName + this.scopVersion;
        URL url = new URL(this.scopDownloadURL + remoteFilename);
        String localFileName = this.getHieFilename();
        File localFile = new File(localFileName);
        this.downloadFileFromRemote(url, localFile);
    }

    protected void downloadComFile() throws FileNotFoundException, IOException {
        String remoteFilename = comFileName + this.scopVersion;
        URL url = new URL(this.scopDownloadURL + remoteFilename);
        String localFileName = this.getComFilename();
        File localFile = new File(localFileName);
        this.downloadFileFromRemote(url, localFile);
    }

    protected void downloadFileFromRemote(URL remoteURL, File localFile) throws FileNotFoundException, IOException {
        int bytesRead;
        System.out.println("downloading " + remoteURL + " to: " + localFile);
        FileOutputStream out = new FileOutputStream(localFile);
        InputStream in = remoteURL.openStream();
        byte[] buf = new byte[4096];
        while ((bytesRead = in.read(buf)) != -1) {
            out.write(buf, 0, bytesRead);
        }
        in.close();
        out.close();
    }

    private boolean claFileAvailable() {
        String fileName = this.getClaFilename();
        File f2 = new File(fileName);
        return f2.exists();
    }

    private boolean desFileAvailable() {
        String fileName = this.getDesFilename();
        File f2 = new File(fileName);
        return f2.exists();
    }

    private boolean hieFileAvailable() {
        String fileName = this.getHieFilename();
        File f2 = new File(fileName);
        return f2.exists();
    }

    private boolean comFileAvailable() {
        String fileName = this.getComFilename();
        File f2 = new File(fileName);
        return f2.exists();
    }

    protected String getClaFilename() {
        String f2 = this.cacheLocation + claFileName + this.scopVersion;
        return f2;
    }

    protected String getDesFilename() {
        String f2 = this.cacheLocation + desFileName + this.scopVersion;
        return f2;
    }

    protected String getHieFilename() {
        String f2 = this.cacheLocation + hieFileName + this.scopVersion;
        return f2;
    }

    protected String getComFilename() {
        String f2 = this.cacheLocation + comFileName + this.scopVersion;
        return f2;
    }

    public String getCacheLocation() {
        return this.cacheLocation;
    }

    public void setCacheLocation(String cacheLocation) {
        if (!cacheLocation.endsWith(FILESPLIT)) {
            cacheLocation = cacheLocation + FILESPLIT;
        }
        this.cacheLocation = cacheLocation;
    }

    @Override
    public String getScopVersion() {
        return this.scopVersion;
    }

    public void setScopVersion(String scopVersion) {
        this.scopVersion = scopVersion;
    }

    public String getScopDownloadURL() {
        return this.scopDownloadURL;
    }

    public void setScopDownloadURL(String scopDownloadURL) {
        this.scopDownloadURL = scopDownloadURL;
    }

    @Override
    public List<ScopDomain> getScopDomainsBySunid(Integer sunid) {
        this.ensureClaInstalled();
        ArrayList<ScopDomain> domains = new ArrayList<ScopDomain>();
        for (String pdbId : this.domainMap.keySet()) {
            for (ScopDomain d : this.domainMap.get(pdbId)) {
                try {
                    if (d.getPx() == sunid.intValue()) {
                        domains.add((ScopDomain)d.clone());
                        continue;
                    }
                    if (d.getSpeciesId() == sunid.intValue()) {
                        domains.add((ScopDomain)d.clone());
                        continue;
                    }
                    if (d.getDomainId() == sunid.intValue()) {
                        domains.add((ScopDomain)d.clone());
                        continue;
                    }
                    if (d.getFamilyId() == sunid.intValue()) {
                        domains.add((ScopDomain)d.clone());
                        continue;
                    }
                    if (d.getSuperfamilyId() == sunid.intValue()) {
                        domains.add((ScopDomain)d.clone());
                        continue;
                    }
                    if (d.getFoldId() == sunid.intValue()) {
                        domains.add((ScopDomain)d.clone());
                        continue;
                    }
                    if (d.getClassId() != sunid.intValue()) continue;
                    domains.add((ScopDomain)d.clone());
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
            }
        }
        return domains;
    }

    @Override
    public List<String> getComments(int sunid) {
        this.ensureComInstalled();
        if (!this.commentsMap.containsKey(sunid)) {
            return new ArrayList<String>(1);
        }
        return this.commentsMap.get(sunid);
    }
}

