/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.io.sifts;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.biojava.bio.structure.align.util.AtomCache;
import org.biojava.bio.structure.io.sifts.SiftsEntity;
import org.biojava.bio.structure.io.sifts.SiftsResidue;
import org.biojava.bio.structure.io.sifts.SiftsSegment;
import org.biojava.bio.structure.io.sifts.SiftsXMLParser;
import org.biojava.bio.structure.io.util.FileDownloadUtils;
import org.biojava3.core.util.InputStreamProvider;

public class SiftsMappingProvider {
    static String EBI_SIFTS_FILE_LOCATION = "ftp://ftp.ebi.ac.uk/pub/databases/msd/sifts/xml/%s.xml.gz";
    static String RCSB_SIFTS_FILE_LOCATION = "http://www.rcsb.org/pdb/files/%s.sifts.xml.gz";
    static String fileLoc = EBI_SIFTS_FILE_LOCATION;

    public static void main(String[] args) {
        try {
            List<SiftsEntity> entities = SiftsMappingProvider.getSiftsMapping("1gc1");
            for (SiftsEntity e : entities) {
                System.out.println(e.getEntityId() + " " + e.getType());
                for (SiftsSegment seg : e.getSegments()) {
                    System.out.println(" Segment: " + seg.getSegId() + " " + seg.getStart() + " " + seg.getEnd());
                    for (SiftsResidue res : seg.getResidues()) {
                        System.out.println("  " + res);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setFileLocation(String myFileLocation) {
        fileLoc = myFileLocation;
    }

    public static List<SiftsEntity> getSiftsMapping(String pdbId) throws IOException {
        File dest;
        File hashDir;
        AtomCache cache = new AtomCache();
        String path = cache.getPath();
        pdbId = pdbId.toLowerCase();
        String dirHash = pdbId.substring(1, 3);
        String SIFTS_DIR = path + "/SIFTS/";
        File siftsDir = new File(SIFTS_DIR);
        if (!siftsDir.exists()) {
            siftsDir.mkdir();
        }
        if (!(hashDir = new File(SIFTS_DIR + dirHash)).exists()) {
            hashDir.mkdir();
        }
        if (!(dest = new File(hashDir.getAbsolutePath() + "/" + pdbId + ".sifts.xml.gz")).exists()) {
            String u = String.format(fileLoc, pdbId);
            URL url = new URL(u);
            FileDownloadUtils.downloadGzipCompressedFile(url, dest);
        }
        InputStreamProvider prov = new InputStreamProvider();
        InputStream is = prov.getInputStream(dest);
        SiftsXMLParser parser = new SiftsXMLParser();
        parser.parseXmlFile(is);
        return parser.getEntities();
    }
}

