/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.io.mmcif;

import java.util.List;
import org.biojava.bio.structure.io.FileParsingParameters;
import org.biojava.bio.structure.io.mmcif.ChemicalComponentDictionary;
import org.biojava.bio.structure.io.mmcif.MMcifConsumer;
import org.biojava.bio.structure.io.mmcif.chem.ResidueType;
import org.biojava.bio.structure.io.mmcif.model.AtomSite;
import org.biojava.bio.structure.io.mmcif.model.AuditAuthor;
import org.biojava.bio.structure.io.mmcif.model.ChemComp;
import org.biojava.bio.structure.io.mmcif.model.ChemCompAtom;
import org.biojava.bio.structure.io.mmcif.model.ChemCompBond;
import org.biojava.bio.structure.io.mmcif.model.ChemCompDescriptor;
import org.biojava.bio.structure.io.mmcif.model.DatabasePDBremark;
import org.biojava.bio.structure.io.mmcif.model.DatabasePDBrev;
import org.biojava.bio.structure.io.mmcif.model.Entity;
import org.biojava.bio.structure.io.mmcif.model.EntityPolySeq;
import org.biojava.bio.structure.io.mmcif.model.EntitySrcGen;
import org.biojava.bio.structure.io.mmcif.model.EntitySrcNat;
import org.biojava.bio.structure.io.mmcif.model.EntitySrcSyn;
import org.biojava.bio.structure.io.mmcif.model.Exptl;
import org.biojava.bio.structure.io.mmcif.model.PdbxChemCompDescriptor;
import org.biojava.bio.structure.io.mmcif.model.PdbxChemCompIdentifier;
import org.biojava.bio.structure.io.mmcif.model.PdbxEntityNonPoly;
import org.biojava.bio.structure.io.mmcif.model.PdbxNonPolyScheme;
import org.biojava.bio.structure.io.mmcif.model.PdbxPolySeqScheme;
import org.biojava.bio.structure.io.mmcif.model.PdbxStructAssembly;
import org.biojava.bio.structure.io.mmcif.model.PdbxStructAssemblyGen;
import org.biojava.bio.structure.io.mmcif.model.PdbxStructOperList;
import org.biojava.bio.structure.io.mmcif.model.Refine;
import org.biojava.bio.structure.io.mmcif.model.Struct;
import org.biojava.bio.structure.io.mmcif.model.StructAsym;
import org.biojava.bio.structure.io.mmcif.model.StructKeywords;
import org.biojava.bio.structure.io.mmcif.model.StructRef;
import org.biojava.bio.structure.io.mmcif.model.StructRefSeq;

public class ChemCompConsumer
implements MMcifConsumer {
    ChemicalComponentDictionary dictionary = new ChemicalComponentDictionary();
    String latestChemCompId;

    @Override
    public void documentStart() {
    }

    public ChemicalComponentDictionary getDictionary() {
        return this.dictionary;
    }

    @Override
    public void newChemComp(ChemComp c) {
        this.latestChemCompId = c.getId();
        this.dictionary.addChemComp(c);
        if (c.getResidueType() == ResidueType.nonPolymer) {
            return;
        }
        if (c.getResidueType() == ResidueType.saccharide) {
            return;
        }
        if (c.getResidueType() == ResidueType.dSaccharide) {
            return;
        }
    }

    @Override
    public void documentEnd() {
    }

    @Override
    public void newAtomSite(AtomSite atom) {
    }

    @Override
    public void newDatabasePDBremark(DatabasePDBremark remark) {
    }

    @Override
    public void newDatabasePDBrev(DatabasePDBrev dbrev) {
    }

    @Override
    public void newEntity(Entity entity) {
    }

    @Override
    public void newEntityPolySeq(EntityPolySeq epolseq) {
    }

    @Override
    public void newExptl(Exptl exptl) {
    }

    @Override
    public void newPdbxEntityNonPoly(PdbxEntityNonPoly pen) {
    }

    @Override
    public void newPdbxNonPolyScheme(PdbxNonPolyScheme ppss) {
    }

    @Override
    public void newPdbxPolySeqScheme(PdbxPolySeqScheme ppss) {
    }

    @Override
    public void newRefine(Refine r) {
    }

    @Override
    public void newStructAsym(StructAsym sasym) {
    }

    @Override
    public void newStructKeywords(StructKeywords kw) {
    }

    @Override
    public void newStructRef(StructRef sref) {
    }

    @Override
    public void newStructRefSeq(StructRefSeq sref) {
    }

    @Override
    public void setStruct(Struct struct) {
    }

    @Override
    public void newGenericData(String category, List<String> loopFields, List<String> lineData) {
    }

    @Override
    public void newAuditAuthor(AuditAuthor aa) {
    }

    @Override
    public FileParsingParameters getFileParsingParameters() {
        return null;
    }

    @Override
    public void setFileParsingParameters(FileParsingParameters params) {
    }

    @Override
    public void newChemCompDescriptor(ChemCompDescriptor ccd) {
        ChemComp cc = this.dictionary.getChemComp(this.latestChemCompId);
        cc.getDescriptors().add(ccd);
    }

    @Override
    public void newPdbxStructOperList(PdbxStructOperList structOper) {
    }

    @Override
    public void newPdbxStrucAssembly(PdbxStructAssembly strucAssembly) {
    }

    @Override
    public void newPdbxStrucAssemblyGen(PdbxStructAssemblyGen strucAssembly) {
    }

    @Override
    public void newChemCompAtom(ChemCompAtom atom) {
        this.dictionary.getChemComp(this.latestChemCompId).getAtoms().add(atom);
    }

    @Override
    public void newPdbxChemCompIndentifier(PdbxChemCompIdentifier id) {
    }

    @Override
    public void newChemCompBond(ChemCompBond bond) {
        this.dictionary.getChemComp(this.latestChemCompId).getBonds().add(bond);
    }

    @Override
    public void newPdbxChemCompDescriptor(PdbxChemCompDescriptor desc) {
    }

    @Override
    public void newEntitySrcGen(EntitySrcGen entitySrcGen) {
    }

    @Override
    public void newEntitySrcNat(EntitySrcNat entitySrcNat) {
    }

    @Override
    public void newEntitySrcSyn(EntitySrcSyn entitySrcSyn) {
    }
}

