/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.io.FileParsingParameters;
import org.biojava.bio.structure.io.PDBFileReader;
import org.biojava.bio.structure.io.StructureProvider;

public class LocalCacheStructureProvider
implements StructureProvider {
    FileParsingParameters params = new FileParsingParameters();
    String path;
    public static final String lineSplit = System.getProperty("file.separator");
    private static final boolean isSplit = true;
    private static final String BIOL_DIR = "BIOL_UNITS";

    public LocalCacheStructureProvider() {
        String defaultPath = System.getProperty("PDB_DIR");
        if (defaultPath == null) {
            String property = "java.io.tmpdir";
            defaultPath = System.getProperty(property);
        }
        this.setPath(defaultPath);
    }

    public void setPath(String p) {
        System.setProperty("PDB_DIR", p);
        this.path = p;
        if (!this.path.endsWith(lineSplit)) {
            this.path = this.path + lineSplit;
        }
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public Structure getStructureById(String pdbId) throws IOException {
        PDBFileReader reader = this.getPdbFilereader();
        return reader.getStructureById(pdbId);
    }

    private PDBFileReader getPdbFilereader() {
        PDBFileReader reader = new PDBFileReader();
        reader.setPath(this.path);
        reader.setAutoFetch(true);
        reader.setFileParsingParameters(this.params);
        reader.setPdbDirectorySplit(true);
        return reader;
    }

    @Override
    public Structure getBiologicalUnit(String pdbId) throws StructureException, IOException {
        File tempFile;
        File directoryCheck;
        if (pdbId == null || pdbId.length() < 4) {
            throw new StructureException("This does not look like a valid PDB ID! (" + pdbId + ")");
        }
        String middle = pdbId.substring(1, 3).toLowerCase();
        String dir = this.path + BIOL_DIR;
        File tmp1 = new File(dir);
        if (!tmp1.exists()) {
            tmp1.mkdir();
        }
        if (!(directoryCheck = new File(dir = dir + lineSplit + middle)).exists()) {
            directoryCheck.mkdir();
        }
        if (!(tempFile = new File(dir + lineSplit + "pdb" + pdbId.toLowerCase() + ".ent.gz")).exists()) {
            this.downloadBiolUnit(pdbId.toLowerCase(), tempFile);
        }
        PDBFileReader reader = this.getPdbFilereader();
        return reader.getStructure(tempFile);
    }

    private void downloadBiolUnit(String pdbId, File localFile) throws IOException {
        String u = "http://www.rcsb.org/pdb/files/%s.pdb1.gz";
        String ur = String.format(u, pdbId);
        System.out.println("Fetching " + ur);
        System.out.println("writing to " + localFile);
        try {
            String line;
            URL url = new URL(ur);
            InputStream uStream = url.openStream();
            GZIPInputStream conn = new GZIPInputStream(uStream);
            FileOutputStream outPut = new FileOutputStream(localFile);
            GZIPOutputStream gzOutPut = new GZIPOutputStream(outPut);
            PrintWriter pw = new PrintWriter(gzOutPut);
            BufferedReader fileBuffer = new BufferedReader(new InputStreamReader(conn));
            while ((line = fileBuffer.readLine()) != null) {
                pw.println(line);
            }
            pw.flush();
            pw.close();
            outPut.flush();
            outPut.close();
            ((InputStream)conn).close();
            uStream.close();
        }
        catch (Exception e) {
            System.err.println("Problem while downloading PDB ID " + pdbId + " from " + ur);
            throw new IOException("Could not download biol. unit for PDB ID " + pdbId);
        }
    }

    @Override
    public void setFileParsingParameters(FileParsingParameters params) {
        this.params = params;
    }

    @Override
    public FileParsingParameters getFileParsingParameters() {
        return this.params;
    }
}

