/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.biojava.bio.structure.AminoAcid;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.GroupIterator;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.io.PDBFileParser;

public final class StandardAminoAcid {
    private static Map<String, AminoAcid> aminoAcids = new HashMap<String, AminoAcid>();

    private StandardAminoAcid() {
    }

    public static AminoAcid getAminoAcid(String name) {
        return aminoAcids.get(name);
    }

    static {
        try {
            InputStream fileStream = StandardAminoAcid.class.getClassLoader().getResourceAsStream("org/biojava/bio/structure/standardaminos.pdb");
            if (fileStream == null) {
                throw new Exception("Couldn't locate standardaminos.pdb.  This probably means that your biojava.jar file is corrupt or incorrectly built.");
            }
            PDBFileParser parser = new PDBFileParser();
            Structure s = parser.parsePDBFile(fileStream);
            GroupIterator iter2 = new GroupIterator(s);
            while (iter2.hasNext()) {
                Group g = iter2.next();
                if (!(g instanceof AminoAcid)) continue;
                AminoAcid aa = (AminoAcid)g;
                aminoAcids.put(aa.getPDBName(), aa);
                aminoAcids.put(aa.getAminoType().toString(), aa);
            }
        }
        catch (Exception t2) {
            throw new RuntimeException("Unable to initialize standard aminoacids", t2);
        }
    }
}

