/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.dom.NodeModel;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleCollection;
import freemarker.template.SimpleDate;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.lang.reflect.Array;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Node;

public class DefaultObjectWrapper
extends BeansWrapper {
    static final DefaultObjectWrapper instance = new DefaultObjectWrapper();
    private static Class W3C_DOM_NODE_CLASS;
    private static Class JYTHON_OBJ_CLASS;
    private static ObjectWrapper JYTHON_WRAPPER;

    public TemplateModel wrap(Object obj) throws TemplateModelException {
        if (obj == null) {
            return super.wrap(null);
        }
        if (obj instanceof TemplateModel) {
            return (TemplateModel)obj;
        }
        if (obj instanceof String) {
            return new SimpleScalar((String)obj);
        }
        if (obj instanceof Number) {
            return new SimpleNumber((Number)obj);
        }
        if (obj instanceof java.util.Date) {
            if (obj instanceof Date) {
                return new SimpleDate((Date)obj);
            }
            if (obj instanceof Time) {
                return new SimpleDate((Time)obj);
            }
            if (obj instanceof Timestamp) {
                return new SimpleDate((Timestamp)obj);
            }
            return new SimpleDate((java.util.Date)obj, this.getDefaultDateType());
        }
        if (obj.getClass().isArray()) {
            obj = this.convertArray(obj);
        }
        if (obj instanceof Collection) {
            return new SimpleSequence((Collection)obj, this);
        }
        if (obj instanceof Map) {
            return new SimpleHash((Map)obj, this);
        }
        if (obj instanceof Boolean) {
            return obj.equals(Boolean.TRUE) ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
        if (obj instanceof Iterator) {
            return new SimpleCollection((Iterator)obj, (ObjectWrapper)this);
        }
        return this.handleUnknownType(obj);
    }

    protected TemplateModel handleUnknownType(Object obj) throws TemplateModelException {
        if (W3C_DOM_NODE_CLASS != null && W3C_DOM_NODE_CLASS.isInstance(obj)) {
            return this.wrapDomNode(obj);
        }
        if (JYTHON_WRAPPER != null && JYTHON_OBJ_CLASS.isInstance(obj)) {
            return JYTHON_WRAPPER.wrap(obj);
        }
        return super.wrap(obj);
    }

    public TemplateModel wrapDomNode(Object obj) {
        return NodeModel.wrap((Node)obj);
    }

    protected Object convertArray(Object arr) {
        int size2 = Array.getLength(arr);
        ArrayList<Object> list2 = new ArrayList<Object>(size2);
        for (int i = 0; i < size2; ++i) {
            list2.add(Array.get(arr, i));
        }
        return list2;
    }

    static {
        try {
            W3C_DOM_NODE_CLASS = Class.forName("org.w3c.dom.Node");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            JYTHON_OBJ_CLASS = Class.forName("org.python.core.PyObject");
            JYTHON_WRAPPER = (ObjectWrapper)Class.forName("freemarker.ext.jython.JythonWrapper").getField("INSTANCE").get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

