/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.StringLiteral;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.Collections12;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

final class ListLiteral
extends Expression {
    final ArrayList values;

    ListLiteral(ArrayList values2) {
        this.values = values2;
        values2.trimToSize();
    }

    TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
        SimpleSequence list2 = new SimpleSequence(this.values.size());
        Iterator it = this.values.iterator();
        while (it.hasNext()) {
            Expression exp = (Expression)it.next();
            TemplateModel tm = exp.getAsTemplateModel(env);
            ListLiteral.assertNonNull(tm, exp, env);
            list2.add(tm);
        }
        return list2;
    }

    List getValueList(Environment env) throws TemplateException {
        int size2 = this.values.size();
        switch (size2) {
            case 0: {
                return Collections.EMPTY_LIST;
            }
            case 1: {
                return Collections12.singletonList(((Expression)this.values.get(0)).getStringValue(env));
            }
        }
        ArrayList<String> result2 = new ArrayList<String>(this.values.size());
        ListIterator iterator2 = this.values.listIterator();
        while (iterator2.hasNext()) {
            Expression exp = (Expression)iterator2.next();
            result2.add(exp.getStringValue(env));
        }
        return result2;
    }

    List getModelList(Environment env) throws TemplateException {
        int size2 = this.values.size();
        switch (size2) {
            case 0: {
                return Collections.EMPTY_LIST;
            }
            case 1: {
                return Collections12.singletonList(((Expression)this.values.get(0)).getAsTemplateModel(env));
            }
        }
        ArrayList<TemplateModel> result2 = new ArrayList<TemplateModel>(this.values.size());
        ListIterator iterator2 = this.values.listIterator();
        while (iterator2.hasNext()) {
            Expression exp = (Expression)iterator2.next();
            result2.add(exp.getAsTemplateModel(env));
        }
        return result2;
    }

    public String getCanonicalForm() {
        StringBuffer buf = new StringBuffer("[");
        int size2 = this.values.size();
        for (int i = 0; i < size2; ++i) {
            Expression value2 = (Expression)this.values.get(i);
            buf.append(value2.getCanonicalForm());
            if (i == size2 - 1) continue;
            buf.append(",");
        }
        buf.append("]");
        return buf.toString();
    }

    boolean isLiteral() {
        if (this.constantValue != null) {
            return true;
        }
        for (int i = 0; i < this.values.size(); ++i) {
            Expression exp = (Expression)this.values.get(i);
            if (exp.isLiteral()) continue;
            return false;
        }
        return true;
    }

    TemplateSequenceModel evaluateStringsToNamespaces(Environment env) throws TemplateException {
        TemplateSequenceModel val = (TemplateSequenceModel)this.getAsTemplateModel(env);
        SimpleSequence result2 = new SimpleSequence(val.size());
        for (int i = 0; i < this.values.size(); ++i) {
            if (this.values.get(i) instanceof StringLiteral) {
                String s = ((StringLiteral)this.values.get(i)).getAsString();
                try {
                    Environment.Namespace ns = env.importLib(s, null);
                    result2.add(ns);
                    continue;
                }
                catch (IOException ioe) {
                    throw new TemplateException("Could not import library '" + s + "', " + ioe.getMessage(), env);
                }
            }
            result2.add(val.get(i));
        }
        return result2;
    }

    Expression _deepClone(String name, Expression subst) {
        ArrayList clonedValues = (ArrayList)this.values.clone();
        ListIterator<Expression> iter2 = clonedValues.listIterator();
        while (iter2.hasNext()) {
            iter2.set(((Expression)iter2.next()).deepClone(name, subst));
        }
        return new ListLiteral(clonedValues);
    }
}

