/*
 * Decompiled with CFR 0.152.
 */
package DistLib;

import DistLib.beta;
import DistLib.misc;
import DistLib.normal;

public class noncentral_t {
    public static double cumulative(double t2, double df, double delta) {
        double itrmax = 100.1;
        double errmax = 1.0E-12;
        double zero2 = 0.0;
        double half = 0.5;
        double one = 1.0;
        double two = 2.0;
        double tnc = 0.0;
        if (df <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        double tt = t2;
        double del = delta;
        boolean negdel = false;
        if (t2 < 0.0) {
            negdel = true;
            tt = -tt;
            del = -del;
        }
        double en = 1.0;
        double x2 = t2 * t2 / (t2 * t2 + df);
        if (x2 > 0.0) {
            double errbd;
            double lambda = del * del;
            double p = 0.5 * Math.exp(-0.5 * lambda);
            double q = 0.7978845608028654 * p * del;
            double s = 0.5 - p;
            double a = 0.5;
            double b = 0.5 * df;
            double rxb = Math.pow(1.0 - x2, b);
            double albeta = 0.5723649429247001 + misc.lgammafn(b) - misc.lgammafn(a + b);
            double xodd = beta.cumulative(x2, a, b);
            double godd = 2.0 * rxb * Math.exp(a * Math.log(x2) - albeta);
            double xeven = 1.0 - rxb;
            double geven = b * x2 * rxb;
            tnc = p * xodd + q * xeven;
            do {
                xodd -= godd;
                godd = godd * x2 * ((a += 1.0) + b - 1.0) / a;
                geven = geven * x2 * (a + b - 0.5) / (a + 0.5);
                p = p * lambda / (2.0 * en);
                q = q * lambda / (2.0 * en + 1.0);
                tnc = tnc + p * xodd + q * (xeven -= geven);
            } while ((errbd = 2.0 * (s -= p) * (xodd - godd)) > 1.0E-12 && (en += 1.0) <= 100.1);
        }
        if (en <= 100.1) {
            throw new ArithmeticException("Math Error: PRECISION");
        }
        tnc += normal.cumulative(-del, 0.0, 1.0);
        if (negdel) {
            tnc = 1.0 - tnc;
        }
        return tnc;
    }
}

