/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.testCases;

import java.io.File;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;
import org.snpeff.interval.Variant;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.VcfEntry;
import org.snpsift.annotate.VcfIndex;

public class TestCasesIndex
extends TestCase {
    public static boolean debug;
    public static boolean verbose;

    public void test_01() {
        Gpr.debug("Test");
        String dbFileName = "./test/db_test_index_01.vcf";
        String indexFileName = dbFileName + "." + "sidx";
        new File(indexFileName).delete();
        VcfIndex vcfIndex = new VcfIndex(dbFileName);
        vcfIndex.setVerbose(verbose);
        vcfIndex.open();
        vcfIndex.index();
        if (verbose) {
            Gpr.debug("Checking");
        }
        VcfFileIterator vcf = new VcfFileIterator(dbFileName);
        for (VcfEntry ve : vcf) {
            if (verbose) {
                System.out.println(ve.toStr());
            }
            for (Variant var : ve.variants()) {
                Markers results = vcfIndex.query(var);
                Assert.assertTrue("No results found for entry:\n\t" + ve, results.size() > 0);
                for (Marker res : results) {
                    VcfEntry veIdx = (VcfEntry)res;
                    if (verbose) {
                        System.out.println("\t" + res + "\t" + veIdx);
                    }
                    Assert.assertTrue("Selected interval does not intersect marker form file!\n\tVcfEntry            : " + ve + "\n\tVariant             : " + var + "\n\tResult              : " + res + "\n\tVcfEntry from result:" + veIdx, ve.intersects(veIdx));
                }
            }
        }
        vcfIndex.close();
    }

    public void test_02() {
        Gpr.debug("Test");
        String dbFileName = "./test/db_test_index_02.vcf";
        String indexFileName = dbFileName + "." + "sidx";
        new File(indexFileName).delete();
        VcfIndex vcfIndex = new VcfIndex(dbFileName);
        vcfIndex.setVerbose(verbose);
        vcfIndex.index();
        Assert.assertTrue("Index file '" + indexFileName + "' does not exist", Gpr.exists(indexFileName));
        vcfIndex = new VcfIndex(dbFileName);
        vcfIndex.setVerbose(verbose);
        vcfIndex.open();
        vcfIndex.index();
        if (verbose) {
            Gpr.debug("Checking");
        }
        VcfFileIterator vcf = new VcfFileIterator(dbFileName);
        for (VcfEntry ve : vcf) {
            if (verbose) {
                System.out.println(ve.toStr());
            }
            for (Variant var : ve.variants()) {
                Markers results = vcfIndex.query(var);
                Assert.assertTrue("No results found for entry:\n\t" + ve, results.size() > 0);
                for (Marker res : results) {
                    VcfEntry veIdx = (VcfEntry)res;
                    if (verbose) {
                        System.out.println("\t" + res + "\t" + veIdx);
                    }
                    Assert.assertTrue("Selected interval does not intersect marker form file!\n\tVcfEntry            : " + ve + "\n\tVariant             : " + var + "\n\tResult              : " + res + "\n\tVcfEntry from result:" + veIdx, ve.intersects(veIdx));
                }
            }
        }
        vcfIndex.close();
    }

    static {
        verbose = debug = false;
    }
}

