/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.lang.expression;

import org.snpeff.vcf.VcfInfoType;
import org.snpsift.lang.expression.Field;
import org.snpsift.lang.expression.FieldConstantFloat;

public class FieldConstant
extends Field {
    public static Field factory(String name) {
        if (!FieldConstant.isConstantField(name)) {
            throw new RuntimeException("Unknown constant name '" + name + "'");
        }
        FieldConstantNames fcn = FieldConstantNames.valueOf(name);
        switch (fcn) {
            case NaN: {
                return new FieldConstantFloat("NaN", Double.NaN);
            }
            case Inf: {
                return new FieldConstantFloat("Inf", Double.POSITIVE_INFINITY);
            }
        }
        throw new RuntimeException("Unknown constant name '" + (Object)((Object)fcn) + "'");
    }

    public static boolean isConstantField(String name) {
        for (FieldConstantNames fcn : FieldConstantNames.values()) {
            if (!name.equals(fcn.toString())) continue;
            return true;
        }
        return false;
    }

    public FieldConstant(String name) {
        super(name);
    }

    public static enum FieldConstantNames {
        NaN,
        Inf;


        public VcfInfoType getType() {
            return VcfInfoType.Float;
        }
    }
}

