/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift;

import java.util.List;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.util.Timer;
import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfGenotype;
import org.snpsift.SnpSift;

public class SnpSiftCmdRemoveReferenceGenotypes
extends SnpSift {
    public static final int SHOW_EVERY = 1000;
    public static final int SHOW_EVERY_NL = 100000;
    String vcfFileName;

    public SnpSiftCmdRemoveReferenceGenotypes() {
    }

    public SnpSiftCmdRemoveReferenceGenotypes(String[] args) {
        super(args);
    }

    @Override
    public void parseArgs(String[] args) {
        if (args.length <= 0) {
            this.vcfFileName = "-";
        } else if (args.length == 1) {
            this.vcfFileName = args[0];
        } else {
            this.usage("Too many arguments");
        }
    }

    @Override
    public boolean run() {
        Timer.showStdErr("Reading STDIN");
        VcfFileIterator vcfFile = new VcfFileIterator(this.vcfFileName);
        vcfFile.setDebug(this.debug);
        vcfFile.setCreateChromos(true);
        int entryNum = 1;
        for (VcfEntry vcfEntry : vcfFile) {
            String headerStr;
            VcfGenotype nogenotype = null;
            if (entryNum == 1 && !(headerStr = vcfFile.getVcfHeader().toString()).isEmpty()) {
                System.out.println(headerStr);
            }
            List<VcfGenotype> genotypes = vcfEntry.getVcfGenotypes();
            for (int i = 0; i < genotypes.size(); ++i) {
                VcfGenotype genotype = genotypes.get(i);
                if (genotype.isVariant()) continue;
                if (nogenotype == null) {
                    nogenotype = new VcfGenotype(vcfEntry, vcfEntry.getFormat(), ".");
                }
                genotypes.set(i, nogenotype);
            }
            System.out.println(vcfEntry);
            if (entryNum % 1000 == 0) {
                if (entryNum % 100000 == 0) {
                    System.err.println('.');
                } else {
                    System.err.print('.');
                }
            }
            ++entryNum;
        }
        Timer.showStdErr("Done");
        return true;
    }

    @Override
    public void usage(String errMsg) {
        if (errMsg != null) {
            System.err.println("Error: " + errMsg);
        }
        System.err.println("Usage: cat file.vcf | java -jar " + SnpSift.class.getSimpleName() + ".jar rmRefGen [file.vcf] > file_noref.vcf");
        System.err.println("Options: ");
        System.err.println("\t file.vcf : Input VCF file. Default : STDIN");
        System.exit(1);
    }
}

