/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.snpeff.util.Gpr;
import org.snpeff.util.Timer;

public class Download {
    private static int BUFFER_SIZE = 102400;
    boolean debug = false;
    boolean verbose = false;
    boolean update;

    public static String urlBaseName(String url) {
        String[] f2 = url.toString().split("/");
        return f2[f2.length - 1];
    }

    void backupFile(ZipOutputStream zos, String fileName) {
        try {
            int len;
            FileInputStream fis = new FileInputStream(fileName);
            zos.putNextEntry(new ZipEntry(fileName));
            byte[] buf = new byte[BUFFER_SIZE];
            while ((len = fis.read(buf)) > 0) {
                zos.write(buf, 0, len);
            }
            zos.closeEntry();
            fis.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean download(String urlString, String localFile) {
        try {
            URL url = new URL(urlString);
            return this.download(url, localFile);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean download(URL url, String localFile) {
        boolean res = false;
        try {
            File path;
            File file;
            URLConnection connection;
            this.sslSetup();
            if (this.verbose) {
                Timer.showStdErr("Connecting to " + url);
            }
            if ((connection = url.openConnection()) instanceof HttpURLConnection) {
                boolean followRedirect = true;
                while (followRedirect) {
                    HttpURLConnection httpConnection = (HttpURLConnection)connection;
                    int code = httpConnection.getResponseCode();
                    if (code == 200) {
                        followRedirect = false;
                        continue;
                    }
                    if (code == 302) {
                        String newUrl = connection.getHeaderField("Location");
                        if (this.verbose) {
                            Timer.showStdErr("Following redirect: " + newUrl);
                        }
                        url = new URL(newUrl);
                        connection = url.openConnection();
                        continue;
                    }
                    if (code == 404) {
                        throw new RuntimeException("File not found on the server. Make sure the database name is correct.");
                    }
                    throw new RuntimeException("Error code from server: " + code);
                }
            }
            InputStream is = url.openStream();
            Date date = new Date(connection.getLastModified());
            if (this.debug) {
                Timer.showStdErr("Copying file (type: " + connection.getContentType() + ", modified on: " + date + ")");
            }
            if (this.verbose) {
                Timer.showStdErr("Local file name: '" + localFile + "'");
            }
            if ((file = new File(localFile)) != null && file.getParent() != null && !(path = new File(file.getParent())).exists()) {
                if (this.verbose) {
                    Timer.showStdErr("Local path '" + path + "' doesn't exist, creating.");
                }
                path.mkdirs();
            }
            FileOutputStream os = null;
            os = new FileOutputStream(localFile);
            int count2 = 0;
            int total = 0;
            int lastShown = 0;
            byte[] data2 = new byte[BUFFER_SIZE];
            while ((count2 = is.read(data2, 0, BUFFER_SIZE)) != -1) {
                os.write(data2, 0, count2);
                if ((total += count2) - lastShown <= 0x100000) continue;
                if (this.verbose) {
                    System.err.print(".");
                }
                lastShown = total;
            }
            if (this.verbose) {
                System.err.println("");
            }
            is.close();
            os.close();
            if (this.verbose) {
                Timer.showStdErr("Donwload finished. Total " + total + " bytes.");
            }
            res = true;
        }
        catch (Exception e) {
            Timer.showStdErr("ERROR while connecting to " + url);
            throw new RuntimeException(e);
        }
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String parseEntryPath(String entryName, String mainDir, String dataDir) {
        if (this.update) {
            int idx = entryName.indexOf(47);
            if (idx <= 0) throw new RuntimeException("Expecting at least one directory in path '" + entryName + "'");
            return mainDir + entryName.substring(idx);
        }
        String[] entryPath = entryName.split("/");
        String dataName = entryPath[entryPath.length - 2] + "/" + entryPath[entryPath.length - 1];
        entryName = dataDir + "/" + dataName;
        if (!this.debug) return entryName;
        Timer.showStdErr("Local file name: '" + entryName + "'");
        return entryName;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setUpdate(boolean update2) {
        this.update = update2;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    void sslSetup() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
        SSLContext.setDefault(ctx);
    }

    public boolean unzip(String zipFile, String mainDir, String dataDir) {
        try {
            ZipEntry entry;
            FileInputStream fis = new FileInputStream(zipFile);
            ZipInputStream zipIn = new ZipInputStream(new BufferedInputStream(fis));
            ZipOutputStream zipBackup = null;
            String backupFile = "";
            if (this.update) {
                backupFile = String.format("%s/backup_%2$tY-%2$tm-%2$td_%2$tH:%2$tM:%2$tS.zip", mainDir, new GregorianCalendar());
                if (this.verbose) {
                    Timer.showStdErr("Creating backup file '" + backupFile + "'");
                }
                zipBackup = new ZipOutputStream(new FileOutputStream(backupFile));
            }
            while ((entry = zipIn.getNextEntry()) != null) {
                if (!entry.isDirectory()) {
                    String dirName;
                    File dir;
                    String localEntryName = this.parseEntryPath(entry.getName(), mainDir, dataDir);
                    if (this.debug) {
                        Timer.showStdErr("Extracting file '" + entry.getName() + "' to '" + localEntryName + "'");
                    } else if (this.verbose) {
                        Timer.showStdErr("Extracting file '" + entry.getName() + "'");
                    }
                    if (zipBackup != null) {
                        this.backupFile(zipBackup, localEntryName);
                    }
                    if (!(dir = new File(dirName = Gpr.dirName(localEntryName))).exists()) {
                        if (this.verbose) {
                            Timer.showStdErr("Creating local directory: '" + dir + "'");
                        }
                        if (!dir.mkdirs()) {
                            throw new RuntimeException("Cannot create directory '" + dir.getCanonicalPath() + "'");
                        }
                    }
                    FileOutputStream fos = new FileOutputStream(localEntryName);
                    BufferedOutputStream dest = new BufferedOutputStream(fos, BUFFER_SIZE);
                    int count2 = 0;
                    byte[] data2 = new byte[BUFFER_SIZE];
                    while ((count2 = zipIn.read(data2, 0, BUFFER_SIZE)) != -1) {
                        dest.write(data2, 0, count2);
                    }
                    dest.flush();
                    dest.close();
                    continue;
                }
                if (!entry.isDirectory()) continue;
                String dir = this.parseEntryPath(entry.getName(), mainDir, dataDir);
                if (this.verbose) {
                    Timer.showStdErr("Creating local directory: '" + dir + "'");
                }
                if (new File(dir).mkdirs()) continue;
                throw new RuntimeException("Cannot create directory '" + dir + "'");
            }
            zipIn.close();
            if (zipBackup != null) {
                zipBackup.close();
                Timer.showStdErr("Backup file created: '" + backupFile + "'");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

