/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.unity;

import junit.framework.Assert;
import org.junit.Test;
import org.snpeff.align.VariantRealign;
import org.snpeff.binseq.GenomicSequences;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.testCases.unity.TestCasesBase;
import org.snpeff.util.Gpr;

public class TestCasesVariantRealignment
extends TestCasesBase {
    void checkRealign(String chrName, String chrSequence, int pos, String ref, String alt, String expectedVariantRealign) {
        Genome genome = new Genome("zzz");
        genome.getOrCreateChromosome(chrName).setSequence(chrSequence);
        GenomicSequences gs = genome.getGenomicSequences();
        gs.addChromosomeSequence(chrName, chrSequence);
        gs.build();
        Variant variant = new Variant((Marker)genome.getOrCreateChromosome(chrName), pos, ref, alt);
        VariantRealign vr = new VariantRealign(variant);
        vr.realign();
        if (this.verbose) {
            Gpr.debug("Realigned variant: " + vr);
        }
        Assert.assertEquals(expectedVariantRealign, vr.getVariantRealigned().toString());
    }

    @Override
    protected void init() {
        super.init();
        this.minExons = 2;
        this.randSeed = 20141128;
        this.initRand();
    }

    @Test
    public void test_01() {
        Gpr.debug("Test");
        if (this.verbose) {
            Gpr.debug(this.transcript);
        }
        Variant variant = new Variant((Marker)this.chromosome, 754, "", "T", "");
        if (this.verbose) {
            Gpr.debug("Variant: " + variant);
        }
        if (this.verbose) {
            Gpr.debug("Variant (before): " + variant);
        }
        Variant variantShifted = variant.realignLeft();
        if (this.verbose) {
            Gpr.debug("Variant (after): " + variantShifted);
        }
        Assert.assertFalse(variant == variantShifted);
        Assert.assertEquals(756, variantShifted.getStart());
        Assert.assertEquals("", variantShifted.getReference());
        Assert.assertEquals("T", variantShifted.getAlt());
    }

    @Test
    public void test_02() {
        Gpr.debug("Test");
        if (this.verbose) {
            Gpr.debug(this.transcript);
        }
        Variant variant = new Variant((Marker)this.chromosome, 754, "", "A", "");
        if (this.verbose) {
            Gpr.debug("Variant: " + variant);
        }
        if (this.verbose) {
            Gpr.debug("Variant (before): " + variant);
        }
        Variant variantShifted = variant.realignLeft();
        if (this.verbose) {
            Gpr.debug("Variant (after): " + variantShifted);
        }
        Assert.assertTrue(variant == variantShifted);
    }

    @Test
    public void test_03() {
        Gpr.debug("Test");
        if (this.verbose) {
            Gpr.debug(this.transcript);
        }
        Variant variant = new Variant((Marker)this.chromosome, 1025, "", "G", "");
        if (this.verbose) {
            Gpr.debug("Variant: " + variant);
        }
        if (this.verbose) {
            Gpr.debug("Variant (before): " + variant);
        }
        Variant variantShifted = variant.realignLeft();
        if (this.verbose) {
            Gpr.debug("Variant (after): " + variantShifted);
        }
        Assert.assertFalse(variant == variantShifted);
        Assert.assertEquals(1030, variantShifted.getStart());
        Assert.assertEquals("", variantShifted.getReference());
        Assert.assertEquals("G", variantShifted.getAlt());
    }

    @Test
    public void test_04_Intron() {
        Gpr.debug("Test");
        if (this.verbose) {
            Gpr.debug(this.transcript);
        }
        Variant variant = new Variant((Marker)this.chromosome, 920, "", "C", "");
        if (this.verbose) {
            Gpr.debug("Variant: " + variant);
        }
        if (this.verbose) {
            Gpr.debug("Variant (before): " + variant);
        }
        Variant variantShifted = variant.realignLeft();
        if (this.verbose) {
            Gpr.debug("Variant (after): " + variantShifted);
        }
        Assert.assertFalse(variant == variantShifted);
        Assert.assertEquals(925, variantShifted.getStart());
    }

    @Test
    public void test_05_savant() {
        Gpr.debug("Test");
        String seqRef = "AAACTGTATTT";
        String seqAlt = "AAACTATTT";
        VariantRealign vr = new VariantRealign();
        vr.setSequenceRef(seqRef);
        vr.setSequenceAlt(seqAlt);
        vr.realignSeqs();
        if (this.verbose) {
            Gpr.debug(vr);
        }
        Assert.assertEquals("GT", vr.getRefRealign());
        Assert.assertEquals("", vr.getAltRealign());
    }

    @Test
    public void test_05_savant_opposite() {
        Gpr.debug("Test");
        String seqRef = "AAACTATTT";
        String seqAlt = "AAACTGTATTT";
        VariantRealign vr = new VariantRealign();
        vr.setSequenceRef(seqRef);
        vr.setSequenceAlt(seqAlt);
        vr.realignSeqs();
        if (this.verbose) {
            Gpr.debug(vr);
        }
        Assert.assertEquals("", vr.getRefRealign());
        Assert.assertEquals("GT", vr.getAltRealign());
    }

    @Test
    public void test_06_savant() {
        Gpr.debug("Test");
        this.checkRealign("1", "AAACTGTATTT", 4, "TG", "", "chr1:5_GT/");
    }

    @Test
    public void test_07_savant() {
        Gpr.debug("Test");
        this.checkRealign("1", "TATGTTTAGGTTTATTGCATTCT", 8, "", "GGG", "chr1:10_/GGG");
    }

    @Test
    public void test_08_reallyLongRealign() {
        Gpr.debug("Test");
        this.checkRealign("1", "tatgaccagcagcagcagcagcagcagcagcagcagcagcagcagcaagcccttcagag", 6, "CAG", "", "chr1:44_GCA/");
    }

    @Test
    public void test_09_reallyLongRealign() {
        Gpr.debug("Test");
        this.checkRealign("1", "tatgaccagcagcagcagcagcagcagcagcagcag", 6, "CAG", "", "chr1:33_CAG/");
    }
}

