/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.integration;

import java.io.IOException;
import junit.framework.Assert;
import org.junit.Test;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Transcript;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.snpEffect.commandLine.SnpEffCmdProtein;
import org.snpeff.util.Gpr;

public class TestCasesIntegrationProtein {
    public static boolean verbose = false;

    @Test
    public void test_01() throws IOException {
        Gpr.debug("Test");
        String[] args = new String[]{"testHg3763ChrY", "./tests/proteins_testHg3763ChrY.txt"};
        SnpEffCmdProtein cmd = new SnpEffCmdProtein();
        cmd.parseArgs(args);
        cmd.run();
        Assert.assertEquals(0, cmd.getTotalErrors());
        Assert.assertEquals(true, cmd.getTotalOk() >= 167);
    }

    @Test
    public void test_start_codon_translate() {
        Gpr.debug("Test");
        String genomeName = "testHg19ChrM";
        Config config = new Config(genomeName);
        SnpEffectPredictor sep = config.loadSnpEffectPredictor();
        boolean checked = false;
        for (Gene g : sep.getGenome().getGenes()) {
            if (verbose) {
                System.out.println(g);
            }
            if (!g.getId().equals("ENSG00000198763")) continue;
            Transcript tr = (Transcript)g.iterator().next();
            checked = true;
            Assert.assertEquals("MNPLAQPVIYSTIFAGTLITALSSHWFFTWVGLEMNMLAFIPVLTKKMNPRSTEAAIKYFLTQATASMILLMAILFNNMLSGQWTMTNTTNQYSSLMIMMAMAMKLGMAPFHFWVPEVTQGTPLTSGLLLLTWQKLAPISIMYQISPSLNVSLLLTLSILSIMAGSWGGLNQTQLRKILAYSSITHMGWMMAVLPYNPNMTILNLTIYIILTTTAFLLLNLNSSTTTLLLSRTWNKLTWLTPLIPSTLLSLGGLPPLTGFLPKWAIIEEFTKNNSLIIPTIMATITLLNLYFYLRLIYSTSITLLPMSNNVKMKWQFEHTKPTPFLPTLIALTTLLLPISPFMLMIL?", tr.protein());
        }
        Assert.assertEquals(true, checked);
    }
}

