/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.integration;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.List;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Gene;
import org.snpeff.interval.SpliceSite;
import org.snpeff.interval.Transcript;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.snpEffect.factory.SnpEffPredictorFactory;
import org.snpeff.snpEffect.testCases.integration.TestCasesIntegrationBase;
import org.snpeff.util.Gpr;

public class TestCasesIntegrationGff3
extends TestCasesIntegrationBase {
    int exonToStringVersionOri;

    @After
    public void after() {
        Exon.ToStringVersion = this.exonToStringVersionOri;
    }

    @Before
    public void before() {
        this.exonToStringVersionOri = Exon.ToStringVersion;
        Exon.ToStringVersion = 1;
    }

    @Test
    public void testCase_01_Exon_Simple() {
        Gpr.debug("Test");
        String genome = "testCase";
        String gff3File = "tests/exonSimple.gff3";
        String resultFile = "tests/exonSimple.txt";
        this.buildGff3AndCompare(genome, gff3File, resultFile, true, false);
    }

    @Test
    public void testCase_02_ExonIn() {
        Gpr.debug("Test");
        String genome = "testCase";
        String gff3File = "tests/exonIn.gff3";
        String resultFile = "tests/exonIn.txt";
        this.buildGff3AndCompare(genome, gff3File, resultFile, true, false);
    }

    @Test
    public void testCase_03_ExonOut() {
        Gpr.debug("Test");
        String genome = "testCase";
        String gff3File = "tests/exonOut.gff3";
        String resultFile = "tests/exonOut.txt";
        this.buildGff3AndCompare(genome, gff3File, resultFile, true, false);
    }

    @Test
    public void testCase_04_AthalianaTair10_AT5G66790() {
        Gpr.debug("Test");
        Exon.ToStringVersion = this.exonToStringVersionOri;
        String genome = "testAthalianaTair10";
        String gff3File = "tests/AT5G66790.gff3";
        String resultFile = "tests/AT5G66790.txt";
        this.buildGff3AndCompare(genome, gff3File, resultFile, true, false);
    }

    @Test
    public void testCase_05_PaeruPA14muccA() {
        Gpr.debug("Test");
        Exon.ToStringVersion = this.exonToStringVersionOri;
        String genome = "testPaeru.PA14";
        String gff3File = "tests/paeru.PA14.muccA.gff";
        String resultFile = "tests/paeru.PA14.muccA.txt";
        SnpEffectPredictor sep = this.buildGff3AndCompare(genome, gff3File, resultFile, true, false);
        Gene gene = sep.getGenome().getGenes().iterator().next();
        Transcript tr = (Transcript)gene.iterator().next();
        tr.createSpliceSites(2, 0, 0, 0);
        List<SpliceSite> spliceSites = tr.spliceSites();
        Assert.assertEquals(0, spliceSites.size());
    }

    @Test
    public void testCase_06_Ppersica() {
        Gpr.debug("Test");
        Exon.ToStringVersion = this.exonToStringVersionOri;
        String genome = "testPpersica139";
        String gff3File = "tests/ppersica_139.gff";
        String resultFile = "tests/ppersica_139.txt";
        this.buildGff3AndCompare(genome, gff3File, resultFile, false, false);
    }

    @Test
    public void testCase_07_Rice5() {
        Gpr.debug("Test");
        String genome = "testRice5";
        String gff3File = "tests/Os03t0150600.gff";
        String resultFile = "tests/Os03t0150600.txt";
        this.buildGff3AndCompare(genome, gff3File, resultFile, false, false);
    }

    @Test
    public void testCase_08_Vibrio() {
        Gpr.debug("Test");
        Exon.ToStringVersion = this.exonToStringVersionOri;
        String genome = "testVibrio";
        String gff3File = "tests/vibrio.gff3";
        String resultFile = "tests/vibrio.txt";
        this.buildGff3AndCompare(genome, gff3File, resultFile, true, false);
    }

    @Test
    public void testCase_09() {
        Gpr.debug("Test");
        String genome = "testAP";
        String gff3File = "tests/testAP_genes.gff.gz";
        String resultFile = "tests/testAP.txt";
        this.buildGff3AndCompare(genome, gff3File, resultFile, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCase_09_AP() {
        Gpr.debug("Test");
        String genome = "testAP";
        String gff3File = "tests/testAP_genes.gff.gz";
        String resultFile = "tests/testAP.txt";
        PrintStream errOri = System.err;
        ByteArrayOutputStream myErr = new ByteArrayOutputStream();
        System.setErr(new PrintStream(myErr));
        try {
            SnpEffPredictorFactory.MIN_TOTAL_FRAME_COUNT = 1;
            this.buildGff3AndCompare(genome, gff3File, resultFile, true, false);
        }
        catch (Throwable t2) {
            t2.printStackTrace();
        }
        finally {
            System.setErr(errOri);
        }
        System.err.println("STDERR:\n" + myErr);
        Assert.assertTrue(myErr.toString().indexOf("WARNING: All frames are zero!") >= 0);
    }

    @Test
    public void testCase_10_MaizeZmB73() {
        Gpr.debug("Test");
        String genome = "testMaizeZmB73";
        String gff3File = "tests/testMaizeZmB73.gff3";
        String resultFile = "tests/testMaizeZmB73.txt";
        this.buildGff3AndCompare(genome, gff3File, resultFile, true, false);
    }

    @Test
    public void testCase_11_mita() {
        Gpr.debug("Test");
        String genome = "testMita";
        String gff3File = "tests/testMita.gff";
        String resultFile = null;
        this.buildGff3AndCompare(genome, gff3File, resultFile, false, false);
    }
}

