/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.snpeff.interval.BioType;
import org.snpeff.interval.Custom;
import org.snpeff.interval.FrameType;
import org.snpeff.interval.Genome;
import org.snpeff.interval.GffType;
import org.snpeff.interval.Marker;
import org.snpeff.util.Gpr;
import org.snpeff.util.KeyValue;

public class GffMarker
extends Custom {
    private static final long serialVersionUID = -164502778854644537L;
    String source;
    int frame;
    GffType gffType;
    String gffTypeStr;
    Map<String, String> keyValues;
    Set<String> keys;

    public static boolean canParseLine(String line) {
        if (line == null || line.isEmpty() || line.startsWith("#")) {
            return false;
        }
        String[] fields = line.split("\t");
        return fields.length >= 9;
    }

    public GffMarker() {
    }

    public GffMarker(Genome genome, String line) {
        this.parse(genome, line);
    }

    public GffMarker(Marker parent, int start, int end, boolean strandMinus, String id) {
        super(parent, start, end, strandMinus, id, "");
    }

    public void add(String key, String value2) {
        if (this.keyValues == null) {
            this.keyValues = new HashMap<String, String>();
        }
        if (this.keys == null) {
            this.keys = new HashSet<String>();
        }
        this.keys.add(key);
        this.keyValues.put(key.toLowerCase(), value2);
    }

    public String getAttr(String key) {
        return this.keyValues.get(key.toLowerCase());
    }

    public BioType getBiotype() {
        if (this.gffType == GffType.GENE) {
            return this.getGeneBiotype();
        }
        if (this.gffType == GffType.TRANSCRIPT) {
            return this.getTranscriptBiotype();
        }
        return this.getBiotypeGeneric();
    }

    protected String getBioType() {
        return this.getAttr("biotype");
    }

    protected BioType getBiotypeGeneric() {
        BioType bioType = null;
        if (this.hasAttr("biotype")) {
            return BioType.parse(this.getAttr("biotype"));
        }
        bioType = BioType.parse(this.source);
        if (bioType != null) {
            return bioType;
        }
        return BioType.parse(this.gffTypeStr);
    }

    public int getFrame() {
        return this.frame;
    }

    public BioType getGeneBiotype() {
        String[] keys;
        for (String key : keys = new String[]{"gene_biotype", "gene_type", "biotype"}) {
            if (!this.hasAttr(key)) continue;
            return BioType.parse(this.getAttr(key));
        }
        return this.getBiotypeGeneric();
    }

    public String getGeneId() {
        String key = "gene_id";
        if (this.hasAttr(key)) {
            return this.getAttr(key);
        }
        if (this.gffType == GffType.GENE) {
            return this.id;
        }
        if (this.gffType == GffType.TRANSCRIPT) {
            return this.getGffParentId(true);
        }
        return (Object)((Object)GffType.GENE) + "_" + this.id;
    }

    public String getGeneName() {
        String pid;
        if (this.hasAttr("gene_name")) {
            return this.getAttr("gene_name");
        }
        if (this.gffType == GffType.GENE && this.hasAttr("name")) {
            return this.getAttr("name");
        }
        if (this.gffType == GffType.TRANSCRIPT && (pid = this.getGffParentId(true)) != null) {
            return pid;
        }
        return this.id;
    }

    public String getGffParentId(boolean fromGeneId) {
        if (this.hasAttr("Parent")) {
            return this.getAttr("Parent");
        }
        switch (this.gffType) {
            case TRANSCRIPT: 
            case INTRON_CONSERVED: {
                if (this.hasAttr("gene")) {
                    return this.getAttr("gene");
                }
                return fromGeneId ? null : this.getGeneId();
            }
            case EXON: 
            case CDS: 
            case START_CODON: 
            case STOP_CODON: 
            case UTR3: 
            case UTR5: {
                return this.getTranscriptId();
            }
        }
        return null;
    }

    public String[] getGffParentIds() {
        String ids = this.getAttr("Parent");
        if (ids != null) {
            return ids.split(",");
        }
        String pid = this.getGffParentId(false);
        if (pid == null) {
            return null;
        }
        String[] pids = new String[]{pid};
        return pids;
    }

    public GffType getGffType() {
        return this.gffType;
    }

    public BioType getTranscriptBiotype() {
        String[] keys;
        for (String key : keys = new String[]{"transcript_biotype", "transcript_type", "biotype"}) {
            if (!this.hasAttr(key)) continue;
            return BioType.parse(this.getAttr(key));
        }
        return this.getBiotypeGeneric();
    }

    public String getTranscriptId() {
        String key = "transcript_id";
        if (this.hasAttr(key)) {
            return this.getAttr(key);
        }
        if (this.gffType == GffType.TRANSCRIPT) {
            return this.id;
        }
        if (this.gffType == GffType.EXON) {
            return this.getGffParentId(false);
        }
        return (Object)((Object)GffType.TRANSCRIPT) + "_" + this.id;
    }

    public String getTranscriptVersion() {
        return this.getAttr("transcript_version");
    }

    @Override
    public boolean hasAnnotations() {
        return true;
    }

    public boolean hasAttr(String key) {
        return this.keyValues.containsKey(key = key.toLowerCase()) && this.keyValues.get(key) != null;
    }

    public boolean isProteingCoding() {
        BioType bioType = this.getBiotype();
        return bioType != null && bioType.isProteinCoding();
    }

    @Override
    public Iterator<KeyValue<String, String>> iterator() {
        ArrayList<String> keysSorted = new ArrayList<String>();
        keysSorted.addAll(this.keys);
        Collections.sort(keysSorted);
        LinkedList<KeyValue<String, String>> iter2 = new LinkedList<KeyValue<String, String>>();
        for (String key : keysSorted) {
            iter2.add(new KeyValue<String, String>(key, this.getAttr(key)));
        }
        return iter2.iterator();
    }

    protected void parse(Genome genome, String line) {
        String[] fields = line.split("\t");
        String chromo = fields[0];
        this.parent = genome.getOrCreateChromosome(chromo);
        this.source = fields[1];
        if (this.source.equals(".")) {
            this.source = "";
        }
        this.gffTypeStr = fields[2];
        if (this.gffTypeStr.isEmpty() || this.gffTypeStr.equals(".")) {
            this.gffType = null;
        }
        this.gffType = GffType.parse(this.gffTypeStr);
        this.start = Gpr.parseIntSafe(fields[3]) - 1;
        this.end = Gpr.parseIntSafe(fields[4]) - 1;
        this.strandMinus = fields[6].equals("-");
        this.frame = fields[7].equals(".") ? -1 : Gpr.parseIntSafe(fields[7]);
        this.frame = FrameType.GFF.convertFrame(this.frame);
        if (fields.length >= 8) {
            this.parseAttributes(fields[8]);
        } else {
            this.parseAttributes(null);
        }
        this.id = this.parseId();
    }

    protected void parseAttributes(String attrStr) {
        this.keyValues = new HashMap<String, String>();
        this.keys = new HashSet<String>();
        this.add("source", this.source);
        this.add("type", this.gffTypeStr);
        if (attrStr != null && attrStr.length() > 0) {
            String[] attrs = attrStr.split(";");
            for (int i = 0; i < attrs.length; ++i) {
                String[] kv = attrs[i].split("=");
                if (kv.length <= 1) continue;
                String key = kv[0].trim();
                String value2 = kv[1].trim();
                if (this.hasAttr(key)) continue;
                this.add(key, value2);
            }
        }
    }

    protected String parseId() {
        String id = "";
        id = this.hasAttr("ID") ? this.getAttr("ID") : (this.gffType == GffType.GENE && this.hasAttr("gene_id") ? this.getAttr("gene_id") : (this.gffType == GffType.TRANSCRIPT && this.hasAttr("transcript_id") ? this.getAttr("transcript_id") : (this.gffType == GffType.EXON && this.hasAttr("exon_id") ? this.getAttr("exon_id") : (this.hasAttr("db_xref") ? this.getAttr("db_xref") : (this.hasAttr("Name") ? this.getAttr("Name") : (Object)((Object)this.gffType) + "_" + this.getChromosomeName() + "_" + (this.start + 1) + "_" + (this.end + 1))))));
        return id.trim();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getChromosomeName() + "\t" + this.source + "\t" + (Object)((Object)this.gffType) + "\t" + this.start + "\t" + this.end + "\t" + (this.strandMinus ? "-" : "+") + "\n");
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(this.keyValues.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            sb.append("\t" + key + " : " + this.getAttr(key) + "\n");
        }
        return sb.toString();
    }
}

