/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.fileIterator;

import java.io.IOException;
import org.snpeff.fileIterator.VariantFileIterator;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;
import org.snpeff.interval.Variant;
import org.snpeff.interval.VariantWithScore;
import org.snpeff.util.Gpr;
import org.snpeff.util.Timer;

public class BedFileIterator
extends VariantFileIterator {
    public static Markers load(String bedFileName, boolean verbose) {
        if (verbose) {
            Timer.showStdErr("Reading intervals from BED file '" + bedFileName + "'");
        }
        BedFileIterator bed = new BedFileIterator(bedFileName);
        Markers markers = new Markers();
        for (Variant var : bed) {
            markers.add(var);
        }
        if (markers.isEmpty()) {
            throw new RuntimeException("No intervals found in BED file " + bedFileName);
        }
        return markers;
    }

    public BedFileIterator(String fileName) {
        super(fileName);
        this.inOffset = 0;
    }

    public BedFileIterator(String fileName, Genome genome) {
        super(fileName, genome);
        this.inOffset = 0;
    }

    @Override
    protected Variant readNext() {
        try {
            while (this.ready()) {
                int start;
                String[] fields;
                this.line = this.readLine();
                if (this.line == null) {
                    return null;
                }
                if (this.line.length() <= 0 || this.line.startsWith("#") || (fields = this.line.split("\\t")).length < 2) continue;
                String chromosome = fields[0].trim();
                Chromosome chromo = this.getChromosome(chromosome);
                this.sanityCheckChromo(chromosome, chromo);
                int end = start = this.parsePosition(fields[1]);
                if (fields.length > 2) {
                    end = this.parsePosition(fields[2]) - 1;
                }
                if (end < start) {
                    end = start;
                }
                String id = "line_" + this.lineNum;
                if (fields.length > 3 && !fields[3].isEmpty()) {
                    id = fields[3];
                }
                double score = 0.0;
                if (fields.length > 4) {
                    score = Gpr.parseDoubleSafe(fields[4]);
                }
                VariantWithScore variant = new VariantWithScore((Marker)chromo, start, end, id, score);
                variant.setChromosomeNameOri(chromosome);
                return variant;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

