/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.binseq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Marker;
import org.snpeff.interval.MarkerSeq;
import org.snpeff.interval.Markers;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.tree.IntervalForest;
import org.snpeff.interval.tree.Itree;
import org.snpeff.snpEffect.Config;
import org.snpeff.util.Gpr;
import org.snpeff.util.GprSeq;
import org.snpeff.util.Timer;

public class GenomicSequences
implements Iterable<MarkerSeq>,
Serializable {
    private static final long serialVersionUID = 2339867422366567569L;
    public static final int MAX_ITERATIONS = 1000000;
    public static final int CHR_LEN_SEPARATE_FILE = 1000000;
    boolean debug = false;
    boolean verbose = false;
    boolean allSmallLoaded;
    boolean disableLoad = false;
    Genome genome;
    IntervalForest intervalForest;

    public GenomicSequences(Genome genome) {
        this.genome = genome;
        this.intervalForest = new IntervalForest();
    }

    public void addChromosomeSequence(String chr, String chrSeq) {
        MarkerSeq ms = new MarkerSeq(this.genome.getOrCreateChromosome(chr), 0, chrSeq.length() - 1, chrSeq);
        this.intervalForest.add(ms);
        this.build();
    }

    boolean addExonSequences(String chr) {
        if (this.verbose) {
            Timer.showStdErr("Creating sequences from exon information '" + chr + "'");
        }
        Itree tree = this.intervalForest.getOrCreateTreeChromo(chr);
        Markers exonMarkers = this.exonMarkers(chr);
        if (this.debug) {
            Gpr.debug("Before union: " + exonMarkers.size());
        }
        exonMarkers = exonMarkers.union();
        if (this.debug) {
            Gpr.debug("After union: " + exonMarkers.size());
        }
        tree.add(exonMarkers);
        if (this.verbose) {
            Timer.showStdErr("Building sequence tree for chromosome '" + chr + "'");
        }
        this.build();
        if (this.verbose) {
            Timer.showStdErr("Done. Loaded " + tree.getIntervals().size() + " sequences.");
        }
        return !tree.isEmpty();
    }

    public int addGeneSequences(String chr, String chrSeq) {
        int seqsAdded = 0;
        Markers markers = this.genesMarkers(chr, chrSeq.length());
        markers = markers.merge();
        for (Marker genes : markers) {
            if (!genes.getChromosomeName().equalsIgnoreCase(chr)) continue;
            int ssStart = genes.getStart();
            int ssEnd = genes.getEnd() + 1;
            if (ssStart < 0 || ssEnd > chrSeq.length()) {
                System.err.println("Ignoring gene outside chromosome range (chromo length: " + chrSeq.length() + "). Sequence (merged genes): " + genes.toStr());
                continue;
            }
            try {
                String seq2 = chrSeq.substring(ssStart, ssEnd).toUpperCase();
                ++seqsAdded;
                MarkerSeq m = new MarkerSeq(genes.getChromosome(), genes.getStart(), genes.getEnd(), false, genes.getChromosomeName() + ":" + genes.getStart() + "-" + genes.getEnd());
                m.setSequence(seq2);
                this.intervalForest.add(m);
            }
            catch (Throwable t2) {
                t2.printStackTrace();
                throw new RuntimeException("Error trying to add sequence for gene:\n\tChromosome sequence length: " + chrSeq.length() + "\n\tGene: " + genes.toStr());
            }
        }
        this.build();
        return seqsAdded;
    }

    public void build() {
        if (this.verbose) {
            Timer.showStdErr("Building sequence tree for genome sequences");
        }
        this.intervalForest.build();
        if (this.verbose) {
            Timer.showStdErr("Done.");
        }
    }

    public void clear() {
        this.intervalForest = new IntervalForest();
    }

    Markers exonMarkers(String chr) {
        Markers markers = new Markers();
        for (Gene g : this.genome.getGenes()) {
            if (!g.getChromosomeName().equals(chr)) continue;
            for (Transcript tr : g) {
                for (Exon ex : tr) {
                    String seq2 = ex.getSequence();
                    if (seq2 == null || seq2.length() < ex.size()) continue;
                    if (ex.isStrandPlus()) {
                        markers.add(ex);
                        continue;
                    }
                    Exon exRwc = (Exon)ex.clone();
                    exRwc.setSequence(GprSeq.reverseWc(ex.getSequence()));
                    markers.add(exRwc);
                }
            }
        }
        return markers;
    }

    Markers genesMarkers(String chr, int chrLen) {
        Markers markers = new Markers();
        for (Gene gene : this.genome.getGenes()) {
            if (!gene.getChromosomeName().equalsIgnoreCase(chr)) continue;
            int ssStart = gene.getStart();
            int ssEnd = gene.getEnd() + 1;
            if (ssStart < 0 || ssEnd > chrLen) {
                System.err.println("Ignoring gene outside chromosome range (chromo length: " + chrLen + "). Gene: " + gene.toStr());
                continue;
            }
            try {
                MarkerSeq m = new MarkerSeq(gene.getChromosome(), gene.getStart(), gene.getEnd(), false, gene.getId());
                markers.add(m);
            }
            catch (Throwable t2) {
                t2.printStackTrace();
                throw new RuntimeException("Error trying to add sequence for gene:\n\tChromosome sequence length: " + chrLen + "\n\tGene: " + gene.toStr());
            }
        }
        return markers;
    }

    public boolean hasChromosome(String chr) {
        if (!this.intervalForest.hasTree(chr)) {
            return false;
        }
        Itree tree = this.intervalForest.getTreeChromo(chr);
        return tree == null || !tree.isEmpty();
    }

    public boolean isEmpty() {
        for (Itree tree : this.intervalForest) {
            if (tree.getIntervals().isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<MarkerSeq> iterator() {
        ArrayList<MarkerSeq> all = new ArrayList<MarkerSeq>();
        for (Itree tree : this.intervalForest) {
            for (Marker m : tree.getIntervals()) {
                all.add((MarkerSeq)m);
            }
        }
        return all.iterator();
    }

    public synchronized boolean load() {
        if (this.disableLoad) {
            return false;
        }
        if (this.allSmallLoaded) {
            return false;
        }
        String fileName = Config.get().getFileNameSequence();
        if (!Gpr.exists(fileName)) {
            if (Config.get().isDebug()) {
                Timer.showStdErr("Attempting to load sequences from file '" + fileName + "' failed, nothing done.");
            }
            return false;
        }
        if (this.verbose) {
            Timer.showStdErr("Loading sequences from file '" + fileName + "'");
        }
        Markers markers = new Markers();
        HashSet<Itree> toBuild = new HashSet<Itree>();
        markers.load(fileName, this.genome);
        for (Marker m : markers) {
            if (m instanceof Genome || m instanceof Chromosome) continue;
            Itree tree = this.intervalForest.getOrCreateTreeChromo(m.getChromosomeName());
            tree.add(m);
            toBuild.add(tree);
        }
        for (Itree itree : toBuild) {
            if (itree.getIntervals().size() > 0 && this.verbose) {
                Timer.showStdErr("Building sequence tree for chromosome '" + itree.getIntervals().get(0).getChromosomeName() + "'");
            }
            itree.build();
        }
        this.allSmallLoaded = true;
        return true;
    }

    public synchronized boolean load(String chr) {
        if (this.hasChromosome(chr)) {
            return true;
        }
        if (this.disableLoad) {
            return false;
        }
        String fileName = Config.get().getFileNameSequence(chr);
        if (!Gpr.exists(fileName)) {
            if (Config.get().isDebug()) {
                Timer.showStdErr("Attempting to load sequences for chromosome '" + chr + "' from file '" + fileName + "' failed, nothing done.");
            }
            return false;
        }
        if (this.verbose) {
            Timer.showStdErr("Loading sequences for chromosome '" + chr + "' from file '" + fileName + "'");
        }
        Itree tree = this.intervalForest.getOrCreateTreeChromo(chr);
        tree.load(fileName, this.genome);
        if (this.verbose) {
            Timer.showStdErr("Building sequence tree for chromosome '" + chr + "'");
        }
        tree.build();
        if (this.verbose) {
            Timer.showStdErr("Done. Loaded " + tree.getIntervals().size() + " sequences.");
        }
        return !tree.isEmpty();
    }

    public synchronized boolean loadOrCreateFromGenome(String chr) {
        if (this.hasChromosome(chr)) {
            return true;
        }
        if (this.load(chr)) {
            return true;
        }
        this.load();
        return this.addExonSequences(chr);
    }

    public synchronized MarkerSeq queryMarkerSequence(Marker marker) {
        Itree tree;
        String chr = marker.getChromosomeName();
        if (!this.intervalForest.hasTree(chr)) {
            this.loadOrCreateFromGenome(chr);
        }
        if ((tree = this.intervalForest.getTreeChromo(chr)) == null || tree.isEmpty()) {
            return null;
        }
        Markers res = tree.query(marker);
        if (res.isEmpty()) {
            return null;
        }
        for (Marker m : res) {
            if (!m.includes(marker) || !(m instanceof MarkerSeq)) continue;
            return (MarkerSeq)m;
        }
        return null;
    }

    public String querySequence(Marker marker) {
        MarkerSeq ms = this.queryMarkerSequence(marker);
        if (ms == null) {
            return null;
        }
        int sstart = marker.getStart() - ms.getStart();
        int ssend = marker.size() + sstart;
        String seq2 = ms.getSequence().substring(sstart, ssend);
        if (marker.isStrandMinus()) {
            seq2 = GprSeq.reverseWc(seq2);
        }
        return seq2;
    }

    public void reset() {
        this.intervalForest = new IntervalForest();
    }

    public void save(Config config) {
        if (this.isEmpty()) {
            return;
        }
        ArrayList<String> chrNames = new ArrayList<String>();
        chrNames.addAll(this.intervalForest.keySet());
        Collections.sort(chrNames);
        Genome genome = config.getGenome();
        ArrayList<String> toSaveOneFile = new ArrayList<String>();
        for (String string2 : chrNames) {
            int seqLen = this.sequenceLen(string2);
            if (seqLen >= 1000000) {
                this.save(string2);
                continue;
            }
            toSaveOneFile.add(string2);
        }
        if (!toSaveOneFile.isEmpty()) {
            Markers markers = new Markers();
            markers.add(genome);
            for (String chrName : toSaveOneFile) {
                if (!this.intervalForest.hasTree(chrName)) continue;
                Itree tree = this.intervalForest.getTreeChromo(chrName);
                markers.addAll(tree.getIntervals());
            }
            String string3 = Config.get().getFileNameSequence();
            if (this.verbose) {
                Timer.showStdErr("Saving sequences for small chromosmes to file '" + string3 + "'");
            }
            markers.save(string3);
        }
    }

    void save(String chr) {
        if (!this.intervalForest.hasTree(chr)) {
            if (this.verbose) {
                Timer.showStdErr("No tree found for chromosome '" + chr + "'");
            }
            return;
        }
        Itree tree = this.intervalForest.getTreeChromo(chr);
        String fileName = Config.get().getFileNameSequence(chr);
        if (this.verbose) {
            Timer.showStdErr("Saving sequences for chromosome '" + chr + "' to file '" + fileName + "'");
        }
        tree.getIntervals().save(fileName, chr);
    }

    int sequenceLen(String chr) {
        Itree tree = this.intervalForest.getTreeChromo(chr);
        if (tree == null) {
            return 0;
        }
        int size2 = 0;
        for (Marker m : tree.getIntervals()) {
            if (!(m instanceof MarkerSeq)) continue;
            MarkerSeq ms = (MarkerSeq)m;
            size2 += ms.getSequence().length();
        }
        return size2;
    }

    public void setDisableLoad(boolean disableLoad) {
        this.disableLoad = disableLoad;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Genomic sequences '" + this.genome.getId() + "'\n");
        long sumMarkers = 0L;
        long sumLen = 0L;
        for (String chr : this.intervalForest.keySet()) {
            Itree tree = this.intervalForest.getTreeChromo(chr);
            long len = 0L;
            for (Marker m : tree.getIntervals()) {
                len += (long)m.size();
                sumLen += (long)m.size();
            }
            sumMarkers += (long)tree.getIntervals().size();
            sb.append("\t" + chr + "\t" + tree.size() + "\t" + len + "\n");
        }
        sb.append("\tTOTAL\t" + sumMarkers + "\t" + sumLen + "\n");
        return sb.toString();
    }
}

