/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest;

import java.util.Arrays;
import java.util.Iterator;
import org.hamcrest.Description;
import org.hamcrest.SelfDescribing;
import org.hamcrest.internal.ArrayIterator;
import org.hamcrest.internal.SelfDescribingValueIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseDescription
implements Description {
    @Override
    public Description appendText(String text2) {
        this.append(text2);
        return this;
    }

    @Override
    public Description appendDescriptionOf(SelfDescribing value2) {
        value2.describeTo(this);
        return this;
    }

    @Override
    public Description appendValue(Object value2) {
        if (value2 == null) {
            this.append("null");
        } else if (value2 instanceof String) {
            this.toJavaSyntax((String)value2);
        } else if (value2 instanceof Character) {
            this.append('\"');
            this.toJavaSyntax(((Character)value2).charValue());
            this.append('\"');
        } else if (value2 instanceof Short) {
            this.append('<');
            this.append(String.valueOf(value2));
            this.append("s>");
        } else if (value2 instanceof Long) {
            this.append('<');
            this.append(String.valueOf(value2));
            this.append("L>");
        } else if (value2 instanceof Float) {
            this.append('<');
            this.append(String.valueOf(value2));
            this.append("F>");
        } else if (value2.getClass().isArray()) {
            this.appendValueList("[", ", ", "]", new ArrayIterator(value2));
        } else {
            this.append('<');
            this.append(String.valueOf(value2));
            this.append('>');
        }
        return this;
    }

    @Override
    public <T> Description appendValueList(String start, String separator, String end, T ... values2) {
        return this.appendValueList(start, separator, end, (Iterable<T>)Arrays.asList(values2));
    }

    @Override
    public <T> Description appendValueList(String start, String separator, String end, Iterable<T> values2) {
        return this.appendValueList(start, separator, end, values2.iterator());
    }

    private <T> Description appendValueList(String start, String separator, String end, Iterator<T> values2) {
        return this.appendList(start, separator, end, new SelfDescribingValueIterator<T>(values2));
    }

    @Override
    public Description appendList(String start, String separator, String end, Iterable<? extends SelfDescribing> values2) {
        return this.appendList(start, separator, end, values2.iterator());
    }

    private Description appendList(String start, String separator, String end, Iterator<? extends SelfDescribing> i) {
        boolean separate2 = false;
        this.append(start);
        while (i.hasNext()) {
            if (separate2) {
                this.append(separator);
            }
            this.appendDescriptionOf(i.next());
            separate2 = true;
        }
        this.append(end);
        return this;
    }

    protected void append(String str) {
        for (int i = 0; i < str.length(); ++i) {
            this.append(str.charAt(i));
        }
    }

    protected abstract void append(char var1);

    private void toJavaSyntax(String unformatted) {
        this.append('\"');
        for (int i = 0; i < unformatted.length(); ++i) {
            this.toJavaSyntax(unformatted.charAt(i));
        }
        this.append('\"');
    }

    private void toJavaSyntax(char ch) {
        switch (ch) {
            case '\"': {
                this.append("\\\"");
                break;
            }
            case '\n': {
                this.append("\\n");
                break;
            }
            case '\r': {
                this.append("\\r");
                break;
            }
            case '\t': {
                this.append("\\t");
                break;
            }
            default: {
                this.append(ch);
            }
        }
    }
}

