/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.util;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.biojava3.core.util.FlatFileCache;
import org.biojava3.core.util.UncompressInputStream;

public class InputStreamProvider {
    public static final int GZIP_MAGIC = 8075;
    public static final String CACHE_PROPERTY = "biojava.cache.files";
    boolean cacheRawFiles = false;
    FlatFileCache cache;

    public InputStreamProvider() {
        String prop = System.getProperty(CACHE_PROPERTY);
        if (prop != null && prop.equals("true")) {
            this.cacheRawFiles = true;
            this.cache = FlatFileCache.getInstance();
        }
    }

    public InputStream getInputStream(String pathToFile) throws IOException {
        File f2 = new File(pathToFile);
        return this.getInputStream(f2);
    }

    private int getMagicNumber(InputStream in) throws IOException {
        int t2 = in.read();
        if (t2 < 0) {
            throw new EOFException("Failed to read magic number");
        }
        int magic = (t2 & 0xFF) << 8;
        t2 = in.read();
        if (t2 < 0) {
            throw new EOFException("Failed to read magic number");
        }
        return magic += t2 & 0xFF;
    }

    public InputStream getInputStream(URL u) throws IOException {
        InputStream inStream;
        int magic = 0;
        try {
            inStream = u.openStream();
            magic = this.getMagicNumber(inStream);
            inStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (magic == 8093) {
            return this.openCompressedURL(u);
        }
        if (magic == 8075) {
            return this.openGZIPURL(u);
        }
        if (u.toString().endsWith(".gz")) {
            return this.openGZIPURL(u);
        }
        if (u.toString().endsWith(".Z")) {
            return this.openCompressedURL(u);
        }
        inStream = u.openStream();
        return inStream;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InputStream getInputStream(File f2) throws IOException {
        int magic = 0;
        try {
            InputStream test2 = this.getInputStreamFromFile(f2);
            magic = this.getMagicNumber(test2);
            test2.close();
        }
        catch (Exception e) {
            System.err.println("Problem while loading: " + f2);
            e.printStackTrace();
        }
        InputStream inputStream = null;
        String fileName = f2.getName();
        if (magic == 8093) {
            return this.openCompressedFile(f2);
        }
        if (magic == 8075) {
            return this.openGZIPFile(f2);
        }
        if (fileName.endsWith(".gz")) {
            return this.openGZIPFile(f2);
        }
        if (fileName.endsWith(".zip")) {
            ZipFile zipfile = new ZipFile(f2);
            Enumeration<? extends ZipEntry> e = zipfile.entries();
            if (!e.hasMoreElements()) throw new IOException("Zip file has no entries");
            ZipEntry entry = e.nextElement();
            return zipfile.getInputStream(entry);
        }
        if (fileName.endsWith(".jar")) {
            JarFile jarFile = new JarFile(f2);
            Enumeration<JarEntry> e = jarFile.entries();
            if (!e.hasMoreElements()) throw new IOException("Jar file has no entries");
            JarEntry entry = e.nextElement();
            return jarFile.getInputStream(entry);
        }
        if (!fileName.endsWith(".Z")) return this.getInputStreamFromFile(f2);
        return this.openCompressedFile(f2);
    }

    private InputStream getInputStreamFromFile(File f2) throws FileNotFoundException {
        InputStream stream = null;
        if (this.cacheRawFiles && (stream = FlatFileCache.getInputStream(f2.getAbsolutePath())) == null) {
            FlatFileCache.addToCache(f2.getAbsolutePath(), f2);
            stream = FlatFileCache.getInputStream(f2.getAbsolutePath());
        }
        if (stream == null) {
            stream = new FileInputStream(f2);
        }
        return stream;
    }

    private InputStream openCompressedFile(File f2) throws IOException {
        InputStream is = this.getInputStreamFromFile(f2);
        UncompressInputStream inputStream = new UncompressInputStream(is);
        return inputStream;
    }

    private InputStream openCompressedURL(URL u) throws IOException {
        InputStream is = u.openStream();
        UncompressInputStream inputStream = new UncompressInputStream(is);
        return inputStream;
    }

    private InputStream openGZIPFile(File f2) throws IOException {
        InputStream is = this.getInputStreamFromFile(f2);
        GZIPInputStream inputStream = new GZIPInputStream(is);
        return inputStream;
    }

    private InputStream openGZIPURL(URL u) throws IOException {
        InputStream is = u.openStream();
        GZIPInputStream inputStream = new GZIPInputStream(is);
        return inputStream;
    }
}

