/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.io.mmcif.chem;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public enum PolymerType implements Serializable
{
    peptide("polypeptide(L)"),
    dpeptide("polypeptide(D)"),
    dna("polydeoxyribonucleotide"),
    rna("polyribonucleotide"),
    dnarna("polydeoxyribonucleotide/polyribonucleotide hybrid"),
    polysaccharide("polysaccharide(D)"),
    lpolysaccharide("polysaccharide(L)"),
    otherPolymer("other"),
    unknown(null);

    public final String entity_poly_type;
    public static final Set<PolymerType> PROTEIN_ONLY;
    public static final Set<PolymerType> DNA_ONLY;
    public static final Set<PolymerType> RNA_ONLY;
    public static final Set<PolymerType> POLYNUCLEOTIDE_ONLY;
    public static final Set<PolymerType> ALL_POLYMER_TYPES;

    private PolymerType(String entity_poly_type) {
        this.entity_poly_type = entity_poly_type;
    }

    public static PolymerType polymerTypeFromString(String polymerType) {
        for (PolymerType pt : PolymerType.values()) {
            if (!polymerType.equals(pt.entity_poly_type)) continue;
            return pt;
        }
        return unknown;
    }

    static {
        HashSet<PolymerType> tmp = new HashSet<PolymerType>();
        tmp.add(peptide);
        PROTEIN_ONLY = Collections.unmodifiableSet(tmp);
        tmp = new HashSet();
        tmp.add(dna);
        DNA_ONLY = Collections.unmodifiableSet(tmp);
        tmp = new HashSet();
        tmp.add(rna);
        RNA_ONLY = Collections.unmodifiableSet(tmp);
        tmp = new HashSet();
        tmp.add(dna);
        tmp.add(rna);
        tmp.add(dnarna);
        POLYNUCLEOTIDE_ONLY = Collections.unmodifiableSet(tmp);
        ALL_POLYMER_TYPES = Collections.unmodifiableSet(new HashSet<PolymerType>(Arrays.asList(PolymerType.values())));
    }
}

