/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.io.mmcif;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import org.biojava.bio.structure.io.mmcif.ChemCompConsumer;
import org.biojava.bio.structure.io.mmcif.ChemCompProvider;
import org.biojava.bio.structure.io.mmcif.ChemicalComponentDictionary;
import org.biojava.bio.structure.io.mmcif.SimpleMMcifParser;
import org.biojava.bio.structure.io.mmcif.chem.PolymerType;
import org.biojava.bio.structure.io.mmcif.chem.ResidueType;
import org.biojava.bio.structure.io.mmcif.model.ChemComp;

public class ReducedChemCompProvider
implements ChemCompProvider {
    public ChemComp getEmptyChemComp() {
        ChemComp comp = new ChemComp();
        comp.setOne_letter_code("?");
        comp.setPolymerType(PolymerType.unknown);
        comp.setResidueType(ResidueType.atomn);
        return comp;
    }

    @Override
    public ChemComp getChemComp(String recordName) {
        String name = recordName.toUpperCase().trim();
        InputStream inStream = this.getClass().getResourceAsStream("/chemcomp/" + name + ".cif.gz");
        if (inStream == null) {
            ChemComp cc = this.getEmptyChemComp();
            cc.setId(name);
            return cc;
        }
        SimpleMMcifParser parser = new SimpleMMcifParser();
        ChemCompConsumer consumer = new ChemCompConsumer();
        parser.addMMcifConsumer(consumer);
        try {
            parser.parse(new BufferedReader(new InputStreamReader(new GZIPInputStream(inStream))));
            ChemicalComponentDictionary dict = consumer.getDictionary();
            ChemComp chemComp = dict.getChemComp(name);
            return chemComp;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("problem when loading chem comp " + name);
            ChemComp cc = this.getEmptyChemComp();
            cc.setId(name);
            return cc;
        }
    }
}

