/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.io;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.biojava.bio.structure.jama.Matrix;
import org.biojava.bio.structure.quaternary.ModelTransformationMatrix;

public class PDBBioAssemblyParser {
    Integer currentBioMolecule = null;
    List<String> currentChainIDs;
    Matrix currentMatrix;
    double[] shift;
    Map<Integer, List<ModelTransformationMatrix>> transformationMap = new HashMap<Integer, List<ModelTransformationMatrix>>();
    int currentIndex = 1;
    List<ModelTransformationMatrix> transformations;
    int correct = 0;
    private boolean DEBUG = false;
    private boolean justCommitted = false;

    public PDBBioAssemblyParser() {
        this.currentChainIDs = new ArrayList<String>();
        this.transformations = new ArrayList<ModelTransformationMatrix>();
        this.currentMatrix = Matrix.identity(3, 3);
        this.shift = new double[3];
    }

    public void pdb_REMARK_350_Handler(String line) {
        if (line.startsWith("REMARK 350 BIOMOLECULE:")) {
            String nr = line.substring(24, line.length()).trim();
            if (this.currentBioMolecule != null) {
                this.finalizeCurrentBioMolecule();
            }
            this.currentBioMolecule = Integer.parseInt(nr);
            this.currentIndex = 1;
            this.currentChainIDs.clear();
        } else if (line.startsWith("REMARK 350 APPLY THE FOLLOWING TO CHAINS:")) {
            if (this.currentChainIDs.size() > 0) {
                this.addNewMatrix();
                this.currentChainIDs.clear();
                ++this.currentIndex;
            }
            if (this.currentChainIDs.size() > 0) {
                this.addNewMatrix();
                this.currentMatrix = Matrix.identity(3, 3);
                this.shift = new double[3];
                this.currentChainIDs.clear();
                this.justCommitted = true;
            }
            this.addToCurrentChainList(line);
        } else if (line.startsWith("REMARK 350                    AND CHAINS:")) {
            this.addToCurrentChainList(line);
        } else if (line.startsWith("REMARK 350   BIOMT")) {
            this.readMatrix(line);
        }
    }

    private void readMatrix(String line) {
        String pos = line.substring(18, 19);
        int i = Integer.parseInt(pos);
        String index2 = line.substring(21, 24 + this.correct).trim();
        int id = Integer.parseInt(index2);
        if (id != this.currentIndex && !this.justCommitted) {
            if (id > this.currentIndex + 1) {
                System.err.println("WARNING ID " + id + " > " + this.currentIndex + " " + this.currentChainIDs);
            } else {
                this.addNewMatrix();
            }
            this.currentIndex = id;
            this.currentMatrix = Matrix.identity(3, 3);
            this.shift = new double[3];
        }
        String x2 = line.substring(24 + this.correct, 33 + this.correct);
        String y = line.substring(34 + this.correct, 43 + this.correct);
        String z = line.substring(44 + this.correct, 53 + this.correct);
        String vec = line.substring(58 + this.correct, line.length()).trim();
        if (this.DEBUG) {
            System.out.println(id + " |" + i + "| |" + x2 + "| |" + y + "| |" + z + "| >" + vec + "<");
        }
        this.currentMatrix.set(0, i - 1, Float.parseFloat(x2));
        this.currentMatrix.set(1, i - 1, Float.parseFloat(y));
        this.currentMatrix.set(2, i - 1, Float.parseFloat(z));
        this.shift[i - 1] = Float.parseFloat(vec);
        this.justCommitted = false;
    }

    private void addNewMatrix() {
        ModelTransformationMatrix max2 = new ModelTransformationMatrix();
        if (this.DEBUG) {
            System.out.println("AddNewMatrix bio ass: " + this.currentBioMolecule + " index: " + this.currentIndex + " " + this.currentChainIDs);
            System.out.println(this.currentMatrix);
            System.out.println(Arrays.toString(this.shift));
        }
        max2.setMatrix(this.currentMatrix);
        max2.setVector(this.shift);
        max2.id = this.currentIndex + "";
        for (String chainId : this.currentChainIDs) {
            ModelTransformationMatrix m = max2.clone();
            m.setNdbChainId(chainId);
            this.transformations.add(m);
        }
        this.currentMatrix = Matrix.identity(3, 3);
        this.shift = new double[3];
        if (this.currentIndex == 999) {
            ++this.correct;
        }
        this.justCommitted = true;
    }

    private void addToCurrentChainList(String line) {
        String[] spl;
        String chainIds = line.substring(41, line.length()).trim().replaceAll(",", "");
        for (String chainId : spl = chainIds.split(" ")) {
            this.currentChainIDs.add(chainId);
        }
    }

    public void finalizeCurrentBioMolecule() {
        if (this.DEBUG) {
            System.out.println("finalizing biomolecule..." + this.currentBioMolecule + " (current index: " + this.currentIndex + ")");
        }
        this.addNewMatrix();
        this.transformationMap.put(this.currentBioMolecule, this.transformations);
        this.transformations = new ArrayList<ModelTransformationMatrix>();
        this.currentChainIDs.clear();
    }

    public Map<Integer, List<ModelTransformationMatrix>> getTransformationMap() {
        return this.transformationMap;
    }

    public void setTransformationMap(Map<Integer, List<ModelTransformationMatrix>> transformationMap) {
        this.transformationMap = transformationMap;
    }

    public int getNrBioAssemblies() {
        if (this.currentBioMolecule == null) {
            return 0;
        }
        return this.currentBioMolecule;
    }
}

