/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.domain;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.biojava.bio.structure.align.util.AtomCache;

public class SerializableCache<K, V> {
    protected String cacheFileName;
    protected Map<K, V> serializedCache;
    boolean debug = false;

    public SerializableCache(String cacheFileName) {
        this.cacheFileName = cacheFileName;
        if (cacheFileName != null) {
            this.reloadFromFile();
        }
    }

    public boolean isCacheEnabled() {
        return this.serializedCache != null;
    }

    public void cache(K name, V data2) {
        if (data2 == null) {
            return;
        }
        if (this.serializedCache != null) {
            if (this.debug) {
                System.out.println("Caching " + name + "  " + data2);
            }
            this.serializedCache.put(name, data2);
            if (this.serializedCache.keySet().size() % 1000 == 0) {
                this.flushCache();
            }
        }
    }

    public V get(K name) {
        if (this.serializedCache == null) {
            return null;
        }
        return this.serializedCache.get(name);
    }

    public void disableCache() {
        this.serializedCache = null;
    }

    public void enableCache() {
        this.reloadFromFile();
    }

    public Map<K, V> reloadFromFile() {
        File f2 = this.getCacheFile();
        this.serializedCache = new HashMap();
        if (!f2.exists()) {
            System.out.println("creating new cache " + f2.getAbsolutePath());
            return this.serializedCache;
        }
        try {
            if (this.debug) {
                System.out.println("reloading from cache " + f2.getAbsolutePath());
            }
            FileInputStream fis = new FileInputStream(f2);
            ObjectInputStream ois = new ObjectInputStream(fis);
            this.serializedCache = (HashMap)ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        System.out.println("reloaded from cache: " + f2.getName() + " size: " + this.serializedCache.keySet().size() + " cached records.");
        return this.serializedCache;
    }

    private File getCacheFile() {
        AtomCache cache = new AtomCache();
        String path = cache.getCachePath();
        File f2 = new File(path + System.getProperty("file.separator") + this.cacheFileName);
        if (this.debug) {
            System.out.println(f2.getAbsolutePath());
        }
        return f2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushCache() {
        if (this.serializedCache == null) {
            return;
        }
        Map<K, V> map2 = this.serializedCache;
        synchronized (map2) {
            File f2 = this.getCacheFile();
            try {
                FileOutputStream fos = new FileOutputStream(f2);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeObject(this.serializedCache);
                oos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

