/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.align.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.zip.GZIPInputStream;

public class HTTPConnectionTools {
    public static final String USERAGENT = "JFatCat Java client";
    public static final int DEFAULT_CONNECTION_TIMEOUT = 15000;

    public static HttpURLConnection openHttpURLConnection(URL url, int timeout) throws IOException, ConnectException {
        HttpURLConnection huc = null;
        huc = (HttpURLConnection)url.openConnection();
        huc.addRequestProperty("User-Agent", USERAGENT);
        System.setProperty("sun.net.client.defaultConnectTimeout", "" + timeout);
        System.setProperty("sun.net.client.defaultReadTimeout", "" + timeout);
        try {
            Class<?> urlconnectionClass = Class.forName("java.net.HttpURLConnection");
            Method setconnecttimeout = urlconnectionClass.getMethod("setConnectTimeout", Integer.TYPE);
            setconnecttimeout.invoke((Object)huc, new Integer(timeout));
            Method setreadtimeout = urlconnectionClass.getMethod("setReadTimeout", Integer.TYPE);
            setreadtimeout.invoke((Object)huc, new Integer(timeout));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return huc;
    }

    public static HttpURLConnection openHttpURLConnection(URL url) throws IOException, ConnectException {
        return HTTPConnectionTools.openHttpURLConnection(url, 15000);
    }

    public static InputStream getInputStream(URL url, int timeout) throws IOException {
        return HTTPConnectionTools.getInputStream(url, true, timeout);
    }

    public static InputStream getInputStream(URL url) throws IOException {
        return HTTPConnectionTools.getInputStream(url, true, 15000);
    }

    public static InputStream getInputStream(URL url, boolean acceptGzipEncoding, int timeout) throws IOException {
        InputStream inStream = null;
        HttpURLConnection huc = HTTPConnectionTools.openHttpURLConnection(url, timeout);
        if (acceptGzipEncoding) {
            huc.setRequestProperty("Accept-Encoding", "gzip");
        }
        int httpCode = huc.getResponseCode();
        String contentEncoding = huc.getContentEncoding();
        inStream = huc.getInputStream();
        if (contentEncoding != null && contentEncoding.indexOf("gzip") != -1) {
            inStream = new GZIPInputStream(inStream);
        }
        return inStream;
    }

    public static InputStream doPOST(URL url, String data2) throws IOException {
        return HTTPConnectionTools.doPOST(url, data2, 15000);
    }

    public static InputStream doPOST(URL url, String data2, int timeout) throws IOException {
        HttpURLConnection conn = HTTPConnectionTools.openHttpURLConnection(url, timeout);
        conn.setDoOutput(true);
        OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
        wr.write(data2);
        wr.flush();
        return conn.getInputStream();
    }
}

