/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.ChainImpl;
import org.biojava.bio.structure.Compound;
import org.biojava.bio.structure.DBRef;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.JournalArticle;
import org.biojava.bio.structure.PDBCrystallographicInfo;
import org.biojava.bio.structure.PDBHeader;
import org.biojava.bio.structure.SSBond;
import org.biojava.bio.structure.Site;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.io.FileConvert;

public class StructureImpl
implements Structure,
Serializable {
    private static final long serialVersionUID = -8344837138032851347L;
    String pdb_id;
    List<List<Chain>> models = new ArrayList<List<Chain>>();
    Map<String, Object> header = new HashMap<String, Object>();
    List<Map<String, Integer>> connections = new ArrayList<Map<String, Integer>>();
    List<Compound> compounds = new ArrayList<Compound>();
    List<DBRef> dbrefs = new ArrayList<DBRef>();
    List<SSBond> ssbonds;
    List<Site> sites;
    List<Group> hetAtoms;
    String name = "";
    private JournalArticle journalArticle;
    private PDBHeader pdbHeader = new PDBHeader();
    private PDBCrystallographicInfo crystallographicInfo;
    boolean nmrflag = false;
    private Long id;
    private boolean biologicalAssembly;

    public StructureImpl() {
        this.ssbonds = new ArrayList<SSBond>();
        this.sites = new ArrayList<Site>();
        this.hetAtoms = new ArrayList<Group>();
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public StructureImpl(Group g) {
        this();
        ChainImpl c = new ChainImpl();
        c.addGroup(g);
        this.addChain(c);
    }

    public StructureImpl(Chain c) {
        this();
        this.addChain(c);
    }

    @Override
    public Structure clone() {
        StructureImpl n = new StructureImpl();
        if (this.isNmr()) {
            n.setNmr(true);
        }
        n.setPDBCode(this.getPDBCode());
        n.setName(this.getName());
        n.setHeader(this.getHeader());
        n.setPDBHeader(this.pdbHeader);
        n.setDBRefs(this.getDBRefs());
        n.setConnections(this.getConnections());
        n.setSites(this.getSites());
        n.setCrystallographicInfo(this.getCrystallographicInfo());
        for (int i = 0; i < this.nrModels(); ++i) {
            ArrayList<Chain> cloned_model = new ArrayList<Chain>();
            for (int j = 0; j < this.size(i); ++j) {
                Chain current_chain = this.getChain(i, j);
                Chain cloned_chain = (Chain)current_chain.clone();
                cloned_model.add(cloned_chain);
            }
            n.addModel(cloned_model);
        }
        for (SSBond ssbond : this.ssbonds) {
            n.addSSBond(ssbond.clone());
        }
        return n;
    }

    @Override
    public Group findGroup(String chainId, String pdbResnum, int modelnr) throws StructureException {
        if (modelnr > this.models.size()) {
            throw new StructureException(" no model nr " + modelnr + " in this structure. (contains " + this.models.size() + ")");
        }
        Chain c = this.findChain(chainId, modelnr);
        List<Group> groups = c.getAtomGroups();
        for (Group g : groups) {
            String rnum = g.getResidueNumber().toString();
            if (!rnum.equals(pdbResnum)) continue;
            return g;
        }
        throw new StructureException("could not find group " + pdbResnum + " in chain " + chainId);
    }

    @Override
    public Group findGroup(String chainName, String pdbResnum) throws StructureException {
        return this.findGroup(chainName, pdbResnum, 0);
    }

    @Override
    public Chain findChain(String chainId, int modelnr) throws StructureException {
        List<Chain> chains = this.getChains(modelnr);
        for (Chain c : chains) {
            if (!c.getChainID().equals(chainId)) continue;
            return c;
        }
        throw new StructureException("could not find chain " + chainId);
    }

    @Override
    public Chain findChain(String chainId) throws StructureException {
        return this.findChain(chainId, 0);
    }

    @Override
    public void setPDBCode(String pdb_id_) {
        this.pdb_id = pdb_id_;
    }

    @Override
    public String getPDBCode() {
        return this.pdb_id;
    }

    @Override
    public void setName(String nam) {
        this.name = nam;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setHeader(Map<String, Object> h) {
        this.header = h;
    }

    @Override
    public Map<String, Object> getHeader() {
        return this.header;
    }

    @Override
    public void setConnections(List<Map<String, Integer>> conns) {
        this.connections = conns;
    }

    @Override
    public List<Map<String, Integer>> getConnections() {
        return this.connections;
    }

    @Override
    public void addChain(Chain chain2) {
        int modelnr = 0;
        this.addChain(chain2, modelnr);
    }

    @Override
    public void addChain(Chain chain2, int modelnr) {
        chain2.setParent(this);
        if (this.models.size() == 0) {
            ArrayList<Chain> model = new ArrayList<Chain>();
            model.add(chain2);
            this.models.add(model);
        } else {
            List<Chain> model = this.models.get(modelnr);
            model.add(chain2);
        }
    }

    @Override
    public Chain getChain(int number2) {
        int modelnr = 0;
        return this.getChain(modelnr, number2);
    }

    @Override
    public Chain getChain(int modelnr, int number2) {
        List<Chain> model = this.models.get(modelnr);
        Chain chain2 = model.get(number2);
        return chain2;
    }

    @Override
    public void addModel(List<Chain> model) {
        for (Chain c : model) {
            c.setParent(this);
        }
        this.models.add(model);
    }

    @Override
    public void setChains(List<Chain> chains) {
        this.setModel(0, chains);
    }

    @Override
    public void setModel(int position, List<Chain> model) {
        if (model == null) {
            throw new IllegalArgumentException("trying to set model to null!");
        }
        for (Chain c : model) {
            c.setParent(this);
        }
        if (this.models.size() == 0) {
            this.models.add(model);
        } else {
            this.models.set(position, model);
        }
    }

    @Override
    public String toString() {
        String newline = System.getProperty("line.separator");
        StringBuffer str = new StringBuffer();
        str.append("structure ");
        str.append(this.name);
        str.append(" ");
        str.append(this.pdb_id);
        str.append(" ");
        if (this.isNmr()) {
            str.append(" models: ");
            str.append(this.nrModels());
            str.append(newline);
        }
        str.append(this.pdbHeader.toString());
        str.append(newline);
        for (int i = 0; i < this.nrModels(); ++i) {
            if (this.isNmr()) {
                str.append(" model[");
                str.append(i);
                str.append("]:");
                str.append(newline);
            }
            str.append(" chains:");
            str.append(newline);
            for (int j = 0; j < this.size(i); ++j) {
                Compound comp;
                String molName;
                Chain cha = this.getChain(i, j);
                List<Group> agr = cha.getAtomGroups("amino");
                List<Group> hgr = cha.getAtomGroups("hetatm");
                List<Group> ngr = cha.getAtomGroups("nucleotide");
                str.append("chain " + j + ": >" + cha.getChainID() + "< ");
                if (cha.getHeader() != null && (molName = (comp = cha.getHeader()).getMolName()) != null) {
                    str.append(molName);
                }
                str.append(newline);
                str.append(" length SEQRES: ").append(cha.getSeqResLength());
                str.append(" length ATOM: ").append(cha.getAtomLength());
                str.append(" aminos: ").append(agr.size());
                str.append(" hetatms: ").append(hgr.size());
                str.append(" nucleotides: " + ngr.size() + newline);
            }
        }
        str.append("DBRefs: " + this.dbrefs.size() + newline);
        for (DBRef dbref : this.dbrefs) {
            str.append(dbref.toPDB()).append(newline);
        }
        str.append("Molecules: ").append(newline);
        for (Compound mol : this.compounds) {
            str.append(mol).append(newline);
        }
        return str.toString();
    }

    @Override
    public int size() {
        int modelnr = 0;
        if (this.models.size() > 0) {
            return this.models.get(modelnr).size();
        }
        return 0;
    }

    @Override
    public int size(int modelnr) {
        return this.getChains(modelnr).size();
    }

    @Override
    public int nrModels() {
        return this.models.size();
    }

    @Override
    public boolean isNmr() {
        return this.nmrflag;
    }

    @Override
    public void setNmr(boolean nmr) {
        this.nmrflag = nmr;
    }

    @Override
    public List<Chain> getChains(int modelnr) {
        return this.getModel(modelnr);
    }

    @Override
    public List<Chain> getChains() {
        return this.getModel(0);
    }

    @Override
    public void setChains(int modelnr, List<Chain> chains) {
        for (Chain c : chains) {
            c.setParent(this);
        }
        this.models.remove(modelnr);
        this.models.add(modelnr, chains);
    }

    @Override
    public List<Chain> getModel(int modelnr) {
        List<Chain> model = this.models.get(modelnr);
        return model;
    }

    @Override
    public Chain getChainByPDB(String chainId, int modelnr) throws StructureException {
        List<Chain> chains = this.getChains(modelnr);
        for (Chain c : chains) {
            if (!c.getChainID().equals(chainId)) continue;
            return c;
        }
        throw new StructureException("did not find chain with chainId >" + chainId + "<");
    }

    @Override
    public Chain getChainByPDB(String chainId) throws StructureException {
        return this.getChainByPDB(chainId, 0);
    }

    @Override
    public String toPDB() {
        FileConvert f2 = new FileConvert(this);
        String str = f2.toPDB();
        return str;
    }

    @Override
    public boolean hasChain(String chainId) {
        int modelnr = 0;
        List<Chain> chains = this.getChains(modelnr);
        for (Chain c : chains) {
            if (!c.getChainID().equals(chainId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setCompounds(List<Compound> molList) {
        this.compounds = molList;
    }

    @Override
    public List<Compound> getCompounds() {
        return this.compounds;
    }

    @Override
    public Compound getCompoundById(String molId) {
        for (Compound mol : this.compounds) {
            if (!mol.getMolId().equals(molId)) continue;
            return mol;
        }
        return null;
    }

    @Override
    public List<DBRef> getDBRefs() {
        return this.dbrefs;
    }

    @Override
    public void setDBRefs(List<DBRef> dbrefs) {
        if (dbrefs == null) {
            throw new IllegalArgumentException("trying to set dbrefs to null!");
        }
        for (DBRef ref : dbrefs) {
            ref.setParent(this);
        }
        this.dbrefs = dbrefs;
    }

    @Override
    public PDBHeader getPDBHeader() {
        return this.pdbHeader;
    }

    @Override
    public void setPDBHeader(PDBHeader pdbHeader) {
        this.pdbHeader = pdbHeader;
    }

    @Override
    public List<SSBond> getSSBonds() {
        return this.ssbonds;
    }

    @Override
    public void setSSBonds(List<SSBond> ssbonds) {
        this.ssbonds = ssbonds;
    }

    @Override
    public void addSSBond(SSBond ssbond) {
        this.ssbonds.add(ssbond);
        ssbond.setSerNum(this.ssbonds.size());
    }

    @Override
    public boolean hasJournalArticle() {
        return this.journalArticle != null;
    }

    @Override
    public JournalArticle getJournalArticle() {
        return this.journalArticle;
    }

    @Override
    public void setJournalArticle(JournalArticle journalArticle) {
        this.journalArticle = journalArticle;
    }

    @Override
    public List<Site> getSites() {
        return this.sites;
    }

    @Override
    public void setSites(List<Site> sites) {
        this.sites = sites;
    }

    @Override
    public List<Group> getHetGroups() {
        return this.hetAtoms;
    }

    @Override
    public void setBiologicalAssembly(boolean biologicalAssembly) {
        this.biologicalAssembly = biologicalAssembly;
    }

    @Override
    public boolean isBiologicalAssembly() {
        return this.biologicalAssembly;
    }

    @Override
    public void setCrystallographicInfo(PDBCrystallographicInfo crystallographicInfo) {
        this.crystallographicInfo = crystallographicInfo;
    }

    @Override
    public PDBCrystallographicInfo getCrystallographicInfo() {
        return this.crystallographicInfo;
    }
}

