/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava.bio.structure.AtomPositionMap;
import org.biojava.bio.structure.ResidueNumber;

public class ResidueRange {
    private final String chain;
    private final ResidueNumber end;
    private final Integer length;
    private final ResidueNumber start;
    public static final String RANGE_REGEX = "^([a-zA-Z])+[_:](?:(-?\\d+[a-zA-Z]?)-(-?\\d+[a-zA-Z]?))?$";

    public static int calcLength(List<ResidueRange> rrs) {
        int l = 0;
        for (ResidueRange rr : rrs) {
            if (rr.getLength() == null) {
                throw new IllegalArgumentException("At least one ResidueRange does not have a length.");
            }
            l += rr.getLength().intValue();
        }
        return l;
    }

    public static ResidueRange parse(String s) {
        ResidueNumber start = null;
        ResidueNumber end = null;
        String chain2 = null;
        Matcher matcher = ResidueRange.match(s);
        if (matcher.matches()) {
            try {
                chain2 = matcher.group(1);
                if (matcher.group(2) != null) {
                    start = ResidueNumber.fromString(matcher.group(2));
                    end = ResidueNumber.fromString(matcher.group(3));
                    start.setChainId(chain2);
                    end.setChainId(chain2);
                }
            }
            catch (IllegalStateException e) {
                throw new IllegalArgumentException("Range " + s + " was not valid", e);
            }
        }
        return new ResidueRange(chain2, start, end, null);
    }

    public static ResidueRange parse(String s, AtomPositionMap map2) {
        ResidueRange rr = ResidueRange.parse(s);
        if (rr.getStart() == null) {
            String chain2 = rr.getChainId();
            if (map2 == null) {
                return rr;
            }
            rr = new ResidueRange(chain2, map2.getFirst(chain2), map2.getLast(chain2), null);
        }
        if (map2 == null) {
            return rr;
        }
        int length = map2.calcLength(rr.getStart(), rr.getEnd());
        return new ResidueRange(rr.getChainId(), rr.getStart(), rr.getEnd(), (Integer)length);
    }

    public static List<ResidueRange> parseMultiple(String s) {
        String[] parts = s.split(",");
        ArrayList<ResidueRange> list2 = new ArrayList<ResidueRange>(parts.length);
        for (String part : parts) {
            list2.add(ResidueRange.parse(part));
        }
        return list2;
    }

    public static List<ResidueRange> parseMultiple(String s, AtomPositionMap map2) {
        String[] parts = s.split(",");
        ArrayList<ResidueRange> list2 = new ArrayList<ResidueRange>(parts.length);
        for (String part : parts) {
            list2.add(ResidueRange.parse(part, map2));
        }
        return list2;
    }

    public ResidueRange(char chain2, ResidueNumber start, ResidueNumber end, Integer length) {
        this(String.valueOf(chain2), start, end, length);
    }

    public ResidueRange(String chain2, ResidueNumber start, ResidueNumber end, Integer length) {
        this.chain = chain2;
        this.start = start;
        this.end = end;
        this.length = length;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResidueRange other = (ResidueRange)obj;
        if (this.chain == null ? other.chain != null : !this.chain.equals(other.chain)) {
            return false;
        }
        if (this.end == null ? other.end != null : !this.end.equals(other.end)) {
            return false;
        }
        return !(this.start == null ? other.start != null : !this.start.equals(other.start));
    }

    @Deprecated
    public char getChain() {
        if (this.chain.length() > 1) {
            throw new IllegalArgumentException("Can't return full chain Id " + this.chain);
        }
        return this.chain.charAt(0);
    }

    public String getChainId() {
        return this.chain;
    }

    public ResidueNumber getEnd() {
        return this.end;
    }

    public Integer getLength() {
        return this.length;
    }

    public ResidueNumber getStart() {
        return this.start;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.chain == null ? 0 : this.chain.hashCode());
        result2 = 31 * result2 + (this.end == null ? 0 : this.end.hashCode());
        result2 = 31 * result2 + (this.start == null ? 0 : this.start.hashCode());
        return result2;
    }

    public String toString() {
        return this.chain + "_" + this.start + "-" + this.end;
    }

    public boolean contains(ResidueNumber residueNumber, AtomPositionMap map2) {
        if (residueNumber == null) {
            throw new IllegalArgumentException("Can't find a null ResidueNumber");
        }
        if (map2 == null) {
            throw new IllegalArgumentException("The AtomPositionMap must be non-null");
        }
        if (this.start == null || this.end == null) {
            throw new IllegalArgumentException("The bounds of this ResidueNumber aren't known");
        }
        Integer pos = map2.getPosition(residueNumber);
        if (pos == null) {
            throw new IllegalArgumentException("Couldn't find residue " + residueNumber.printFull());
        }
        Integer startPos = map2.getPosition(this.start);
        if (startPos == null) {
            throw new IllegalArgumentException("Couldn't find the start position");
        }
        Integer endPos = map2.getPosition(this.end);
        if (endPos == null) {
            throw new IllegalArgumentException("Couldn't find the end position");
        }
        return pos >= startPos && pos <= endPos;
    }

    public ResidueNumber getResidue(int positionInRange, AtomPositionMap map2) {
        if (map2 == null) {
            throw new IllegalArgumentException("The AtomPositionMap must be non-null");
        }
        int i = 0;
        for (Map.Entry entry : map2.getNavMap().entrySet()) {
            if (i == positionInRange) {
                return (ResidueNumber)entry.getKey();
            }
            if (!this.contains((ResidueNumber)entry.getKey(), map2)) continue;
            ++i;
        }
        return null;
    }

    public Iterator<ResidueNumber> iterator(final AtomPositionMap map2) {
        int theLength = 0;
        theLength = this.length == null ? map2.calcLength(this.start, this.end) : this.length.intValue();
        final int length = theLength;
        return new Iterator<ResidueNumber>(){
            private ResidueNumber[] residueNumbers;
            private int i;
            {
                this.residueNumbers = new ResidueNumber[map2.getNavMap().size()];
                this.i = -1;
            }

            @Override
            public boolean hasNext() {
                return this.i < length;
            }

            @Override
            public ResidueNumber next() {
                if (this.i == -1) {
                    this.residueNumbers = new ResidueNumber[map2.getNavMap().size()];
                    int j = 0;
                    for (Map.Entry entry : map2.getNavMap().entrySet()) {
                        this.residueNumbers[j] = (ResidueNumber)entry.getKey();
                        if (!ResidueRange.this.contains((ResidueNumber)entry.getKey(), map2)) continue;
                        ++j;
                    }
                }
                ++this.i;
                ResidueNumber rn = this.residueNumbers[this.i];
                if (this.i > length) {
                    this.residueNumbers = null;
                    this.i = -1;
                }
                return rn;
            }

            @Override
            public void remove() {
            }
        };
    }

    public static Iterator<ResidueNumber> multiIterator(final AtomPositionMap map2, final ResidueRange ... rrs) {
        return new Iterator<ResidueNumber>(){
            private int r = 0;
            private Iterator<ResidueNumber> internal;

            @Override
            public boolean hasNext() {
                if (this.r == rrs.length - 1) {
                    this.init();
                    return this.internal.hasNext();
                }
                return true;
            }

            private void init() {
                if (this.internal == null) {
                    this.internal = rrs[this.r].iterator(map2);
                }
            }

            @Override
            public ResidueNumber next() {
                if (rrs.length == 0) {
                    throw new NoSuchElementException();
                }
                this.init();
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (!this.internal.hasNext()) {
                    ++this.r;
                    this.internal = rrs[this.r].iterator(map2);
                }
                return this.internal.next();
            }

            @Override
            public void remove() {
            }
        };
    }

    public static Iterator<ResidueNumber> multiIterator(AtomPositionMap map2, List<ResidueRange> rrs) {
        ResidueRange[] ranges = new ResidueRange[rrs.size()];
        for (int i = 0; i < rrs.size(); ++i) {
            ranges[i] = rrs.get(i);
        }
        return ResidueRange.multiIterator(map2, ranges);
    }

    public static List<ResidueRange> parseMultiple(List<String> ranges) {
        return ResidueRange.parseMultiple(ranges, null);
    }

    public static List<ResidueRange> parseMultiple(List<String> ranges, AtomPositionMap map2) {
        ArrayList<ResidueRange> rrs = new ArrayList<ResidueRange>(ranges.size());
        for (String range2 : ranges) {
            ResidueRange rr = ResidueRange.parse(range2, map2);
            if (rr == null) continue;
            rrs.add(rr);
        }
        return rrs;
    }

    public static Matcher match(String s) {
        Pattern pattern = Pattern.compile(RANGE_REGEX);
        Matcher matcher = pattern.matcher(s);
        matcher.find();
        return matcher;
    }

    public static boolean looksLikeRange(String s) {
        return ResidueRange.match(s).matches();
    }
}

