/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.internal.IntModConstants;
import org.apfloat.internal.IntModMath;
import org.apfloat.internal.IntScramble;
import org.apfloat.internal.TransformLengthExceededException;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.NTTStrategy;
import org.apfloat.spi.Util;

public class IntTableFNTStrategy
extends IntModMath
implements NTTStrategy {
    public void transform(DataStorage dataStorage, int modulus) throws ApfloatRuntimeException {
        long length = dataStorage.getSize();
        if (length > 0x3000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + length + " > " + 0x3000000L);
        }
        if (length > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Maximum array length exceeded: " + length);
        }
        this.setModulus(IntModConstants.MODULUS[modulus]);
        int w = this.getForwardNthRoot(IntModConstants.PRIMITIVE_ROOT[modulus], length);
        int[] wTable = this.createWTable(w, (int)length);
        ArrayAccess arrayAccess = dataStorage.getArray(3, 0L, (int)length);
        this.tableFNT(arrayAccess, wTable, null);
        arrayAccess.close();
    }

    public void inverseTransform(DataStorage dataStorage, int modulus, long totalTransformLength) throws ApfloatRuntimeException {
        long length = dataStorage.getSize();
        if (Math.max(length, totalTransformLength) > 0x3000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + Math.max(length, totalTransformLength) + " > " + 0x3000000L);
        }
        if (length > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Maximum array length exceeded: " + length);
        }
        this.setModulus(IntModConstants.MODULUS[modulus]);
        int w = this.getInverseNthRoot(IntModConstants.PRIMITIVE_ROOT[modulus], length);
        int[] wTable = this.createWTable(w, (int)length);
        ArrayAccess arrayAccess = dataStorage.getArray(3, 0L, (int)length);
        this.inverseTableFNT(arrayAccess, wTable, null);
        this.divideElements(arrayAccess, (int)totalTransformLength);
        arrayAccess.close();
    }

    public long getTransformLength(long size2) {
        return Util.round2up(size2);
    }

    protected void tableFNT(ArrayAccess arrayAccess, int[] wTable, int[] permutationTable) throws ApfloatRuntimeException {
        int[] data2 = arrayAccess.getIntData();
        int offset = arrayAccess.getOffset();
        int nn = arrayAccess.getLength();
        assert (nn == (nn & -nn));
        if (nn < 2) {
            return;
        }
        int r = 1;
        for (int mmax = nn >> 1; mmax > 0; mmax >>= 1) {
            int istep = mmax << 1;
            for (int i = offset; i < offset + nn; i += istep) {
                int j = i + mmax;
                int a = data2[i];
                int b = data2[j];
                data2[i] = this.modAdd(a, b);
                data2[j] = this.modSubtract(a, b);
            }
            int t2 = r;
            for (int m = 1; m < mmax; ++m) {
                for (int i = offset + m; i < offset + nn; i += istep) {
                    int j = i + mmax;
                    int a = data2[i];
                    int b = data2[j];
                    data2[i] = this.modAdd(a, b);
                    data2[j] = this.modMultiply(wTable[t2], this.modSubtract(a, b));
                }
                t2 += r;
            }
            r <<= 1;
        }
        if (permutationTable != null) {
            IntScramble.scramble(data2, offset, permutationTable);
        }
    }

    protected void inverseTableFNT(ArrayAccess arrayAccess, int[] wTable, int[] permutationTable) throws ApfloatRuntimeException {
        int[] data2 = arrayAccess.getIntData();
        int offset = arrayAccess.getOffset();
        int nn = arrayAccess.getLength();
        assert (nn == (nn & -nn));
        if (nn < 2) {
            return;
        }
        if (permutationTable != null) {
            IntScramble.scramble(data2, offset, permutationTable);
        }
        int r = nn;
        int mmax = 1;
        while (nn > mmax) {
            int istep = mmax << 1;
            r >>= 1;
            for (int i = offset; i < offset + nn; i += istep) {
                int j = i + mmax;
                int wTemp = data2[j];
                data2[j] = this.modSubtract(data2[i], wTemp);
                data2[i] = this.modAdd(data2[i], wTemp);
            }
            int t2 = r;
            for (int m = 1; m < mmax; ++m) {
                for (int i = offset + m; i < offset + nn; i += istep) {
                    int j = i + mmax;
                    int wTemp = this.modMultiply(wTable[t2], data2[j]);
                    data2[j] = this.modSubtract(data2[i], wTemp);
                    data2[i] = this.modAdd(data2[i], wTemp);
                }
                t2 += r;
            }
            mmax = istep;
        }
    }

    private void divideElements(ArrayAccess arrayAccess, int divisor) throws ApfloatRuntimeException {
        int inverseFactor = this.modDivide(1, divisor);
        int[] data2 = arrayAccess.getIntData();
        int length = arrayAccess.getLength();
        int offset = arrayAccess.getOffset();
        for (int i = 0; i < length; ++i) {
            data2[i + offset] = this.modMultiply(data2[i + offset], inverseFactor);
        }
    }
}

