/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import java.util.RandomAccess;
import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.internal.IntMemoryArrayAccess;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.DataStorage;

public class IntMemoryDataStorage
extends DataStorage
implements RandomAccess {
    private static final long serialVersionUID = 4034264499027294039L;
    private int[] data;

    public IntMemoryDataStorage() {
        this.data = new int[0];
    }

    protected IntMemoryDataStorage(IntMemoryDataStorage intMemoryDataStorage, long offset, long length) {
        super(intMemoryDataStorage, offset, length);
        this.data = intMemoryDataStorage.data;
    }

    protected DataStorage implSubsequence(long offset, long length) throws ApfloatRuntimeException {
        return new IntMemoryDataStorage(this, offset + this.getOffset(), length);
    }

    protected void implCopyFrom(DataStorage dataStorage, long size2) throws ApfloatRuntimeException {
        assert (size2 > 0L);
        assert (!this.isReadOnly());
        assert (!this.isSubsequenced());
        if (size2 > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Size too big for memory array: " + size2);
        }
        this.data = new int[(int)size2];
        ApfloatContext ctx = ApfloatContext.getContext();
        int readSize = (int)Math.min(size2, dataStorage.getSize());
        int position = 0;
        int bufferSize = ctx.getBlockSize() / 4;
        while (readSize > 0) {
            int length = Math.min(bufferSize, readSize);
            ArrayAccess arrayAccess = dataStorage.getArray(1, position, length);
            System.arraycopy(arrayAccess.getIntData(), arrayAccess.getOffset(), this.data, position, length);
            arrayAccess.close();
            readSize -= length;
            position += length;
        }
    }

    protected long implGetSize() {
        return this.data.length;
    }

    protected void implSetSize(long size2) throws ApfloatRuntimeException {
        assert (size2 > 0L);
        assert (!this.isReadOnly());
        assert (!this.isSubsequenced());
        if (size2 == (long)this.data.length) {
            return;
        }
        if (size2 > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Size too big for memory array: " + size2);
        }
        int newSize = (int)size2;
        int[] newData = new int[newSize];
        System.arraycopy(this.data, 0, newData, 0, Math.min(this.data.length, newSize));
        this.data = newData;
    }

    protected ArrayAccess implGetArray(int mode, long offset, int length) throws ApfloatRuntimeException {
        return new IntMemoryArrayAccess(this.data, (int)(offset + this.getOffset()), length);
    }

    protected ArrayAccess implGetTransposedArray(int mode, int startColumn, int columns, int rows) throws ApfloatRuntimeException {
        throw new ApfloatInternalException("Method not implemented - would be sub-optimal; change the apfloat configuration settings");
    }

    public DataStorage.Iterator iterator(int mode, long startPosition, long endPosition) throws IllegalArgumentException, IllegalStateException, ApfloatRuntimeException {
        ReadWriteIterator iterator2;
        switch (mode & 3) {
            case 1: {
                iterator2 = new ReadOnlyIterator(startPosition, endPosition);
                break;
            }
            case 2: {
                iterator2 = new WriteOnlyIterator(startPosition, endPosition);
                break;
            }
            case 3: {
                iterator2 = new ReadWriteIterator(startPosition, endPosition);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal mode: " + mode);
            }
        }
        return iterator2;
    }

    private class WriteOnlyIterator
    extends ReadWriteIterator {
        public WriteOnlyIterator(long startPosition, long endPosition) throws IllegalArgumentException, IllegalStateException, ApfloatRuntimeException {
            super(2, startPosition, endPosition);
        }

        public int getInt() throws IllegalStateException {
            throw new IllegalStateException("Not a readable iterator");
        }
    }

    private class ReadOnlyIterator
    extends ReadWriteIterator {
        public ReadOnlyIterator(long startPosition, long endPosition) throws IllegalArgumentException, IllegalStateException, ApfloatRuntimeException {
            super(1, startPosition, endPosition);
        }

        public void setInt(int value2) throws IllegalStateException {
            throw new IllegalStateException("Not a writable iterator");
        }
    }

    private class ReadWriteIterator
    extends DataStorage.AbstractIterator {
        private int[] data;
        private int position;
        private int length;

        public ReadWriteIterator(long startPosition, long endPosition) throws IllegalArgumentException, IllegalStateException, ApfloatRuntimeException {
            this(3, startPosition, endPosition);
        }

        protected ReadWriteIterator(int mode, long startPosition, long endPosition) throws IllegalArgumentException, IllegalStateException, ApfloatRuntimeException {
            super(IntMemoryDataStorage.this, mode, startPosition, endPosition);
            this.data = IntMemoryDataStorage.this.data;
            this.position = (int)this.getPosition() + (int)IntMemoryDataStorage.this.getOffset();
            this.length = (int)this.getLength();
        }

        public boolean hasNext() {
            return this.length > 0;
        }

        public void next() throws IllegalStateException {
            this.checkLength();
            this.position += this.getIncrement();
            --this.length;
        }

        public int getInt() throws IllegalStateException {
            this.checkLength();
            return this.data[this.position];
        }

        public void setInt(int value2) throws IllegalStateException {
            this.checkLength();
            this.data[this.position] = value2;
        }

        protected void checkLength() throws IllegalStateException {
            if (this.length == 0) {
                throw new IllegalStateException("At the end of iterator");
            }
        }
    }
}

