/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime;

import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.PositionTrackingStream;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeAdaptor;
import org.antlr.runtime.tree.TreeNodeStream;

public class RecognitionException
extends Exception {
    public transient IntStream input;
    public int index;
    public Token token;
    public Object node;
    public int c;
    public int line;
    public int charPositionInLine;
    public boolean approximateLineInfo;

    public RecognitionException() {
    }

    public RecognitionException(IntStream input2) {
        this.input = input2;
        this.index = input2.index();
        if (input2 instanceof TokenStream) {
            this.token = ((TokenStream)input2).LT(1);
            this.line = this.token.getLine();
            this.charPositionInLine = this.token.getCharPositionInLine();
        }
        if (input2 instanceof TreeNodeStream) {
            this.extractInformationFromTreeNodeStream(input2);
        } else if (input2 instanceof CharStream) {
            this.c = input2.LA(1);
            this.line = ((CharStream)input2).getLine();
            this.charPositionInLine = ((CharStream)input2).getCharPositionInLine();
        } else {
            this.c = input2.LA(1);
        }
    }

    protected void extractInformationFromTreeNodeStream(IntStream input2) {
        TreeAdaptor adaptor;
        Token payload;
        TreeNodeStream nodes = (TreeNodeStream)input2;
        this.node = nodes.LT(1);
        Object positionNode = null;
        if (nodes instanceof PositionTrackingStream && (positionNode = (Object)((PositionTrackingStream)((Object)nodes)).getKnownPositionElement(false)) == null) {
            positionNode = ((PositionTrackingStream)((Object)nodes)).getKnownPositionElement(true);
            this.approximateLineInfo = positionNode != null;
        }
        if ((payload = (adaptor = nodes.getTreeAdaptor()).getToken(positionNode != null ? positionNode : this.node)) != null) {
            this.token = payload;
            if (payload.getLine() <= 0) {
                int i = -1;
                Object priorNode = nodes.LT(i);
                while (priorNode != null) {
                    Token priorPayload = adaptor.getToken(priorNode);
                    if (priorPayload != null && priorPayload.getLine() > 0) {
                        this.line = priorPayload.getLine();
                        this.charPositionInLine = priorPayload.getCharPositionInLine();
                        this.approximateLineInfo = true;
                        break;
                    }
                    --i;
                    try {
                        priorNode = nodes.LT(i);
                    }
                    catch (UnsupportedOperationException ex) {
                        priorNode = null;
                    }
                }
            } else {
                this.line = payload.getLine();
                this.charPositionInLine = payload.getCharPositionInLine();
            }
        } else if (this.node instanceof Tree) {
            this.line = ((Tree)this.node).getLine();
            this.charPositionInLine = ((Tree)this.node).getCharPositionInLine();
            if (this.node instanceof CommonTree) {
                this.token = ((CommonTree)this.node).token;
            }
        } else {
            int type = adaptor.getType(this.node);
            String text2 = adaptor.getText(this.node);
            this.token = new CommonToken(type, text2);
        }
    }

    public int getUnexpectedType() {
        if (this.input instanceof TokenStream) {
            return this.token.getType();
        }
        if (this.input instanceof TreeNodeStream) {
            TreeNodeStream nodes = (TreeNodeStream)this.input;
            TreeAdaptor adaptor = nodes.getTreeAdaptor();
            return adaptor.getType(this.node);
        }
        return this.c;
    }
}

