/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.impl.hash;

import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.hash.TPrimitiveHash;
import gnu.trove.procedure.TCharProcedure;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class TCharDoubleHash
extends TPrimitiveHash {
    static final long serialVersionUID = 1L;
    public transient char[] _set;
    protected char no_entry_key;
    protected double no_entry_value;
    protected boolean consumeFreeSlot;

    public TCharDoubleHash() {
        this.no_entry_key = '\u0000';
        this.no_entry_value = 0.0;
    }

    public TCharDoubleHash(int initialCapacity) {
        super(initialCapacity);
        this.no_entry_key = '\u0000';
        this.no_entry_value = 0.0;
    }

    public TCharDoubleHash(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.no_entry_key = '\u0000';
        this.no_entry_value = 0.0;
    }

    public TCharDoubleHash(int initialCapacity, float loadFactor, char no_entry_key, double no_entry_value) {
        super(initialCapacity, loadFactor);
        this.no_entry_key = no_entry_key;
        this.no_entry_value = no_entry_value;
    }

    public char getNoEntryKey() {
        return this.no_entry_key;
    }

    public double getNoEntryValue() {
        return this.no_entry_value;
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._set = new char[capacity];
        return capacity;
    }

    public boolean contains(char val) {
        return this.index(val) >= 0;
    }

    public boolean forEach(TCharProcedure procedure) {
        byte[] states = this._states;
        char[] set = this._set;
        int i = set.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(set[i])) continue;
            return false;
        }
        return true;
    }

    protected void removeAt(int index2) {
        this._set[index2] = this.no_entry_key;
        super.removeAt(index2);
    }

    protected int index(char key) {
        byte[] states = this._states;
        char[] set = this._set;
        int length = states.length;
        int hash2 = HashFunctions.hash(key) & Integer.MAX_VALUE;
        int index2 = hash2 % length;
        byte state = states[index2];
        if (state == 0) {
            return -1;
        }
        if (state == 1 && set[index2] == key) {
            return index2;
        }
        return this.indexRehashed(key, index2, hash2, state);
    }

    int indexRehashed(char key, int index2, int hash2, byte state) {
        int length = this._set.length;
        int probe = 1 + hash2 % (length - 2);
        int loopIndex = index2;
        do {
            if ((index2 -= probe) < 0) {
                index2 += length;
            }
            if ((state = this._states[index2]) == 0) {
                return -1;
            }
            if (key != this._set[index2] || state == 2) continue;
            return index2;
        } while (index2 != loopIndex);
        return -1;
    }

    protected int insertKey(char val) {
        int hash2 = HashFunctions.hash(val) & Integer.MAX_VALUE;
        int index2 = hash2 % this._states.length;
        byte state = this._states[index2];
        this.consumeFreeSlot = false;
        if (state == 0) {
            this.consumeFreeSlot = true;
            this.insertKeyAt(index2, val);
            return index2;
        }
        if (state == 1 && this._set[index2] == val) {
            return -index2 - 1;
        }
        return this.insertKeyRehash(val, index2, hash2, state);
    }

    int insertKeyRehash(char val, int index2, int hash2, byte state) {
        int length = this._set.length;
        int probe = 1 + hash2 % (length - 2);
        int loopIndex = index2;
        int firstRemoved = -1;
        do {
            if (state == 2 && firstRemoved == -1) {
                firstRemoved = index2;
            }
            if ((index2 -= probe) < 0) {
                index2 += length;
            }
            if ((state = this._states[index2]) == 0) {
                if (firstRemoved != -1) {
                    this.insertKeyAt(firstRemoved, val);
                    return firstRemoved;
                }
                this.consumeFreeSlot = true;
                this.insertKeyAt(index2, val);
                return index2;
            }
            if (state != 1 || this._set[index2] != val) continue;
            return -index2 - 1;
        } while (index2 != loopIndex);
        if (firstRemoved != -1) {
            this.insertKeyAt(firstRemoved, val);
            return firstRemoved;
        }
        throw new IllegalStateException("No free or removed slots available. Key set full?!!");
    }

    void insertKeyAt(int index2, char val) {
        this._set[index2] = val;
        this._states[index2] = 1;
    }

    protected int XinsertKey(char key) {
        byte[] states = this._states;
        char[] set = this._set;
        int length = states.length;
        int hash2 = HashFunctions.hash(key) & Integer.MAX_VALUE;
        int index2 = hash2 % length;
        byte state = states[index2];
        this.consumeFreeSlot = false;
        if (state == 0) {
            this.consumeFreeSlot = true;
            set[index2] = key;
            states[index2] = 1;
            return index2;
        }
        if (state == 1 && set[index2] == key) {
            return -index2 - 1;
        }
        int probe = 1 + hash2 % (length - 2);
        if (state != 2) {
            do {
                if ((index2 -= probe) >= 0) continue;
                index2 += length;
            } while ((state = states[index2]) == 1 && set[index2] != key);
        }
        if (state == 2) {
            int firstRemoved = index2;
            while (state != 0 && (state == 2 || set[index2] != key)) {
                if ((index2 -= probe) < 0) {
                    index2 += length;
                }
                state = states[index2];
            }
            if (state == 1) {
                return -index2 - 1;
            }
            set[index2] = key;
            states[index2] = 1;
            return firstRemoved;
        }
        if (state == 1) {
            return -index2 - 1;
        }
        this.consumeFreeSlot = true;
        set[index2] = key;
        states[index2] = 1;
        return index2;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        super.writeExternal(out);
        out.writeChar(this.no_entry_key);
        out.writeDouble(this.no_entry_value);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        super.readExternal(in);
        this.no_entry_key = in.readChar();
        this.no_entry_value = in.readDouble();
    }
}

