/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.util.List;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.domain.LocalProteinDomainParser;
import org.biojava.bio.structure.domain.pdp.Domain;
import org.biojava.bio.structure.domain.pdp.Segment;
import org.biojava.bio.structure.io.FileParsingParameters;
import org.biojava.bio.structure.io.PDBFileReader;

public class DemoDomainsplit {
    public static void main(String[] args) {
        DemoDomainsplit split2 = new DemoDomainsplit();
        String pdbId = "4hhb";
        split2.basicLoad(pdbId);
    }

    public void basicLoad(String pdbId) {
        try {
            PDBFileReader reader = new PDBFileReader();
            reader.setPath("/tmp/");
            reader.setPdbDirectorySplit(true);
            reader.setAutoFetch(true);
            FileParsingParameters params = new FileParsingParameters();
            params.setAlignSeqRes(true);
            params.setLoadChemCompInfo(true);
            params.setParseSecStruc(false);
            reader.setFileParsingParameters(params);
            Structure struc = reader.getStructureById(pdbId);
            System.out.println("structure loaded: " + struc);
            List<Domain> domains = LocalProteinDomainParser.suggestDomains(struc);
            System.out.println("RESULTS: =====");
            for (Domain dom : domains) {
                System.out.println("DOMAIN:" + dom.getSize() + " " + dom.getScore());
                List<Segment> segments = dom.getSegments();
                for (Segment s : segments) {
                    System.out.println("   Segment: " + s);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

