/*
 * Decompiled with CFR 0.152.
 */
package com.clineff.testCases;

import com.clineff.commandLine.ClinEff;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.VcfEffect;
import org.snpeff.vcf.VcfEntry;

public class TestCasesIntegrationCommandLine
extends TestCase {
    public static boolean verbose = false;
    public static final String DIR = "test/integration/commandLine";

    List<VcfEntry> clinEff(String[] args) {
        ClinEff clinEff = new ClinEff(args);
        clinEff.setLog(false);
        clinEff.setVerbose(verbose);
        clinEff.setSuppressOutput(!verbose);
        clinEff.setSuppressReports(true);
        clinEff.setSaveResults(true);
        boolean ok = clinEff.run();
        Assert.assertTrue("ClinEff finished with errors. OK: " + ok, ok);
        return clinEff.getResults();
    }

    public void test_01() {
        Gpr.debug("Test");
        String[] args = new String[]{"-c", "test/integration/commandLine/clinEff_01.config", "-w", "test/integration/commandLine/workflow_01.config", "testHg19Chr17", "test/integration/commandLine/test_01.vcf"};
        List<VcfEntry> res = this.clinEff(args);
        VcfEntry ve = res.get(0);
        VcfEffect veff = ve.getVcfEffects().get(0);
        Assert.assertEquals("p.Gln1055*", veff.getHgvsP());
    }

    public void test_02() {
        Gpr.debug("Test");
        String[] args = new String[]{"-c", "test/integration/commandLine/clinEff_01.config", "-w", "test/integration/commandLine/workflow_02.config", "testHg19Chr1", "test/integration/commandLine/test_02.vcf"};
        List<VcfEntry> res = this.clinEff(args);
        VcfEntry ve = res.get(0);
        Assert.assertEquals("5.43478e-03", ve.getInfo("gnomAD_AF_POPMAX"));
    }
}

