/*
 * Decompiled with CFR 0.152.
 */
package com.clineff.report;

import com.clineff.clinvar.ClinSig;
import com.clineff.clinvar.ClinVarEntry;
import com.clineff.report.ReportVcfEffect;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.vcf.VcfEffect;
import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfLof;

public class ReportClinical
extends ReportVcfEffect {
    protected List<ClinVarEntry> clinVarPathogenic = new LinkedList<ClinVarEntry>();
    protected List<ClinVarEntry> clinVarLikelyPathogenic = new LinkedList<ClinVarEntry>();
    protected List<ClinVarEntry> clinVarDrugResponse = new LinkedList<ClinVarEntry>();
    protected List<VcfLof> vcfLofs = new LinkedList<VcfLof>();
    protected List<VcfEffect> vcfEffects = new LinkedList<VcfEffect>();

    boolean addClinVar(VcfEntry vcfEntry) {
        String clinsigStr = vcfEntry.getInfo("CLNSIG");
        boolean ok = false;
        if (clinsigStr != null) {
            String[] stringArray = clinsigStr.split("\\|");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String cs = stringArray[n2];
                ClinSig clnsig = ClinSig.parse(cs);
                switch (clnsig) {
                    case LIKELY_PATHOGENIC: {
                        this.clinVarLikelyPathogenic.add(new ClinVarEntry(vcfEntry));
                        ok = true;
                        break;
                    }
                    case PATHOGENIC: {
                        this.clinVarPathogenic.add(new ClinVarEntry(vcfEntry));
                        ok = true;
                        break;
                    }
                    case DRUG_RESPONSE: {
                        this.clinVarDrugResponse.add(new ClinVarEntry(vcfEntry));
                        ok = true;
                        break;
                    }
                }
                ++n2;
            }
        }
        return ok;
    }

    boolean addLof(VcfEntry vcfEntry) {
        List<VcfLof> lofs = vcfEntry.parseLof();
        this.vcfLofs.addAll(lofs);
        return !lofs.isEmpty();
    }

    @Override
    public boolean filter(VcfEffect veff) {
        return veff.getImpact() == VariantEffect.EffectImpact.HIGH;
    }

    @Override
    public boolean filter(VcfEntry vcfEntry) {
        ++this.countVcfEntries;
        if (!vcfEntry.getFilter().isEmpty() && !vcfEntry.isFilterPass()) {
            return false;
        }
        if (!vcfEntry.isVariant()) {
            return false;
        }
        boolean ok = false;
        ok |= this.addClinVar(vcfEntry);
        ok |= this.addLof(vcfEntry);
        for (VcfEffect veff : vcfEntry.getVcfEffects()) {
            if (!this.filter(veff)) continue;
            this.vcfEffects.add(veff);
            ok |= true;
        }
        return ok;
    }

    @Override
    protected HashMap<String, Object> reportHash(String sampleName) {
        HashMap<String, Object> data2 = super.reportHash(sampleName);
        data2.put("clinVarPathogenic", this.clinVarPathogenic);
        data2.put("clinVarLikelyPathogenic", this.clinVarLikelyPathogenic);
        data2.put("clinVarDrugResponse", this.clinVarDrugResponse);
        data2.put("vcfLofs", this.vcfLofs);
        data2.put("vcfEffects", this.vcfEffects);
        data2.put("countPathogenic", this.clinVarPathogenic.size());
        data2.put("countLikelyPathogenic", this.clinVarLikelyPathogenic.size());
        data2.put("countDrugResponse", this.clinVarDrugResponse.size());
        data2.put("countLof", this.vcfLofs.size());
        data2.put("countHigh", this.vcfEffects.size());
        return data2;
    }
}

