/*
 * Decompiled with CFR 0.152.
 */
package com.clineff;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.snpeff.SnpEff;
import org.snpsift.SnpSiftCmdAnnotate;
import org.snpsift.SnpSiftCmdCaseControl;
import org.snpsift.SnpSiftCmdDbNsfp;
import org.snpsift.SnpSiftCmdFilter;
import org.snpsift.SnpSiftCmdFilterChrPos;
import org.snpsift.SnpSiftCmdFilterGt;
import org.snpsift.SnpSiftCmdGeneSets;
import org.snpsift.SnpSiftCmdGt;
import org.snpsift.SnpSiftCmdGwasCatalog;
import org.snpsift.SnpSiftCmdIntervals;
import org.snpsift.SnpSiftCmdIntervalsIndex;
import org.snpsift.SnpSiftCmdPrivate;
import org.snpsift.SnpSiftCmdRemoveReferenceGenotypes;
import org.snpsift.SnpSiftCmdRmInfo;
import org.snpsift.SnpSiftCmdVarType;
import org.snpsift.SnpSiftCmdVcfOperator;
import org.snpsift.hwe.SnpSiftCmdHwe;

public class ModuleNamesMap {
    private static ModuleNamesMap instance;
    private Map<String, Class> name2class = new HashMap<String, Class>();
    private Map<String, Set<String>> names = new HashMap<String, Set<String>>();

    public static ModuleNamesMap get() {
        if (instance == null) {
            instance = new ModuleNamesMap();
        }
        return instance;
    }

    private ModuleNamesMap() {
        this.add("ann", SnpEff.class);
        this.add("annotate", SnpSiftCmdAnnotate.class);
        this.add("caseControl", SnpSiftCmdCaseControl.class);
        this.add("dbNsfp", SnpSiftCmdDbNsfp.class);
        this.add("filter", SnpSiftCmdFilter.class);
        this.add("filterChrPos", SnpSiftCmdFilterChrPos.class);
        this.add("filterGt", SnpSiftCmdFilterGt.class);
        this.add("geneSets", SnpSiftCmdGeneSets.class);
        this.add("gt", SnpSiftCmdGt.class);
        this.add("gwasCatalog", SnpSiftCmdGwasCatalog.class);
        this.add("hwe", SnpSiftCmdHwe.class);
        this.add("intervals", SnpSiftCmdIntervals.class);
        this.add("intervalsIdx", SnpSiftCmdIntervalsIndex.class);
        this.add("op", SnpSiftCmdVcfOperator.class);
        this.add("private", SnpSiftCmdPrivate.class);
        this.add("rmInfo", SnpSiftCmdRmInfo.class);
        this.add("rmRef", SnpSiftCmdRemoveReferenceGenotypes.class);
        this.add("varType", SnpSiftCmdVarType.class);
    }

    private void add(String name, Class classToAdd) {
        this.name2class.put(name, classToAdd);
        this.name2class.put(name.toLowerCase(), classToAdd);
        String className = classToAdd.getCanonicalName();
        this.name2class.put(className, classToAdd);
        String classSimpleName = classToAdd.getSimpleName();
        this.name2class.put(classSimpleName, classToAdd);
        String[] namesToAdd = new String[]{name, name.toLowerCase(), className, classSimpleName};
        int i = 0;
        while (i < namesToAdd.length) {
            int j = 0;
            while (j < namesToAdd.length) {
                this.addName(namesToAdd[i], namesToAdd[j]);
                ++j;
            }
            ++i;
        }
    }

    private void addName(String name1, String name2) {
        Set<String> namesAdded = this.names.get(name1);
        if (namesAdded == null) {
            namesAdded = new HashSet<String>();
            this.names.put(name1, namesAdded);
        }
        namesAdded.add(name2);
    }

    public Class getModuleClass(String name) {
        return ModuleNamesMap.get().name2class.get(name);
    }

    public Set<String> getModuleNames(String name) {
        return ModuleNamesMap.get().names.get(name);
    }
}

