/*
 * Decompiled with CFR 0.152.
 */
package DistLib;

import DistLib.misc;
import DistLib.uniform;

public class beta {
    static double zero = 0.0;
    static double fpu = 3.0E-308;
    static double acu_min = 1.0E-300;
    static double lower = fpu;
    static double upper = 0.9999999999999998;
    static double const1 = 2.30753;
    static double const2 = 0.27061;
    static double const3 = 0.99229;
    static double const4 = 0.04481;
    static volatile double xtrunc;

    public static double density(double x2, double a, double b) {
        if (Double.isNaN(x2) || Double.isNaN(a) || Double.isNaN(b)) {
            return x2 + a + b;
        }
        if (a <= 0.0 || b <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 < 0.0) {
            return 0.0;
        }
        if (x2 > 1.0) {
            return 0.0;
        }
        double y = misc.beta(a, b);
        a = Math.pow(x2, a - 1.0);
        b = Math.pow(1.0 - x2, b - 1.0);
        return a * b / y;
    }

    static double pbeta_raw(double x2, double pin, double qin) {
        double ans;
        double eps = 0.0;
        double alneps = 0.0;
        double sml = 0.0;
        double alnsml = 0.0;
        if (eps == 0.0) {
            eps = misc.d1mach(3);
            alneps = Math.log(eps);
            sml = misc.d1mach(1);
            alnsml = Math.log(sml);
        }
        double y = x2;
        double p = pin;
        double q = qin;
        if (p / (p + q) < x2) {
            y = 1.0 - y;
            p = qin;
            q = pin;
        }
        if ((p + q) * y / (p + 1.0) < eps) {
            ans = 0.0;
            double xb = p * Math.log(Math.max(y, sml)) - Math.log(p) - misc.lbeta(p, q);
            if (xb > alnsml && y != 0.0) {
                ans = Math.exp(xb);
            }
            if (y != x2 || p != pin) {
                ans = 1.0 - ans;
            }
        } else {
            double xi;
            int i;
            int n;
            double term;
            double ps = q - Math.floor(q);
            if (ps == 0.0) {
                ps = 1.0;
            }
            double xb = p * Math.log(y) - misc.lbeta(ps, p) - Math.log(p);
            ans = 0.0;
            if (xb >= alnsml) {
                ans = Math.exp(xb);
                term = ans * p;
                if (ps != 1.0) {
                    n = (int)Math.max(alneps / Math.log(y), 4.0);
                    i = 1;
                    while (i <= n) {
                        xi = i;
                        term = term * (xi - ps) * y / xi;
                        ans += term / (p + xi);
                        ++i;
                    }
                }
            }
            if (q > 1.0) {
                xb = p * Math.log(y) + q * Math.log(1.0 - y) - misc.lbeta(p, q) - Math.log(q);
                int ib = (int)Math.max(xb / alnsml, 0.0);
                term = Math.exp(xb - (double)ib * alnsml);
                double c = 1.0 / (1.0 - y);
                double p1 = q * c / (p + q - 1.0);
                double finsum = 0.0;
                n = (int)q;
                if (q == (double)n) {
                    --n;
                }
                i = 1;
                while (i <= n) {
                    if (p1 <= 1.0 && term / eps <= finsum) break;
                    xi = i;
                    if ((term = (q - xi + 1.0) * c * term / (p + q - xi)) > 1.0) {
                        --ib;
                        term *= sml;
                    }
                    if (ib == 0) {
                        finsum += term;
                    }
                    ++i;
                }
                ans += finsum;
            }
            if (y != x2 || p != pin) {
                ans = 1.0 - ans;
            }
            ans = Math.max(Math.min(ans, 1.0), 0.0);
        }
        return ans;
    }

    public static double cumulative(double x2, double pin, double qin) {
        if (Double.isNaN(x2) || Double.isNaN(pin) || Double.isNaN(qin)) {
            return x2 + pin + qin;
        }
        if (pin <= 0.0 || qin <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 <= 0.0) {
            return 0.0;
        }
        if (x2 >= 1.0) {
            return 1.0;
        }
        return beta.pbeta_raw(x2, pin, qin);
    }

    public static double quantile(double alpha, double p, double q) {
        boolean swap_tail;
        double xinbta;
        block18: {
            double prev;
            double t2;
            double qq;
            double pp;
            double a;
            xinbta = alpha;
            if (Double.isNaN(p) || Double.isNaN(q) || Double.isNaN(alpha)) {
                return p + q + alpha;
            }
            if (p < zero || q < zero || alpha < zero || alpha > 1.0) {
                throw new ArithmeticException("Math Error: DOMAIN");
            }
            if (alpha == zero || alpha == 1.0) {
                return alpha;
            }
            double logbeta = misc.lbeta(p, q);
            if (alpha <= 0.5) {
                a = alpha;
                pp = p;
                qq = q;
                swap_tail = false;
            } else {
                a = 1.0 - alpha;
                pp = q;
                qq = p;
                swap_tail = true;
            }
            double r = Math.sqrt(-Math.log(a * a));
            double y = r - (const1 + const2 * r) / (1.0 + (const3 + const4 * r) * r);
            if (pp > 1.0 && qq > 1.0) {
                r = (y * y - 3.0) / 6.0;
                double s = 1.0 / (pp + pp - 1.0);
                t2 = 1.0 / (qq + qq - 1.0);
                double h = 2.0 / (s + t2);
                double w = y * Math.sqrt(h + r) / h - (t2 - s) * (r + 0.0 - 2.0 / (3.0 * h));
                xinbta = pp / (pp + qq * Math.exp(w + w));
            } else {
                r = qq + qq;
                t2 = 1.0 / (9.0 * qq);
                xinbta = (t2 = r * Math.pow(1.0 - t2 + y * Math.sqrt(t2), 3.0)) <= zero ? 1.0 - Math.exp((Math.log((1.0 - a) * qq) + logbeta) / qq) : ((t2 = (4.0 * pp + r - 2.0) / t2) <= 1.0 ? Math.exp((Math.log(a * pp) + logbeta) / pp) : 1.0 - 2.0 / (t2 + 1.0));
            }
            r = 1.0 - pp;
            t2 = 1.0 - qq;
            double yprev = zero;
            double adj = 1.0;
            if (xinbta < lower) {
                xinbta = lower;
            } else if (xinbta > upper) {
                xinbta = upper;
            }
            double acu = Math.max(acu_min, Math.pow(10.0, -13.0 - 2.5 / (pp * pp) - 0.5 / (a * a)));
            double tx = prev = zero;
            int i_pb = 0;
            while (i_pb < 1000) {
                y = beta.pbeta_raw(xinbta, pp, qq);
                if (Double.isInfinite(y)) {
                    y = (y - a) * Math.exp(logbeta + r * Math.log(xinbta) + t2 * Math.log(1.0 - xinbta));
                }
                if (y * yprev <= zero) {
                    prev = Math.max(Math.abs(adj), fpu);
                }
                double g = 1.0;
                int i_inn = 0;
                while (i_inn < 1000) {
                    adj = g * y;
                    if (Math.abs(adj) < prev && (tx = xinbta - adj) >= zero && tx <= 1.0) {
                        if (!(prev <= acu) && !(Math.abs(y) <= acu)) {
                            if (tx != zero && tx != 1.0) break;
                        }
                        break block18;
                    }
                    g /= 3.0;
                    ++i_inn;
                }
                xtrunc = tx;
                if (xtrunc != xinbta) {
                    xinbta = tx;
                    yprev = y;
                    ++i_pb;
                    continue;
                }
                break block18;
            }
            throw new ArithmeticException("Math Error: PRECISION");
        }
        if (swap_tail) {
            xinbta = 1.0 - xinbta;
        }
        return xinbta;
    }

    public static double random(double aa, double bb, uniform PRNG) {
        double w;
        double b;
        double a;
        block14: {
            boolean qsame;
            double gamma2;
            double beta2;
            double alpha;
            double z;
            double v;
            double u2;
            double u1;
            double t2;
            double s;
            double r;
            double expmax;
            block13: {
                block12: {
                    expmax = 0.0;
                    a = 0.0;
                    b = 0.0;
                    double delta = 0.0;
                    r = 0.0;
                    s = 0.0;
                    t2 = 0.0;
                    u1 = 0.0;
                    u2 = 0.0;
                    v = 0.0;
                    w = 0.0;
                    double y = 0.0;
                    z = 0.0;
                    alpha = 0.0;
                    beta2 = 0.0;
                    gamma2 = 0.0;
                    double k1 = 0.0;
                    double k2 = 0.0;
                    double olda = -1.0;
                    double oldb = -1.0;
                    if (expmax == 0.0) {
                        expmax = Math.log(Double.MAX_VALUE);
                    }
                    boolean bl = qsame = olda == aa && oldb == bb;
                    if (!qsame) {
                        if (aa > 0.0 && bb > 0.0) {
                            olda = aa;
                            oldb = bb;
                        } else {
                            throw new ArithmeticException("Math Error: DOMAIN");
                        }
                    }
                    if (!(Math.min(aa, bb) <= 1.0)) break block13;
                    if (!qsame) {
                        a = Math.max(aa, bb);
                        b = Math.min(aa, bb);
                        alpha = a + b;
                        beta2 = 1.0 / b;
                        delta = 1.0 + a - b;
                        k1 = delta * (0.0138889 + 0.0416667 * b) / (a * beta2 - 0.777778);
                        k2 = 0.25 + (0.5 + 0.25 / delta) * b;
                    }
                    while (true) {
                        u1 = uniform.random();
                        u2 = uniform.random();
                        if (u1 < 0.5) {
                            y = u1 * u2;
                            z = u1 * y;
                            if (0.25 * u2 + z - y >= k1) {
                                continue;
                            }
                        } else {
                            z = u1 * u1 * u2;
                            if (!(z <= 0.25)) {
                                if (z >= k2) continue;
                            }
                            break block12;
                        }
                        if (alpha * (Math.log(alpha / (b + (w = (v = beta2 * Math.log(u1 / (1.0 - u1))) <= expmax ? a * Math.exp(v) : Double.MAX_VALUE))) + v) - 1.3862944 >= Math.log(z)) break;
                    }
                    break block14;
                }
                v = beta2 * Math.log(u1 / (1.0 - u1));
                w = v <= expmax ? a * Math.exp(v) : Double.MAX_VALUE;
                break block14;
            }
            if (!qsame) {
                a = Math.min(aa, bb);
                b = Math.max(aa, bb);
                alpha = a + b;
                beta2 = Math.sqrt((alpha - 2.0) / (2.0 * a * b - alpha));
                gamma2 = a + 1.0 / beta2;
            }
            do {
                u1 = uniform.random();
                u2 = uniform.random();
            } while (!((s = a + (r = gamma2 * v - 1.3862944) - (w = (v = beta2 * Math.log(u1 / (1.0 - u1))) <= expmax ? a * Math.exp(v) : Double.MAX_VALUE)) + 2.609438 >= 5.0 * (z = u1 * u1 * u2)) && !(s > (t2 = Math.log(z))) && r + alpha * Math.log(alpha / (b + w)) < t2);
        }
        return aa != a ? b / (b + w) : w / (b + w);
    }
}

